/*
 * Decompiled with CFR 0.152.
 */
package org.mov.parser.expression;

import org.mov.parser.EvaluationException;
import org.mov.parser.Expression;
import org.mov.parser.TypeMismatchException;
import org.mov.parser.Variables;
import org.mov.parser.expression.BinaryExpression;
import org.mov.parser.expression.QuoteExpression;
import org.mov.quote.QuoteBundle;
import org.mov.quote.QuoteBundleFunctionSource;
import org.mov.quote.QuoteFunctions;
import org.mov.quote.Symbol;

public class MACDExpression
extends BinaryExpression {
    public static final int PERIOD_SLOW = 26;
    public static final int PERIOD_FAST = 12;
    static final /* synthetic */ boolean $assertionsDisabled;

    public MACDExpression(Expression quote, Expression lag) {
        super(quote, lag);
    }

    public double evaluate(Variables variables, QuoteBundle quoteBundle, Symbol symbol, int day) throws EvaluationException {
        int quoteKind = ((QuoteExpression)this.getChild(0)).getQuoteKind();
        int offset = (int)this.getChild(1).evaluate(variables, quoteBundle, symbol, day);
        if (offset > 0) {
            throw EvaluationException.MACD_OFFSET_EXCEPTION;
        }
        QuoteBundleFunctionSource sourceSlow = new QuoteBundleFunctionSource(quoteBundle, symbol, quoteKind, day, offset, 26);
        QuoteBundleFunctionSource sourceFast = new QuoteBundleFunctionSource(quoteBundle, symbol, quoteKind, day, offset, 12);
        return QuoteFunctions.macd(sourceSlow, sourceFast);
    }

    public String toString() {
        return new String("macd(" + ((Object)this.getChild(0)).toString() + ", " + ((Object)this.getChild(1)).toString() + ")");
    }

    public int checkType() throws TypeMismatchException {
        if ((this.getChild(0).checkType() == 3 || this.getChild(0).checkType() == 4) && this.getChild(1).checkType() == 2) {
            return this.getType();
        }
        throw new TypeMismatchException();
    }

    public int getType() {
        if (this.getChild(0).getType() == 3) {
            return 1;
        }
        if (!$assertionsDisabled && this.getChild(0).getType() != 4) {
            throw new AssertionError();
        }
        return 2;
    }

    public Object clone() {
        return new MACDExpression((Expression)this.getChild(0).clone(), (Expression)this.getChild(1).clone());
    }

    static {
        $assertionsDisabled = !MACDExpression.class.desiredAssertionStatus();
    }
}

