/*
 * Decompiled with CFR 0.152.
 */
package org.mov.parser.expression;

import org.mov.parser.EvaluationException;
import org.mov.parser.Expression;
import org.mov.parser.TypeMismatchException;
import org.mov.parser.Variables;
import org.mov.parser.expression.QuoteExpression;
import org.mov.parser.expression.TernaryExpression;
import org.mov.quote.MissingQuoteException;
import org.mov.quote.QuoteBundle;
import org.mov.quote.Symbol;

public class MinExpression
extends TernaryExpression {
    static final /* synthetic */ boolean $assertionsDisabled;

    public MinExpression(Expression quote, Expression days, Expression lag) {
        super(quote, days, lag);
    }

    public double evaluate(Variables variables, QuoteBundle quoteBundle, Symbol symbol, int day) throws EvaluationException {
        int days = (int)this.getChild(1).evaluate(variables, quoteBundle, symbol, day);
        if (days <= 0) {
            throw EvaluationException.MIN_RANGE_EXCEPTION;
        }
        int quoteKind = ((QuoteExpression)this.getChild(0)).getQuoteKind();
        int offset = (int)this.getChild(2).evaluate(variables, quoteBundle, symbol, day);
        if (offset > 0) {
            throw EvaluationException.MIN_OFFSET_EXCEPTION;
        }
        return this.min(quoteBundle, symbol, quoteKind, days, day, offset);
    }

    public String toString() {
        return new String("min(" + ((Object)this.getChild(0)).toString() + ", " + ((Object)this.getChild(1)).toString() + ", " + ((Object)this.getChild(2)).toString() + ")");
    }

    public int checkType() throws TypeMismatchException {
        if ((this.getChild(0).checkType() == 3 || this.getChild(0).checkType() == 4) && this.getChild(1).checkType() == 2 && this.getChild(2).checkType() == 2) {
            return this.getType();
        }
        throw new TypeMismatchException();
    }

    public int getType() {
        if (this.getChild(0).getType() == 3) {
            return 1;
        }
        if (!$assertionsDisabled && this.getChild(0).getType() != 4) {
            throw new AssertionError();
        }
        return 2;
    }

    private double min(QuoteBundle quoteBundle, Symbol symbol, int quote, int days, int day, int offset) throws EvaluationException {
        double min = Double.MAX_VALUE;
        for (int i = offset - days + 1; i <= offset; ++i) {
            try {
                double value = quoteBundle.getQuote(symbol, quote, day, i);
                if (!(value < min)) continue;
                min = value;
                continue;
            }
            catch (MissingQuoteException e) {
                // empty catch block
            }
        }
        return min;
    }

    public Object clone() {
        return new MinExpression((Expression)this.getChild(0).clone(), (Expression)this.getChild(1).clone(), (Expression)this.getChild(2).clone());
    }

    static {
        $assertionsDisabled = !MinExpression.class.desiredAssertionStatus();
    }
}

