/*
 * Decompiled with CFR 0.152.
 */
package org.mov.parser.expression;

import java.text.NumberFormat;
import org.mov.parser.Expression;
import org.mov.parser.Variables;
import org.mov.parser.expression.AbstractExpression;
import org.mov.parser.expression.TerminalExpression;
import org.mov.quote.QuoteBundle;
import org.mov.quote.Symbol;

public class NumberExpression
extends TerminalExpression {
    private double value;
    private int type;
    private static final double EPSILON = (double)0.001f;
    private static NumberFormat format;
    static final /* synthetic */ boolean $assertionsDisabled;

    public NumberExpression(boolean value) {
        this.value = value ? 1.0 : 0.0;
        this.type = 0;
    }

    public NumberExpression(double value) {
        this.value = value;
        this.type = 1;
    }

    public NumberExpression(int value) {
        this.value = value;
        this.type = 2;
    }

    public NumberExpression(double value, int type) {
        if (!$assertionsDisabled && type != 0 && type != 1 && type != 2) {
            throw new AssertionError();
        }
        this.value = value;
        this.type = type;
    }

    public double evaluate(Variables variables, QuoteBundle quoteBundle, Symbol symbol, int day) {
        return this.value;
    }

    public static String toString(int type, double value) {
        switch (type) {
            case 0: {
                if (value >= 0.1) {
                    return "true";
                }
                return "false";
            }
            case 1: {
                return format.format(value);
            }
        }
        if (!$assertionsDisabled && type != 2) {
            throw new AssertionError();
        }
        return Integer.toString((int)value);
    }

    public String toString() {
        return NumberExpression.toString(this.getType(), this.value);
    }

    public boolean equals(double value) {
        return Math.abs(this.value - value) < (double)0.001f;
    }

    public boolean equals(Object object) {
        NumberExpression expression;
        return object instanceof NumberExpression && (expression = (NumberExpression)object).getValue() == this.getValue() && expression.getType() == this.getType();
    }

    public static boolean isConstant(Expression expression, int value) {
        NumberExpression numberExpression;
        return expression instanceof NumberExpression && (int)(numberExpression = (NumberExpression)expression).getValue() == value;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public int getType() {
        return this.type;
    }

    public Object clone() {
        return new NumberExpression(this.value, this.type);
    }

    static {
        $assertionsDisabled = !NumberExpression.class.desiredAssertionStatus();
        format = AbstractExpression.getNumberFormat();
    }
}

