/*
 * Decompiled with CFR 0.152.
 */
package org.mov.parser.expression;

import org.mov.parser.EvaluationException;
import org.mov.parser.Expression;
import org.mov.parser.TypeMismatchException;
import org.mov.parser.Variables;
import org.mov.parser.expression.TernaryExpression;
import org.mov.quote.QuoteBundle;
import org.mov.quote.QuoteBundleFunctionSource;
import org.mov.quote.QuoteFunctions;
import org.mov.quote.Symbol;

public class OBVExpression
extends TernaryExpression {
    public OBVExpression(Expression days, Expression lag, Expression initialValue) {
        super(days, lag, initialValue);
    }

    public double evaluate(Variables variables, QuoteBundle quoteBundle, Symbol symbol, int day) throws EvaluationException {
        int period = (int)this.getChild(0).evaluate(variables, quoteBundle, symbol, day);
        if (period <= 0) {
            throw EvaluationException.OBV_RANGE_EXCEPTION;
        }
        int offset = (int)this.getChild(1).evaluate(variables, quoteBundle, symbol, day);
        if (offset > 0) {
            throw EvaluationException.OBV_OFFSET_EXCEPTION;
        }
        int initialValue = (int)this.getChild(2).evaluate(variables, quoteBundle, symbol, day);
        QuoteBundleFunctionSource sourceOpen = new QuoteBundleFunctionSource(quoteBundle, symbol, 1, day, offset, period);
        QuoteBundleFunctionSource sourceClose = new QuoteBundleFunctionSource(quoteBundle, symbol, 0, day, offset, period);
        QuoteBundleFunctionSource sourceVolume = new QuoteBundleFunctionSource(quoteBundle, symbol, 4, day, offset, period);
        return QuoteFunctions.obv(sourceOpen, sourceClose, sourceVolume, period, initialValue);
    }

    public String toString() {
        return new String("obv(" + ((Object)this.getChild(0)).toString() + ", " + ((Object)this.getChild(1)).toString() + ", " + ((Object)this.getChild(2)).toString() + ")");
    }

    public int checkType() throws TypeMismatchException {
        if (this.getChild(0).checkType() == 2 && this.getChild(1).checkType() == 2 && this.getChild(2).checkType() == 2) {
            return this.getType();
        }
        throw new TypeMismatchException();
    }

    public int getType() {
        return 2;
    }

    public Object clone() {
        return new OBVExpression((Expression)this.getChild(0).clone(), (Expression)this.getChild(1).clone(), (Expression)this.getChild(2).clone());
    }
}

