/*
 * Decompiled with CFR 0.152.
 */
package org.mov.parser.expression;

import org.mov.parser.EvaluationException;
import org.mov.parser.Expression;
import org.mov.parser.Variables;
import org.mov.parser.expression.LogicExpression;
import org.mov.parser.expression.NumberExpression;
import org.mov.quote.QuoteBundle;
import org.mov.quote.Symbol;

public class OrExpression
extends LogicExpression {
    public OrExpression(Expression left, Expression right) {
        super(left, right);
    }

    public double evaluate(Variables variables, QuoteBundle quoteBundle, Symbol symbol, int day) throws EvaluationException {
        if (this.getChild(0).evaluate(variables, quoteBundle, symbol, day) >= 0.1 || this.getChild(1).evaluate(variables, quoteBundle, symbol, day) >= 0.1) {
            return 1.0;
        }
        return 0.0;
    }

    public Expression simplify() {
        NumberExpression right;
        super.simplify();
        NumberExpression left = this.getChild(0) instanceof NumberExpression ? (NumberExpression)this.getChild(0) : null;
        NumberExpression numberExpression = right = this.getChild(1) instanceof NumberExpression ? (NumberExpression)this.getChild(1) : null;
        if (left != null && left.getValue() >= 0.1 || right != null && right.getValue() >= 0.1) {
            return new NumberExpression(true);
        }
        if (left != null && left.getValue() < 0.1) {
            return this.getChild(1);
        }
        if (right != null && right.getValue() < 0.1) {
            return this.getChild(0);
        }
        if (((Object)this.getChild(0)).equals(this.getChild(1))) {
            return this.getChild(0);
        }
        return this;
    }

    public boolean equals(Object object) {
        if (object instanceof OrExpression) {
            OrExpression expression = (OrExpression)object;
            if (((Object)this.getChild(0)).equals(expression.getChild(0)) && ((Object)this.getChild(1)).equals(expression.getChild(1))) {
                return true;
            }
            if (((Object)this.getChild(0)).equals(expression.getChild(1)) && ((Object)this.getChild(1)).equals(expression.getChild(0))) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return super.toString("or");
    }

    public Object clone() {
        return new OrExpression((Expression)this.getChild(0).clone(), (Expression)this.getChild(1).clone());
    }
}

