/*
 * Decompiled with CFR 0.152.
 */
package org.mov.parser.expression;

import org.mov.parser.EvaluationException;
import org.mov.parser.Expression;
import org.mov.parser.TypeMismatchException;
import org.mov.parser.Variables;
import org.mov.parser.expression.BinaryExpression;
import org.mov.parser.expression.NumberExpression;
import org.mov.quote.QuoteBundle;
import org.mov.quote.Symbol;

public class PercentExpression
extends BinaryExpression {
    static final /* synthetic */ boolean $assertionsDisabled;

    public PercentExpression(Expression left, Expression right) {
        super(left, right);
    }

    public double evaluate(Variables variables, QuoteBundle quoteBundle, Symbol symbol, int day) throws EvaluationException {
        double value = this.getChild(0).evaluate(variables, quoteBundle, symbol, day);
        double percent = this.getChild(1).evaluate(variables, quoteBundle, symbol, day);
        return value * percent / 100.0;
    }

    public Expression simplify() {
        super.simplify();
        if (this.getChild(0) instanceof NumberExpression && this.getChild(1) instanceof NumberExpression) {
            try {
                return new NumberExpression(this.evaluate(null, null, null, 0), this.getType());
            }
            catch (EvaluationException e) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                return this;
            }
        }
        return this;
    }

    public String toString() {
        return new String("percent(" + ((Object)this.getChild(0)).toString() + ", " + ((Object)this.getChild(1)).toString() + ")");
    }

    public int checkType() throws TypeMismatchException {
        int leftType = this.getChild(0).checkType();
        int rightType = this.getChild(1).checkType();
        if (!(leftType != 1 && leftType != 2 || rightType != 1 && rightType != 2)) {
            return this.getType();
        }
        throw new TypeMismatchException();
    }

    public int getType() {
        return this.getChild(0).getType();
    }

    public Object clone() {
        return new PercentExpression((Expression)this.getChild(0).clone(), (Expression)this.getChild(1).clone());
    }

    static {
        $assertionsDisabled = !PercentExpression.class.desiredAssertionStatus();
    }
}

