/*
 * Decompiled with CFR 0.152.
 */
package org.mov.parser.expression;

import org.mov.parser.EvaluationException;
import org.mov.parser.Variables;
import org.mov.parser.expression.TerminalExpression;
import org.mov.quote.MissingQuoteException;
import org.mov.quote.QuoteBundle;
import org.mov.quote.Symbol;

public class QuoteExpression
extends TerminalExpression {
    private int quoteKind;
    static final /* synthetic */ boolean $assertionsDisabled;

    public QuoteExpression(int quoteKind) {
        if (!$assertionsDisabled && quoteKind != 1 && quoteKind != 0 && quoteKind != 2 && quoteKind != 3 && quoteKind != 4) {
            throw new AssertionError();
        }
        this.quoteKind = quoteKind;
    }

    public int getQuoteKind() {
        return this.quoteKind;
    }

    public int getType() {
        if (this.getQuoteKind() == 4) {
            return 4;
        }
        return 3;
    }

    public double evaluate(Variables variables, QuoteBundle quoteBundle, Symbol symbol, int day) throws EvaluationException {
        try {
            return quoteBundle.getQuote(symbol, this.getQuoteKind(), day, 0);
        }
        catch (MissingQuoteException e) {
            return 0.0;
        }
    }

    public String toString() {
        switch (this.quoteKind) {
            case 1: {
                return "open";
            }
            case 0: {
                return "close";
            }
            case 3: {
                return "high";
            }
            case 2: {
                return "low";
            }
        }
        if (!$assertionsDisabled && this.quoteKind != 4) {
            throw new AssertionError();
        }
        return "volume";
    }

    public Object clone() {
        return new QuoteExpression(this.quoteKind);
    }

    static {
        $assertionsDisabled = !QuoteExpression.class.desiredAssertionStatus();
    }
}

