/*
 * Decompiled with CFR 0.152.
 */
package org.mov.parser.expression;

import org.mov.parser.EvaluationException;
import org.mov.parser.Expression;
import org.mov.parser.TypeMismatchException;
import org.mov.parser.Variables;
import org.mov.parser.expression.BinaryExpression;
import org.mov.quote.QuoteBundle;
import org.mov.quote.QuoteBundleFunctionSource;
import org.mov.quote.QuoteFunctions;
import org.mov.quote.Symbol;

public class RSIExpression
extends BinaryExpression {
    public RSIExpression(Expression days, Expression lag) {
        super(days, lag);
    }

    public double evaluate(Variables variables, QuoteBundle quoteBundle, Symbol symbol, int day) throws EvaluationException {
        int period = (int)this.getChild(0).evaluate(variables, quoteBundle, symbol, day);
        if (period <= 0) {
            throw EvaluationException.RSI_RANGE_EXCEPTION;
        }
        int offset = (int)this.getChild(1).evaluate(variables, quoteBundle, symbol, day);
        if (offset > 0) {
            throw EvaluationException.RSI_OFFSET_EXCEPTION;
        }
        QuoteBundleFunctionSource source = new QuoteBundleFunctionSource(quoteBundle, symbol, 0, day, offset - 1, period - 1);
        return QuoteFunctions.rsi(source, period - 1);
    }

    public String toString() {
        Expression periodExpression = this.getChild(0);
        Expression lagExpression = this.getChild(1);
        return new String("rsi(" + ((Object)periodExpression).toString() + ", " + ((Object)lagExpression).toString() + ")");
    }

    public int checkType() throws TypeMismatchException {
        if (this.getChild(0).checkType() == 2 && this.getChild(1).checkType() == 2) {
            return 1;
        }
        throw new TypeMismatchException();
    }

    public int getType() {
        return 1;
    }

    public Object clone() {
        return new RSIExpression((Expression)this.getChild(0).clone(), (Expression)this.getChild(1).clone());
    }
}

