/*
 * Decompiled with CFR 0.152.
 */
package org.mov.parser.expression;

import org.mov.parser.EvaluationException;
import org.mov.parser.Expression;
import org.mov.parser.TypeMismatchException;
import org.mov.parser.Variable;
import org.mov.parser.Variables;
import org.mov.parser.expression.UnaryExpression;
import org.mov.quote.QuoteBundle;
import org.mov.quote.Symbol;
import org.mov.util.Locale;

public class SetVariableExpression
extends UnaryExpression {
    private String name;
    private int type;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SetVariableExpression(String name, int type, Expression value) {
        super(value);
        if (!($assertionsDisabled || name != null && name.length() > 0)) {
            throw new AssertionError();
        }
        this.name = name;
        this.type = type;
    }

    public double evaluate(Variables variables, QuoteBundle quoteBundle, Symbol symbol, int day) throws EvaluationException {
        Variable variable = variables.get(this.name);
        if (variable != null) {
            if (!variable.isConstant()) {
                if (!$assertionsDisabled && variable.getType() != this.type) {
                    throw new AssertionError();
                }
                double value = this.getChild(0).evaluate(variables, quoteBundle, symbol, day);
                variable.setValue(value);
                return value;
            }
            throw new EvaluationException(Locale.getString("VARIABLE_IS_CONSTANT_ERROR", this.name));
        }
        throw new EvaluationException(Locale.getString("VARIABLE_NOT_DEFINED_ERROR", this.name));
    }

    public String toString() {
        return new String(this.name + " = " + this.getChild(0));
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public int checkType() throws TypeMismatchException {
        if (this.getType() == this.getChild(0).checkType()) {
            return this.getType();
        }
        throw new TypeMismatchException();
    }

    public boolean equals(Object object) {
        SetVariableExpression expression;
        return object instanceof SetVariableExpression && (expression = (SetVariableExpression)object).getName().equals(this.getName()) && expression.getType() == this.getType() && ((Object)expression.getChild(0)).equals(this.getChild(0));
    }

    public Object clone() {
        return new SetVariableExpression(this.name, this.type, (Expression)this.getChild(0).clone());
    }

    static {
        $assertionsDisabled = !SetVariableExpression.class.desiredAssertionStatus();
    }
}

