/*
 * Decompiled with CFR 0.152.
 */
package org.mov.parser.expression;

import org.mov.parser.EvaluationException;
import org.mov.parser.Expression;
import org.mov.parser.TypeMismatchException;
import org.mov.parser.Variables;
import org.mov.parser.expression.NumberExpression;
import org.mov.parser.expression.UnaryExpression;
import org.mov.quote.QuoteBundle;
import org.mov.quote.Symbol;

public class SqrtExpression
extends UnaryExpression {
    public SqrtExpression(Expression number) {
        super(number);
    }

    public double evaluate(Variables variables, QuoteBundle quoteBundle, Symbol symbol, int day) throws EvaluationException {
        double number = this.getChild(0).evaluate(variables, quoteBundle, symbol, day);
        if (number >= 0.0) {
            return Math.sqrt(number);
        }
        throw EvaluationException.SQUARE_ROOT_NEGATIVE_EXCEPTION;
    }

    public String toString() {
        return new String("sqrt(" + ((Object)this.getChild(0)).toString() + ")");
    }

    public int checkType() throws TypeMismatchException {
        int type = this.getChild(0).checkType();
        if (type == 1 || type == 2) {
            return this.getType();
        }
        throw new TypeMismatchException();
    }

    public Expression simplify() {
        super.simplify();
        if (this.getChild(0) instanceof NumberExpression) {
            try {
                return new NumberExpression(this.evaluate(null, null, null, 0), this.getType());
            }
            catch (EvaluationException e) {
                return this;
            }
        }
        return this;
    }

    public int getType() {
        return this.getChild(0).getType();
    }

    public Object clone() {
        return new SqrtExpression((Expression)this.getChild(0).clone());
    }
}

