/*
 * Decompiled with CFR 0.152.
 */
package org.mov.parser.expression;

import org.mov.parser.EvaluationException;
import org.mov.parser.Expression;
import org.mov.parser.TypeMismatchException;
import org.mov.parser.Variables;
import org.mov.parser.expression.QuoteExpression;
import org.mov.parser.expression.TernaryExpression;
import org.mov.quote.MissingQuoteException;
import org.mov.quote.QuoteBundle;
import org.mov.quote.Symbol;

public class SumExpression
extends TernaryExpression {
    static final /* synthetic */ boolean $assertionsDisabled;

    public SumExpression(Expression quote, Expression days, Expression lag) {
        super(quote, days, lag);
    }

    public double evaluate(Variables variables, QuoteBundle quoteBundle, Symbol symbol, int day) throws EvaluationException {
        int period = (int)this.getChild(1).evaluate(variables, quoteBundle, symbol, day);
        if (period <= 0) {
            throw EvaluationException.SUM_RANGE_EXCEPTION;
        }
        int quoteKind = ((QuoteExpression)this.getChild(0)).getQuoteKind();
        int offset = (int)this.getChild(2).evaluate(variables, quoteBundle, symbol, day);
        if (offset > 0) {
            throw EvaluationException.SUM_OFFSET_EXCEPTION;
        }
        return this.sum(quoteBundle, symbol, quoteKind, period, day, offset);
    }

    public String toString() {
        return new String("sum(" + ((Object)this.getChild(0)).toString() + ", " + ((Object)this.getChild(1)).toString() + ", " + ((Object)this.getChild(2)).toString() + ")");
    }

    public int checkType() throws TypeMismatchException {
        if ((this.getChild(0).checkType() == 3 || this.getChild(0).checkType() == 4) && this.getChild(1).checkType() == 2 && this.getChild(2).checkType() == 2) {
            return this.getType();
        }
        throw new TypeMismatchException();
    }

    public int getType() {
        if (this.getChild(0).getType() == 3) {
            return 1;
        }
        if (!$assertionsDisabled && this.getChild(0).getType() != 4) {
            throw new AssertionError();
        }
        return 2;
    }

    private double sum(QuoteBundle quoteBundle, Symbol symbol, int quote, int period, int day, int offset) throws EvaluationException {
        double sum = 0.0;
        for (int i = offset - period + 1; i <= offset; ++i) {
            try {
                sum += quoteBundle.getQuote(symbol, quote, day, i);
                continue;
            }
            catch (MissingQuoteException e) {
                // empty catch block
            }
        }
        return sum;
    }

    public Object clone() {
        return new SumExpression((Expression)this.getChild(0).clone(), (Expression)this.getChild(1).clone(), (Expression)this.getChild(2).clone());
    }

    static {
        $assertionsDisabled = !SumExpression.class.desiredAssertionStatus();
    }
}

