/*
 * Decompiled with CFR 0.152.
 */
package org.mov.portfolio;

import java.util.ArrayList;
import java.util.List;
import org.mov.portfolio.Account;
import org.mov.portfolio.Portfolio;
import org.mov.quote.MissingQuoteException;
import org.mov.quote.QuoteBundle;
import org.mov.ui.AbstractTable;
import org.mov.ui.AbstractTableModel;
import org.mov.ui.AccountNameFormat;
import org.mov.ui.ChangeFormat;
import org.mov.ui.Column;
import org.mov.util.Locale;
import org.mov.util.Money;
import org.mov.util.TradingDate;

public class AccountTable
extends AbstractTable {
    private static final int ACCOUNT_COLUMN = 0;
    private static final int MARKET_VALUE_COLUMN = 1;
    private static final int PERCENT_CHANGE_COLUMN = 2;
    static /* synthetic */ Class class$org$mov$portfolio$AccountTable;

    public AccountTable(Portfolio portfolio, QuoteBundle quoteBundle) {
        ArrayList<Column> columns = new ArrayList<Column>();
        columns.add(new Column(0, Locale.getString("ACCOUNT"), Locale.getString("ACCOUNT_COLUMN_HEADER"), AccountNameFormat.class, 1));
        columns.add(new Column(1, Locale.getString("MARKET_VALUE"), Locale.getString("MARKET_VALUE_COLUMN_HEADER"), Money.class, 1));
        columns.add(new Column(2, Locale.getString("PERCENT_CHANGE"), Locale.getString("PERCENT_CHANGE_COLUMN_HEADER"), ChangeFormat.class, 1));
        this.setModel(new Model(columns, portfolio, quoteBundle));
    }

    class Model
    extends AbstractTableModel {
        private QuoteBundle quoteBundle;
        private Portfolio todayPortfolio;
        private Portfolio yesterdayPortfolio;
        private TradingDate date;
        static final /* synthetic */ boolean $assertionsDisabled;

        public Model(List columns, Portfolio portfolio, QuoteBundle quoteBundle) {
            super(columns);
            this.quoteBundle = null;
            this.todayPortfolio = null;
            this.yesterdayPortfolio = null;
            this.date = null;
            this.date = quoteBundle.getLastDate();
            this.quoteBundle = quoteBundle;
            this.todayPortfolio = portfolio;
            this.yesterdayPortfolio = portfolio.getPortfolio(this.date.previous(1));
        }

        public int getRowCount() {
            return this.todayPortfolio.getAccounts().size() + 1;
        }

        private Object getAccountValueAt(int row, int column) {
            Account todayAccount = (Account)this.todayPortfolio.getAccounts().get(row);
            switch (column) {
                case 0: {
                    return new AccountNameFormat(todayAccount.getName());
                }
                case 1: {
                    try {
                        return todayAccount.getValue(this.quoteBundle, this.date);
                    }
                    catch (MissingQuoteException e) {
                        return Money.ZERO;
                    }
                }
                case 2: {
                    Account yesterdayAccount = (Account)this.yesterdayPortfolio.getAccounts().get(row);
                    try {
                        Money todayValue = todayAccount.getValue(this.quoteBundle, this.date);
                        Money yesterdayValue = yesterdayAccount.getValue(this.quoteBundle, this.date.previous(1));
                        return new ChangeFormat(yesterdayValue, todayValue);
                    }
                    catch (MissingQuoteException e) {
                        return new ChangeFormat(0.0);
                    }
                }
            }
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return Money.ZERO;
        }

        private Object getPortfolioValueAt(int column) {
            switch (column) {
                case 0: {
                    return AccountNameFormat.TOTAL;
                }
                case 1: {
                    try {
                        return this.todayPortfolio.getValue(this.quoteBundle, this.date);
                    }
                    catch (MissingQuoteException e) {
                        return Money.ZERO;
                    }
                }
                case 2: {
                    try {
                        Money todayValue = this.todayPortfolio.getValue(this.quoteBundle, this.date);
                        Money yesterdayValue = this.yesterdayPortfolio.getValue(this.quoteBundle, this.date.previous(1));
                        return new ChangeFormat(yesterdayValue, todayValue);
                    }
                    catch (MissingQuoteException e) {
                        return new ChangeFormat(0.0);
                    }
                }
            }
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return Money.ZERO;
        }

        public Object getValueAt(int row, int column) {
            if (row >= this.getRowCount()) {
                return "";
            }
            if (row != this.getRowCount() - 1) {
                return this.getAccountValueAt(row, column);
            }
            return this.getPortfolioValueAt(column);
        }

        static {
            $assertionsDisabled = !(class$org$mov$portfolio$AccountTable == null ? (class$org$mov$portfolio$AccountTable = AccountTable.class$("org.mov.portfolio.AccountTable")) : class$org$mov$portfolio$AccountTable).desiredAssertionStatus();
        }
    }
}

