/*
 * Decompiled with CFR 0.152.
 */
package org.mov.portfolio;

import org.mov.portfolio.AbstractAccount;
import org.mov.portfolio.Transaction;
import org.mov.quote.QuoteBundle;
import org.mov.util.Money;
import org.mov.util.TradingDate;

public class CashAccount
extends AbstractAccount
implements Cloneable {
    private Money capital;
    private String name;

    public CashAccount(String name) {
        this.name = name;
        this.capital = Money.ZERO;
    }

    public void transaction(Transaction transaction) {
        int type = transaction.getType();
        if (type == 0 || type == 3) {
            this.capital = this.capital.subtract(transaction.getAmount());
        } else if (type == 1 || type == 2 || type == 6) {
            this.capital = this.capital.add(transaction.getAmount());
        } else if (type == 4) {
            this.capital = this.capital.subtract(transaction.getAmount());
            this.capital = this.capital.subtract(transaction.getTradeCost());
        } else if (type == 5) {
            this.capital = this.capital.add(transaction.getAmount());
            this.capital = this.capital.subtract(transaction.getTradeCost());
        } else if (type == 8) {
            this.capital = transaction.getCashAccount() == this ? this.capital.subtract(transaction.getAmount()) : this.capital.add(transaction.getAmount());
        }
    }

    public Object clone() {
        CashAccount clonedCashAccount = new CashAccount(this.getName());
        return clonedCashAccount;
    }

    public boolean equals(Object object) {
        if (object instanceof CashAccount) {
            CashAccount account = (CashAccount)object;
            return account.getName().equals(this.getName()) && account.getValue().equals(this.getValue());
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public Money getValue(QuoteBundle quoteBundle, int dateOffset) {
        return this.capital;
    }

    public Money getValue(QuoteBundle quoteBundle, TradingDate date) {
        return this.capital;
    }

    public Money getValue() {
        return this.capital;
    }

    public void removeAllTransactions() {
        this.capital = Money.ZERO;
    }

    public int getType() {
        return 0;
    }
}

