/*
 * Decompiled with CFR 0.152.
 */
package org.mov.portfolio;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.mov.portfolio.Account;
import org.mov.portfolio.CashAccount;
import org.mov.portfolio.ShareAccount;
import org.mov.portfolio.Transaction;
import org.mov.quote.MissingQuoteException;
import org.mov.quote.QuoteBundle;
import org.mov.quote.QuoteCache;
import org.mov.quote.Symbol;
import org.mov.quote.SymbolFormatException;
import org.mov.quote.WeekendDateException;
import org.mov.util.Money;
import org.mov.util.MoneyFormatException;
import org.mov.util.TradingDate;
import org.mov.util.TradingDateFormatException;

public class Portfolio
implements Cloneable {
    private String name;
    private List accounts = new ArrayList();
    private List transactions = new ArrayList();
    private boolean isTransient;
    private Money deposits;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Portfolio(String name) {
        this(name, false);
    }

    public Portfolio(String name, boolean isTransient) {
        this.name = name;
        this.isTransient = isTransient;
        this.deposits = Money.ZERO;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public void addAccount(Account account) {
        this.accounts.add(account);
    }

    public void addTransactions(List transactions) {
        ArrayList list = new ArrayList(transactions);
        Collections.sort(list);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Transaction transaction = (Transaction)iterator.next();
            this.addTransaction(transaction);
        }
    }

    public void addTransaction(Transaction transaction) {
        if (this.countTransactions() > 0 && ((Transaction)this.transactions.get(this.transactions.size() - 1)).compareTo(transaction) > 0) {
            ArrayList<Transaction> allTransactions = new ArrayList<Transaction>(this.transactions);
            allTransactions.add(transaction);
            this.removeAllTransactions();
            this.addTransactions(allTransactions);
        } else {
            this.transactions.add(transaction);
            Iterator iterator = this.accounts.iterator();
            while (iterator.hasNext()) {
                Account account = (Account)iterator.next();
                if (account != transaction.getCashAccount() && account != transaction.getCashAccount2() && account != transaction.getShareAccount()) continue;
                account.transaction(transaction);
            }
            if (transaction.getType() == 0) {
                this.deposits = this.deposits.subtract(transaction.getAmount());
            } else if (transaction.getType() == 1) {
                this.deposits = this.deposits.add(transaction.getAmount());
            }
        }
    }

    public Object clone() {
        Portfolio clonedPortfolio = new Portfolio(this.getName());
        Iterator accountIterator = this.accounts.iterator();
        while (accountIterator.hasNext()) {
            Object clonedAccount;
            Account account = (Account)accountIterator.next();
            if (account.getType() == 1) {
                clonedAccount = ((ShareAccount)account).clone();
            } else {
                if (!$assertionsDisabled && account.getType() != 0) {
                    throw new AssertionError();
                }
                clonedAccount = ((CashAccount)account).clone();
            }
            clonedPortfolio.addAccount((Account)clonedAccount);
        }
        Iterator transactionIterator = this.transactions.iterator();
        while (transactionIterator.hasNext()) {
            String accountName;
            Transaction transaction = (Transaction)transactionIterator.next();
            Transaction clonedTransaction = (Transaction)transaction.clone();
            if (clonedTransaction.getShareAccount() != null) {
                accountName = clonedTransaction.getShareAccount().getName();
                ShareAccount shareAccount = (ShareAccount)clonedPortfolio.findAccountByName(accountName);
                clonedTransaction.setShareAccount(shareAccount);
            }
            if (clonedTransaction.getCashAccount() != null) {
                accountName = clonedTransaction.getCashAccount().getName();
                CashAccount cashAccount = (CashAccount)clonedPortfolio.findAccountByName(accountName);
                clonedTransaction.setCashAccount(cashAccount);
            }
            if (clonedTransaction.getCashAccount2() != null) {
                accountName = clonedTransaction.getCashAccount2().getName();
                CashAccount cashAccount2 = (CashAccount)clonedPortfolio.findAccountByName(accountName);
                clonedTransaction.setCashAccount2(cashAccount2);
            }
            clonedPortfolio.addTransaction(clonedTransaction);
        }
        return clonedPortfolio;
    }

    public List getAccounts() {
        return this.accounts;
    }

    public int countAccounts(int type) {
        int count = 0;
        Iterator iterator = this.accounts.iterator();
        while (iterator.hasNext()) {
            Account account = (Account)iterator.next();
            if (account.getType() != type) continue;
            ++count;
        }
        return count;
    }

    public Account findAccountByName(String name) {
        Iterator iterator = this.accounts.iterator();
        while (iterator.hasNext()) {
            Account account = (Account)iterator.next();
            if (!account.getName().equals(name)) continue;
            return account;
        }
        return null;
    }

    public TradingDate getStartDate() {
        if (this.transactions.size() > 0) {
            Transaction transaction = (Transaction)this.transactions.get(0);
            return transaction.getDate();
        }
        return null;
    }

    public TradingDate getLastDate() {
        if (this.transactions.size() > 0) {
            Transaction transaction = (Transaction)this.transactions.get(this.transactions.size() - 1);
            return transaction.getDate();
        }
        return null;
    }

    public List getSymbolsTraded() {
        HashSet<Symbol> symbolsTraded = new HashSet<Symbol>();
        Iterator iterator = this.transactions.iterator();
        while (iterator.hasNext()) {
            Transaction transaction = (Transaction)iterator.next();
            if (transaction.getType() != 4) continue;
            symbolsTraded.add(transaction.getSymbol());
        }
        return new ArrayList(symbolsTraded);
    }

    public int countTransactions() {
        return this.transactions.size();
    }

    public int countTransactions(int type) {
        int count = 0;
        Iterator iterator = this.transactions.iterator();
        while (iterator.hasNext()) {
            Transaction transaction = (Transaction)iterator.next();
            if (transaction.getType() != type) continue;
            ++count;
        }
        return count;
    }

    public List getTransactions() {
        return this.transactions;
    }

    public void removeAllTransactions() {
        this.transactions.clear();
        this.deposits = Money.ZERO;
        Iterator iterator = this.accounts.iterator();
        while (iterator.hasNext()) {
            Account account = (Account)iterator.next();
            account.removeAllTransactions();
        }
    }

    public Money getValue(QuoteBundle quoteBundle, TradingDate date) throws MissingQuoteException {
        try {
            return this.getValue(quoteBundle, QuoteCache.getInstance().dateToOffset(date));
        }
        catch (WeekendDateException e) {
            throw MissingQuoteException.getInstance();
        }
    }

    public Money getValue(QuoteBundle quoteBundle, int dateOffset) throws MissingQuoteException {
        Money value = Money.ZERO;
        Iterator iterator = this.accounts.iterator();
        while (iterator.hasNext()) {
            Account account = (Account)iterator.next();
            value = value.add(account.getValue(quoteBundle, dateOffset));
        }
        return value;
    }

    public List getStocksHeld() {
        HashSet stocksHeld = new HashSet();
        Iterator iterator = this.accounts.iterator();
        while (iterator.hasNext()) {
            Account account = (Account)iterator.next();
            if (account.getType() != 1) continue;
            ShareAccount shareAccount = (ShareAccount)account;
            stocksHeld.addAll(shareAccount.getStockHoldings().keySet());
        }
        return new ArrayList(stocksHeld);
    }

    public Money getCashValue() {
        Money value = Money.ZERO;
        Iterator iterator = this.accounts.iterator();
        while (iterator.hasNext()) {
            Account account = (Account)iterator.next();
            if (account.getType() != 0) continue;
            CashAccount cashAccount = (CashAccount)account;
            value = value.add(cashAccount.getValue());
        }
        return value;
    }

    public Money getShareValue(QuoteBundle quoteBundle, TradingDate date) throws MissingQuoteException {
        Money value = Money.ZERO;
        Iterator iterator = this.accounts.iterator();
        while (iterator.hasNext()) {
            Account account = (Account)iterator.next();
            if (account.getType() != 1) continue;
            value = value.add(account.getValue(quoteBundle, date));
        }
        return value;
    }

    public Money getReturnValue(QuoteBundle quoteBundle, TradingDate date) throws MissingQuoteException {
        Money value = this.getValue(quoteBundle, date);
        value = value.subtract(this.deposits);
        return value;
    }

    public Iterator iterator() {
        return new PortfolioIterator(this);
    }

    public Portfolio getPortfolio(TradingDate date) {
        if (this.getLastDate() == null || date.compareTo(this.getLastDate()) >= 0) {
            return this;
        }
        Portfolio portfolio = (Portfolio)this.clone();
        ArrayList transactions = new ArrayList(portfolio.getTransactions());
        Iterator iterator = transactions.iterator();
        while (iterator.hasNext()) {
            Transaction transaction = (Transaction)iterator.next();
            if (transaction.getDate().compareTo(date) <= 0) {
                portfolio.addTransaction(transaction);
                continue;
            }
            return portfolio;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return this;
    }

    public void read(File file) throws IOException {
        try {
            FileReader fileReader = new FileReader(file);
            BufferedReader reader = new BufferedReader(fileReader);
            String line = reader.readLine();
            while (line != null) {
                String symbolField;
                String[] parts = line.split("\t");
                int i = 0;
                TradingDate date = new TradingDate(parts[i++], 1);
                int type = Transaction.stringToType(parts[i++]);
                Money amount = new Money(parts[i++]);
                Symbol symbol = (symbolField = parts[i++]).equals("-") ? null : Symbol.find(symbolField);
                int shares = Integer.valueOf(parts[i++]);
                Money tradeCost = new Money(parts[i++]);
                String cashAccountName = parts[i++];
                String cashAccountName2 = "";
                String shareAccountName = "";
                try {
                    cashAccountName2 = parts[i++];
                    shareAccountName = parts[i++];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    // empty catch block
                }
                CashAccount cashAccount = null;
                CashAccount cashAccount2 = null;
                ShareAccount shareAccount = null;
                if (!cashAccountName.equals("") && (cashAccount = (CashAccount)this.findAccountByName(cashAccountName)) == null) {
                    cashAccount = new CashAccount(cashAccountName);
                    this.addAccount(cashAccount);
                }
                if (!cashAccountName2.equals("") && (cashAccount2 = (CashAccount)this.findAccountByName(cashAccountName2)) == null) {
                    cashAccount2 = new CashAccount(cashAccountName2);
                    this.addAccount(cashAccount2);
                }
                if (!shareAccountName.equals("") && (shareAccount = (ShareAccount)this.findAccountByName(shareAccountName)) == null) {
                    shareAccount = new ShareAccount(shareAccountName);
                    this.addAccount(shareAccount);
                }
                Transaction transaction = new Transaction(type, date, amount, symbol, shares, tradeCost, cashAccount, cashAccount2, shareAccount);
                this.addTransaction(transaction);
                line = reader.readLine();
            }
            reader.close();
        }
        catch (MoneyFormatException e) {
            throw new IOException();
        }
        catch (NumberFormatException e) {
            throw new IOException();
        }
        catch (SymbolFormatException e) {
            throw new IOException();
        }
        catch (TradingDateFormatException e) {
            throw new IOException();
        }
    }

    public void write(File file) throws IOException {
        FileWriter fileWriter = new FileWriter(file);
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        PrintWriter printWriter = new PrintWriter(bufferedWriter);
        Iterator iterator = this.getTransactions().iterator();
        while (iterator.hasNext()) {
            Transaction transaction = (Transaction)iterator.next();
            printWriter.println(transaction);
        }
        printWriter.close();
    }

    public boolean equals(Object object) {
        Portfolio portfolio = (Portfolio)object;
        List accounts = this.getAccounts();
        Collections.sort(accounts);
        List portfolioAccounts = portfolio.getAccounts();
        Collections.sort(portfolioAccounts);
        return portfolio.getName().equals(this.getName()) && ((Object)portfolioAccounts).equals(accounts) && ((Object)portfolio.getTransactions()).equals(this.getTransactions()) && portfolio.isTransient() == this.isTransient();
    }

    static {
        $assertionsDisabled = !Portfolio.class.desiredAssertionStatus();
    }

    private class PortfolioIterator
    implements Iterator {
        private Portfolio iteratorPortfolio;
        private ListIterator transactionIterator;
        private TradingDate currentDate;

        public PortfolioIterator(Portfolio referencePortfolio) {
            this.iteratorPortfolio = (Portfolio)referencePortfolio.clone();
            ArrayList transactions = new ArrayList(this.iteratorPortfolio.getTransactions());
            this.iteratorPortfolio.removeAllTransactions();
            this.transactionIterator = transactions.listIterator();
            this.currentDate = referencePortfolio.getStartDate();
        }

        public boolean hasNext() {
            return true;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public Object next() {
            while (this.transactionIterator.hasNext()) {
                Transaction transaction = (Transaction)this.transactionIterator.next();
                if (transaction.getDate().compareTo(this.currentDate) <= 0) {
                    this.iteratorPortfolio.addTransaction(transaction);
                    continue;
                }
                this.transactionIterator.previous();
                break;
            }
            this.currentDate = this.currentDate.next(1);
            return this.iteratorPortfolio;
        }
    }
}

