/*
 * Decompiled with CFR 0.152.
 */
package org.mov.portfolio;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import org.mov.main.CommandManager;
import org.mov.main.Module;
import org.mov.portfolio.Account;
import org.mov.portfolio.AccountTable;
import org.mov.portfolio.CashAccount;
import org.mov.portfolio.Portfolio;
import org.mov.portfolio.ShareAccount;
import org.mov.portfolio.StockHoldingTable;
import org.mov.portfolio.TransactionDialog;
import org.mov.portfolio.TransactionModule;
import org.mov.prefs.PreferencesManager;
import org.mov.quote.QuoteBundle;
import org.mov.quote.QuoteSourceManager;
import org.mov.ui.ConfirmDialog;
import org.mov.ui.DesktopManager;
import org.mov.ui.MainMenu;
import org.mov.ui.MenuHelper;
import org.mov.ui.TextDialog;
import org.mov.util.Locale;

public class PortfolioModule
extends JPanel
implements Module,
ActionListener {
    private PropertyChangeSupport propertySupport;
    private JDesktopPane desktop;
    private Portfolio portfolio;
    private QuoteBundle quoteBundle;
    private JMenuBar menuBar;
    private JMenuItem accountNewCashAccount;
    private JMenuItem accountNewShareAccount;
    private JMenuItem portfolioGraph;
    private JMenuItem portfolioTable;
    private JMenuItem portfolioExport;
    private JMenuItem portfolioImport;
    private JMenuItem portfolioDelete;
    private JMenuItem portfolioRename;
    private JMenuItem portfolioClose;
    private JMenuItem transactionNew;
    private JMenuItem transactionShowHistory;
    private boolean isDeleted = false;
    JInternalFrame historyFrame = null;
    TransactionModule historyModule = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PortfolioModule(JDesktopPane desktop, Portfolio portfolio, QuoteBundle quoteBundle) {
        this.desktop = desktop;
        this.portfolio = portfolio;
        this.quoteBundle = quoteBundle;
        this.propertySupport = new PropertyChangeSupport(this);
        this.createMenu();
        this.redraw();
    }

    private void createMenu() {
        this.menuBar = new JMenuBar();
        JMenu portfolioMenu = MenuHelper.addMenu(this.menuBar, Locale.getString("PORTFOLIO"), 'P');
        this.portfolioGraph = MenuHelper.addMenuItem((ActionListener)this, portfolioMenu, Locale.getString("GRAPH"));
        this.portfolioTable = MenuHelper.addMenuItem((ActionListener)this, portfolioMenu, Locale.getString("TABLE"));
        portfolioMenu.addSeparator();
        this.portfolioExport = MenuHelper.addMenuItem((ActionListener)this, portfolioMenu, Locale.getString("EXPORT"));
        this.portfolioImport = MenuHelper.addMenuItem((ActionListener)this, portfolioMenu, Locale.getString("IMPORT"));
        if (!this.portfolio.isTransient()) {
            portfolioMenu.addSeparator();
            this.portfolioDelete = MenuHelper.addMenuItem((ActionListener)this, portfolioMenu, Locale.getString("DELETE"));
            this.portfolioRename = MenuHelper.addMenuItem((ActionListener)this, portfolioMenu, Locale.getString("RENAME"));
        }
        portfolioMenu.addSeparator();
        this.portfolioClose = MenuHelper.addMenuItem((ActionListener)this, portfolioMenu, Locale.getString("CLOSE"));
        JMenu accountMenu = MenuHelper.addMenu(this.menuBar, Locale.getString("ACCOUNT"), 'A');
        this.accountNewCashAccount = MenuHelper.addMenuItem((ActionListener)this, accountMenu, Locale.getString("NEW_CASH_ACCOUNT"));
        this.accountNewShareAccount = MenuHelper.addMenuItem((ActionListener)this, accountMenu, Locale.getString("NEW_SHARE_ACCOUNT"));
        JMenu transactionMenu = MenuHelper.addMenu(this.menuBar, Locale.getString("TRANSACTION"), 'T');
        this.transactionNew = MenuHelper.addMenuItem((ActionListener)this, transactionMenu, Locale.getString("NEW"));
        this.transactionShowHistory = MenuHelper.addMenuItem((ActionListener)this, transactionMenu, Locale.getString("SHOW_HISTORY"));
        this.checkMenuDisabledStatus();
    }

    private void checkMenuDisabledStatus() {
        int hasCashAccount = this.portfolio.countAccounts(0);
        this.transactionNew.setEnabled(hasCashAccount > 0);
        this.transactionShowHistory.setEnabled(hasCashAccount > 0);
    }

    public void redraw() {
        StockHoldingTable table = null;
        JScrollPane scrolledTable = null;
        AccountTable accountTable = null;
        this.removeAll();
        this.setLayout(new BoxLayout(this, 1));
        List accounts = this.portfolio.getAccounts();
        if (accounts.size() == 0) {
            this.addLabel(Locale.getString("EMPTY"));
        } else {
            Iterator iterator = accounts.iterator();
            while (iterator.hasNext()) {
                Account account = (Account)iterator.next();
                if (!(account instanceof ShareAccount)) continue;
                this.addLabel(account.getName());
                ShareAccount shareAccount = (ShareAccount)account;
                table = new StockHoldingTable(shareAccount.getStockHoldings(), this.quoteBundle);
                scrolledTable = new JScrollPane(table);
                this.add(scrolledTable);
                this.restrictTableHeight(scrolledTable, table);
            }
            this.addLabel(Locale.getString("SUMMARY"));
            accountTable = new AccountTable(this.portfolio, this.quoteBundle);
            scrolledTable = new JScrollPane(accountTable);
            this.add(scrolledTable);
            this.restrictTableHeight(scrolledTable, accountTable);
        }
        this.add(Box.createVerticalGlue());
        this.validate();
        this.repaint();
    }

    private void restrictTableHeight(JScrollPane scrollPane, JTable table) {
        int rows = table.getRowCount();
        if (rows == 0) {
            rows = 1;
        }
        double maximumHeight = table.getTableHeader().getPreferredSize().getHeight() + (double)(table.getRowHeight() * rows) + 4.0;
        Dimension maximumSize = new Dimension();
        maximumSize.setSize(table.getMaximumSize().getWidth(), maximumHeight);
        Dimension preferredSize = new Dimension();
        preferredSize.setSize(table.getPreferredSize().getWidth(), maximumHeight);
        Dimension minimumSize = new Dimension();
        minimumSize.setSize(table.getMinimumSize().getWidth(), maximumHeight);
        scrollPane.setPreferredSize(preferredSize);
        scrollPane.setMaximumSize(maximumSize);
        scrollPane.setMinimumSize(minimumSize);
    }

    private void addLabel(String text) {
        JLabel label = new JLabel(text);
        label.setForeground(Color.BLACK);
        label.setFont(new Font(label.getFont().getName(), 1, 20));
        label.setBorder(new EmptyBorder(0, 5, 0, 0));
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)label, "North");
        this.add(panel);
        Dimension preferredSize = new Dimension();
        preferredSize.setSize(panel.getPreferredSize().getWidth(), label.getPreferredSize().getHeight());
        Dimension maximumSize = new Dimension();
        maximumSize.setSize(panel.getMaximumSize().getWidth(), label.getPreferredSize().getHeight());
        panel.setPreferredSize(preferredSize);
        panel.setMaximumSize(maximumSize);
    }

    public void save() {
        if (!this.portfolio.isTransient() && !this.isDeleted) {
            PreferencesManager.savePortfolio(this.portfolio);
            MainMenu.getInstance().updatePortfolioMenu();
        }
    }

    public String getTitle() {
        return this.portfolio.getName();
    }

    public void addModuleChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void removeModuleChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    public ImageIcon getFrameIcon() {
        return null;
    }

    public JComponent getComponent() {
        return this;
    }

    public JMenuBar getJMenuBar() {
        return this.menuBar;
    }

    public boolean encloseInScrollPane() {
        return true;
    }

    public void actionPerformed(final ActionEvent e) {
        Thread menuAction = new Thread(){
            static final /* synthetic */ boolean $assertionsDisabled;

            public void run() {
                if (e.getSource() == PortfolioModule.this.portfolioClose) {
                    PortfolioModule.this.propertySupport.firePropertyChange("window close", 0, 1);
                } else if (e.getSource() == PortfolioModule.this.portfolioGraph) {
                    PortfolioModule.this.graphPortfolio();
                } else if (e.getSource() == PortfolioModule.this.portfolioTable) {
                    PortfolioModule.this.tablePortfolio();
                } else if (e.getSource() == PortfolioModule.this.portfolioDelete) {
                    PortfolioModule.this.deletePortfolio();
                } else if (e.getSource() == PortfolioModule.this.portfolioRename) {
                    PortfolioModule.this.renamePortfolio();
                } else if (e.getSource() == PortfolioModule.this.portfolioImport) {
                    PortfolioModule.this.importPortfolio();
                } else if (e.getSource() == PortfolioModule.this.portfolioExport) {
                    PortfolioModule.this.exportPortfolio();
                } else if (e.getSource() == PortfolioModule.this.accountNewCashAccount) {
                    PortfolioModule.this.newCashAccount();
                } else if (e.getSource() == PortfolioModule.this.accountNewShareAccount) {
                    PortfolioModule.this.newShareAccount();
                } else if (e.getSource() == PortfolioModule.this.transactionNew) {
                    PortfolioModule.this.newTransaction();
                } else if (e.getSource() == PortfolioModule.this.transactionShowHistory) {
                    PortfolioModule.this.showTransactionHistory();
                } else if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }

            static {
                $assertionsDisabled = !(class$org$mov$portfolio$PortfolioModule == null ? (class$org$mov$portfolio$PortfolioModule = PortfolioModule.class$("org.mov.portfolio.PortfolioModule")) : class$org$mov$portfolio$PortfolioModule).desiredAssertionStatus();
            }
        };
        menuAction.start();
    }

    private void showTransactionHistory() {
        if (this.historyFrame != null && !this.historyFrame.isClosed()) {
            this.historyFrame.toFront();
            try {
                this.historyFrame.setIcon(false);
                this.historyFrame.setSelected(true);
            }
            catch (PropertyVetoException e) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
        } else {
            this.historyModule = new TransactionModule(this, this.portfolio);
            this.historyFrame = ((DesktopManager)this.desktop.getDesktopManager()).newFrame(this.historyModule);
        }
    }

    private void graphPortfolio() {
        if (this.portfolio.getStartDate() == null || this.portfolio.getStartDate().after(QuoteSourceManager.getSource().getLastDate())) {
            DesktopManager.showErrorMessage(Locale.getString("NOTHING_TO_GRAPH"));
        } else if (this.quoteBundle.getFirstDate().compareTo(this.portfolio.getStartDate()) <= 0) {
            CommandManager.getInstance().graphPortfolio(this.portfolio, this.quoteBundle);
        } else {
            CommandManager.getInstance().graphPortfolio(this.portfolio);
        }
    }

    public void tablePortfolio() {
        if (this.portfolio.getStartDate() == null || this.quoteBundle.getFirstDate().compareTo(this.portfolio.getStartDate()) <= 0) {
            CommandManager.getInstance().tablePortfolio(this.portfolio, this.quoteBundle);
        } else {
            CommandManager.getInstance().tablePortfolio(this.portfolio);
        }
    }

    private void deletePortfolio() {
        JDesktopPane desktop = DesktopManager.getDesktop();
        ConfirmDialog dialog = new ConfirmDialog(desktop, Locale.getString("SURE_DELETE_PORTFOLIO"), Locale.getString("DELETE_PORTFOLIO"));
        boolean deletePortfolio = dialog.showDialog();
        if (deletePortfolio) {
            PreferencesManager.deletePortfolio(this.portfolio.getName());
            MainMenu.getInstance().updatePortfolioMenu();
            this.isDeleted = true;
            this.propertySupport.firePropertyChange("window close", 0, 1);
        }
    }

    private void renamePortfolio() {
        String oldPortfolioName = this.portfolio.getName();
        JDesktopPane desktop = DesktopManager.getDesktop();
        TextDialog dialog = new TextDialog(desktop, Locale.getString("ENTER_NEW_PORTFOLIO_NAME"), Locale.getString("RENAME_PORTFOLIO"), oldPortfolioName);
        String newPortfolioName = dialog.showDialog();
        if (newPortfolioName != null && newPortfolioName.length() > 0 && !newPortfolioName.equals(oldPortfolioName)) {
            this.portfolio.setName(newPortfolioName);
            PreferencesManager.savePortfolio(this.portfolio);
            PreferencesManager.deletePortfolio(oldPortfolioName);
            MainMenu.getInstance().updatePortfolioMenu();
            this.propertySupport.firePropertyChange("titlebar changed", 0, 1);
        }
    }

    private void exportPortfolio() {
        JFileChooser chooser = new JFileChooser();
        int action = chooser.showSaveDialog(this.desktop);
        if (action == 0) {
            File file = chooser.getSelectedFile();
            try {
                this.portfolio.write(file);
                JOptionPane.showInternalMessageDialog(this.desktop, Locale.getString("EXPORT_COMPLETE"), Locale.getString("EXPORT_COMPLETE_TITLE"), 1);
            }
            catch (IOException e) {
                DesktopManager.showErrorMessage(Locale.getString("ERROR_WRITING_TO_FILE", file.getName()));
            }
        }
    }

    private void importPortfolio() {
        JFileChooser chooser = new JFileChooser();
        chooser.setMultiSelectionEnabled(false);
        int action = chooser.showOpenDialog(this.desktop);
        if (action == 0) {
            File file = chooser.getSelectedFile();
            try {
                this.portfolio.read(file);
                JOptionPane.showInternalMessageDialog(this.desktop, Locale.getString("IMPORT_COMPLETE"), Locale.getString("IMPORT_COMPLETE_TITLE"), 1);
            }
            catch (IOException e) {
                DesktopManager.showErrorMessage(Locale.getString("ERROR_READING_FROM_FILE", file.getName()));
            }
        }
        this.redraw();
        this.checkMenuDisabledStatus();
    }

    private void newCashAccount() {
        TextDialog dialog = new TextDialog(this.desktop, Locale.getString("ENTER_ACCOUNT_NAME"), Locale.getString("NEW_CASH_ACCOUNT"));
        String accountName = dialog.showDialog();
        if (accountName != null && accountName.length() > 0) {
            CashAccount account = new CashAccount(accountName);
            this.portfolio.addAccount(account);
            this.redraw();
            this.checkMenuDisabledStatus();
        }
    }

    private void newShareAccount() {
        TextDialog dialog = new TextDialog(this.desktop, Locale.getString("ENTER_ACCOUNT_NAME"), Locale.getString("NEW_SHARE_ACCOUNT"));
        String accountName = dialog.showDialog();
        if (accountName != null && accountName.length() > 0) {
            ShareAccount account = new ShareAccount(accountName);
            this.portfolio.addAccount(account);
            this.redraw();
            this.checkMenuDisabledStatus();
        }
    }

    public void newTransaction() {
        JDesktopPane desktop = DesktopManager.getDesktop();
        TransactionDialog dialog = new TransactionDialog(desktop, this.portfolio);
        if (dialog.newTransaction()) {
            this.redraw();
            if (this.historyFrame != null && !this.historyFrame.isClosed()) {
                this.historyModule.redraw();
            }
        }
    }

    static {
        $assertionsDisabled = !PortfolioModule.class.desiredAssertionStatus();
    }
}

