/*
 * Decompiled with CFR 0.152.
 */
package org.mov.portfolio;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.mov.portfolio.AbstractAccount;
import org.mov.portfolio.StockHolding;
import org.mov.portfolio.Transaction;
import org.mov.quote.MissingQuoteException;
import org.mov.quote.QuoteBundle;
import org.mov.quote.QuoteCache;
import org.mov.quote.Symbol;
import org.mov.quote.WeekendDateException;
import org.mov.util.Money;
import org.mov.util.TradingDate;

public class ShareAccount
extends AbstractAccount
implements Cloneable {
    private HashMap stockHoldings = new HashMap();
    private String name;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ShareAccount(String name) {
        this.name = name;
    }

    public Object clone() {
        ShareAccount clonedShareAccount = new ShareAccount(this.getName());
        return clonedShareAccount;
    }

    public boolean equals(Object object) {
        if (object instanceof ShareAccount) {
            ShareAccount account = (ShareAccount)object;
            return account.getName().equals(this.getName()) && account.getStockHoldings().equals(this.getStockHoldings());
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public Money getValue(QuoteBundle quoteBundle, TradingDate date) throws MissingQuoteException {
        try {
            return this.getValue(quoteBundle, QuoteCache.getInstance().dateToOffset(date));
        }
        catch (WeekendDateException e) {
            throw MissingQuoteException.getInstance();
        }
    }

    public Money getValue(QuoteBundle quoteBundle, int dateOffset) throws MissingQuoteException {
        Set set = this.stockHoldings.keySet();
        Iterator iterator = set.iterator();
        Money value = Money.ZERO;
        while (iterator.hasNext()) {
            Symbol symbol = (Symbol)iterator.next();
            StockHolding holding = (StockHolding)this.stockHoldings.get(symbol);
            value = value.add(quoteBundle.getQuote(holding.getSymbol(), 0, dateOffset) * (double)holding.getShares());
        }
        return value;
    }

    public void transaction(Transaction transaction) {
        Symbol symbol = transaction.getSymbol();
        int shares = transaction.getShares();
        int type = transaction.getType();
        StockHolding holding = (StockHolding)this.stockHoldings.get(symbol);
        if (type == 4 || type == 7) {
            if (!$assertionsDisabled && shares <= 0) {
                throw new AssertionError();
            }
            double averageCost = transaction.getAmount().doubleValue() / (double)transaction.getShares();
            if (holding != null) {
                holding.accumulate(shares, averageCost);
            } else {
                this.stockHoldings.put(symbol, new StockHolding(symbol, shares, averageCost, transaction.getDate()));
            }
        } else if (type == 5) {
            if (!$assertionsDisabled && holding == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && shares <= 0) {
                throw new AssertionError();
            }
            holding.reduce(shares);
            if (holding.getShares() <= 0) {
                this.stockHoldings.remove(symbol);
            }
        }
    }

    public StockHolding get(Symbol symbol) {
        return (StockHolding)this.stockHoldings.get(symbol);
    }

    public boolean isHolding(Symbol symbol) {
        return this.stockHoldings.containsKey(symbol);
    }

    public HashMap getStockHoldings() {
        return this.stockHoldings;
    }

    public int getType() {
        return 1;
    }

    public void removeAllTransactions() {
        this.stockHoldings.clear();
    }

    public int size() {
        return this.stockHoldings.size();
    }

    static {
        $assertionsDisabled = !ShareAccount.class.desiredAssertionStatus();
    }
}

