/*
 * Decompiled with CFR 0.152.
 */
package org.mov.portfolio;

import org.mov.quote.Symbol;
import org.mov.util.TradingDate;

public class StockHolding {
    private Symbol symbol;
    private int shares;
    private TradingDate date;
    private double cost;

    public StockHolding(Symbol symbol, int shares, double cost, TradingDate date) {
        this.symbol = symbol;
        this.shares = shares;
        this.cost = cost;
        this.date = date;
    }

    public void accumulate(int shares, double cost) {
        this.cost = ((double)this.shares * this.cost + (double)shares * cost) / (double)(this.shares + shares);
        this.shares += shares;
    }

    public void reduce(int shares) {
        this.shares -= shares;
    }

    public Symbol getSymbol() {
        return this.symbol;
    }

    public int getShares() {
        return this.shares;
    }

    public double getCost() {
        return this.cost;
    }

    public TradingDate getDate() {
        return this.date;
    }

    public boolean equals(Object object) {
        StockHolding holding = (StockHolding)object;
        return holding.getSymbol().equals(this.getSymbol()) && holding.getShares() == this.getShares() && holding.getCost() == this.getCost() && holding.getDate().equals(this.getDate());
    }
}

