/*
 * Decompiled with CFR 0.152.
 */
package org.mov.portfolio;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.mov.main.CommandManager;
import org.mov.portfolio.StockHolding;
import org.mov.quote.MissingQuoteException;
import org.mov.quote.QuoteBundle;
import org.mov.quote.Symbol;
import org.mov.ui.AbstractTable;
import org.mov.ui.AbstractTableModel;
import org.mov.ui.ChangeFormat;
import org.mov.ui.Column;
import org.mov.ui.PointChangeFormat;
import org.mov.ui.QuoteFormat;
import org.mov.util.Locale;
import org.mov.util.Money;
import org.mov.util.TradingDate;

public class StockHoldingTable
extends AbstractTable {
    private static final int SYMBOL_COLUMN = 0;
    private static final int SHARES_COLUMN = 1;
    private static final int AVERAGE_COST_COLUMN = 2;
    private static final int MARKET_PRICE_COLUMN = 3;
    private static final int MARKET_VALUE_COLUMN = 4;
    private static final int POINT_CHANGE_COLUMN = 5;
    private static final int PERCENT_CHANGE_COLUMN = 6;
    private static final int PERCENT_RETURN_COLUMN = 7;
    private JMenu showColumnsMenu;
    private Model model;
    static /* synthetic */ Class class$org$mov$portfolio$StockHoldingTable;

    public StockHoldingTable(HashMap stockHoldings, QuoteBundle quoteBundle) {
        ArrayList<Column> columns = new ArrayList<Column>();
        columns.add(new Column(0, Locale.getString("SYMBOL"), Locale.getString("SYMBOL_COLUMN_HEADER"), Symbol.class, 1));
        columns.add(new Column(1, Locale.getString("SHARES"), Locale.getString("SHARES_COLUMN_HEADER"), Integer.class, 1));
        columns.add(new Column(2, Locale.getString("AVERAGE_COST"), Locale.getString("AVERAGE_COST_COLUMN_HEADER"), QuoteFormat.class, 0));
        columns.add(new Column(3, Locale.getString("MARKET_PRICE"), Locale.getString("MARKET_PRICE_COLUMN_HEADER"), QuoteFormat.class, 1));
        columns.add(new Column(4, Locale.getString("MARKET_VALUE"), Locale.getString("MARKET_VALUE_COLUMN_HEADER"), Money.class, 1));
        columns.add(new Column(5, Locale.getString("POINT_CHANGE"), Locale.getString("POINT_CHANGE_COLUMN_HEADER"), PointChangeFormat.class, 0));
        columns.add(new Column(6, Locale.getString("PERCENT_CHANGE"), Locale.getString("PERCENT_CHANGE_COLUMN_HEADER"), ChangeFormat.class, 1));
        columns.add(new Column(7, Locale.getString("PERCENT_RETURN"), Locale.getString("PERCENT_RETURN_COLUMN_HEADER"), ChangeFormat.class, 0));
        this.model = new Model(columns, stockHoldings, quoteBundle);
        this.setModel(this.model);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent event) {
                StockHoldingTable.this.handleMouseClicked(event);
            }
        });
        this.showColumns(this.model);
        this.showColumnsMenu = this.createShowColumnMenu(this.model);
    }

    private void handleMouseClicked(MouseEvent event) {
        Point point = event.getPoint();
        if (event.getButton() == 3) {
            JPopupMenu menu = new JPopupMenu();
            menu.add(this.showColumnsMenu);
            menu.addSeparator();
            JMenuItem popupGraphSymbols = new JMenuItem(Locale.getString("GRAPH"));
            popupGraphSymbols.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int[] selectedRows = StockHoldingTable.this.getSelectedRows();
                    ArrayList<Symbol> symbols = new ArrayList<Symbol>();
                    for (int i = 0; i < selectedRows.length; ++i) {
                        int row = StockHoldingTable.this.getSortedRow(selectedRows[i]);
                        Symbol symbol = (Symbol)StockHoldingTable.this.getModel().getValueAt(row, 0);
                        symbols.add(symbol);
                    }
                    CommandManager.getInstance().graphStockBySymbol(symbols);
                }
            });
            popupGraphSymbols.setEnabled(this.getSelectedRowCount() > 0);
            menu.add(popupGraphSymbols);
            JMenuItem popupTableSymbols = new JMenuItem(Locale.getString("TABLE"));
            popupTableSymbols.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int[] selectedRows = StockHoldingTable.this.getSelectedRows();
                    ArrayList<Symbol> symbols = new ArrayList<Symbol>();
                    for (int i = 0; i < selectedRows.length; ++i) {
                        int row = StockHoldingTable.this.getSortedRow(selectedRows[i]);
                        Symbol symbol = (Symbol)StockHoldingTable.this.getModel().getValueAt(row, 0);
                        symbols.add(symbol);
                    }
                    CommandManager.getInstance().tableStocks(symbols);
                }
            });
            popupTableSymbols.setEnabled(this.getSelectedRowCount() > 0);
            menu.add(popupTableSymbols);
            menu.show(this, point.x, point.y);
        } else if (event.getButton() == 1 && event.getClickCount() == 2) {
            int row = this.rowAtPoint(point);
            Symbol symbol = (Symbol)this.getModel().getValueAt(row, 0);
            ArrayList<Symbol> symbols = new ArrayList<Symbol>();
            symbols.add(symbol);
            CommandManager.getInstance().graphStockBySymbol(symbols);
        }
    }

    class Model
    extends AbstractTableModel {
        private QuoteBundle quoteBundle;
        private HashMap stockHoldings;
        private Object[] symbols;
        private TradingDate date;
        static final /* synthetic */ boolean $assertionsDisabled;

        public Model(List columns, HashMap stockHoldings, QuoteBundle quoteBundle) {
            super(columns);
            this.stockHoldings = stockHoldings;
            this.quoteBundle = quoteBundle;
            this.symbols = stockHoldings.keySet().toArray();
            this.date = quoteBundle.getLastDate();
        }

        public int getRowCount() {
            return this.symbols.length;
        }

        public Object getValueAt(int row, int column) {
            if (row >= this.getRowCount()) {
                return "";
            }
            Symbol symbol = (Symbol)this.symbols[row];
            StockHolding stockHolding = (StockHolding)this.stockHoldings.get(symbol);
            if (stockHolding == null) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                return "";
            }
            switch (column) {
                case 0: {
                    return symbol;
                }
                case 1: {
                    return new Integer(stockHolding.getShares());
                }
                case 2: {
                    return new QuoteFormat(stockHolding.getCost());
                }
                case 3: {
                    try {
                        return new QuoteFormat(this.quoteBundle.getQuote(symbol, 0, this.date));
                    }
                    catch (MissingQuoteException e) {
                        return new QuoteFormat(0.0);
                    }
                }
                case 4: {
                    try {
                        return new Money(this.quoteBundle.getQuote(symbol, 0, this.date) * (double)stockHolding.getShares());
                    }
                    catch (MissingQuoteException e) {
                        return Money.ZERO;
                    }
                }
                case 7: {
                    try {
                        return new ChangeFormat(stockHolding.getCost(), this.quoteBundle.getQuote(symbol, 0, this.date));
                    }
                    catch (MissingQuoteException e) {
                        return new ChangeFormat(1.0, 1.0);
                    }
                }
                case 5: {
                    try {
                        double finalQuote = this.quoteBundle.getQuote(symbol, 0, this.date);
                        double initialQuote = this.quoteBundle.getQuote(symbol, 1, this.date);
                        try {
                            initialQuote = this.quoteBundle.getQuote(symbol, 0, this.date.previous(1));
                        }
                        catch (MissingQuoteException e) {
                            // empty catch block
                        }
                        return new PointChangeFormat(initialQuote, finalQuote);
                    }
                    catch (MissingQuoteException e) {
                        return new PointChangeFormat(1.0, 1.0);
                    }
                }
                case 6: {
                    try {
                        double finalQuote = this.quoteBundle.getQuote(symbol, 0, this.date);
                        double initialQuote = this.quoteBundle.getQuote(symbol, 1, this.date);
                        try {
                            initialQuote = this.quoteBundle.getQuote(symbol, 0, this.date.previous(1));
                        }
                        catch (MissingQuoteException e) {
                            // empty catch block
                        }
                        return new ChangeFormat(initialQuote, finalQuote);
                    }
                    catch (MissingQuoteException e) {
                        return new ChangeFormat(1.0, 1.0);
                    }
                }
            }
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return "";
        }

        static {
            $assertionsDisabled = !(class$org$mov$portfolio$StockHoldingTable == null ? (class$org$mov$portfolio$StockHoldingTable = StockHoldingTable.class$("org.mov.portfolio.StockHoldingTable")) : class$org$mov$portfolio$StockHoldingTable).desiredAssertionStatus();
        }
    }
}

