/*
 * Decompiled with CFR 0.152.
 */
package org.mov.portfolio;

import org.mov.portfolio.CashAccount;
import org.mov.portfolio.ShareAccount;
import org.mov.quote.Symbol;
import org.mov.util.Locale;
import org.mov.util.Money;
import org.mov.util.TradingDate;

public class Transaction
implements Cloneable,
Comparable {
    public static final int WITHDRAWAL = 0;
    public static final int DEPOSIT = 1;
    public static final int INTEREST = 2;
    public static final int FEE = 3;
    public static final int ACCUMULATE = 4;
    public static final int REDUCE = 5;
    public static final int DIVIDEND = 6;
    public static final int DIVIDEND_DRP = 7;
    public static final int TRANSFER = 8;
    private TradingDate date;
    private int type;
    private Money amount;
    private Symbol symbol;
    private int shares;
    private Money tradeCost;
    private CashAccount cashAccount;
    private CashAccount cashAccount2;
    private ShareAccount shareAccount;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Transaction(int type, TradingDate date, Money amount, Symbol symbol, int shares, Money tradeCost, CashAccount cashAccount, CashAccount cashAccount2, ShareAccount shareAccount) {
        this.type = type;
        this.date = date;
        this.amount = amount;
        this.symbol = symbol;
        this.shares = shares;
        this.tradeCost = tradeCost;
        this.cashAccount = cashAccount;
        this.cashAccount2 = cashAccount2;
        this.shareAccount = shareAccount;
    }

    public static Transaction newWithdrawal(TradingDate date, Money amount, CashAccount account) {
        return new Transaction(0, date, amount, null, 0, Money.ZERO, account, null, null);
    }

    public static Transaction newDeposit(TradingDate date, Money amount, CashAccount account) {
        return new Transaction(1, date, amount, null, 0, Money.ZERO, account, null, null);
    }

    public static Transaction newInterest(TradingDate date, Money amount, CashAccount account) {
        return new Transaction(2, date, amount, null, 0, Money.ZERO, account, null, null);
    }

    public static Transaction newFee(TradingDate date, Money amount, CashAccount account) {
        return new Transaction(3, date, amount, null, 0, Money.ZERO, account, null, null);
    }

    public static Transaction newAccumulate(TradingDate date, Money amount, Symbol symbol, int shares, Money tradeCost, CashAccount cashAccount, ShareAccount shareAccount) {
        return new Transaction(4, date, amount, symbol, shares, tradeCost, cashAccount, null, shareAccount);
    }

    public static Transaction newReduce(TradingDate date, Money amount, Symbol symbol, int shares, Money tradeCost, CashAccount cashAccount, ShareAccount shareAccount) {
        return new Transaction(5, date, amount, symbol, shares, tradeCost, cashAccount, null, shareAccount);
    }

    public static Transaction newDividend(TradingDate date, Money amount, Symbol symbol, CashAccount cashAccount, ShareAccount shareAccount) {
        return new Transaction(6, date, amount, symbol, 0, Money.ZERO, cashAccount, null, shareAccount);
    }

    public static Transaction newDividendDRP(TradingDate date, Money amount, Symbol symbol, int shares, ShareAccount shareAccount) {
        return new Transaction(7, date, Money.ZERO, symbol, shares, Money.ZERO, null, null, shareAccount);
    }

    public static Transaction newTransfer(TradingDate date, Money amount, CashAccount cashAccount, CashAccount cashAccount2) {
        return new Transaction(8, date, amount, null, 0, Money.ZERO, cashAccount, cashAccount2, null);
    }

    public static String typeToString(int type) {
        String[] typeNames = new String[]{Locale.getString("WITHDRAWAL_TRANSACTION"), Locale.getString("DEPOSIT_TRANSACTION"), Locale.getString("INTEREST_TRANSACTION"), Locale.getString("FEE_TRANSACTION"), Locale.getString("ACCUMULATE_TRANSACTION"), Locale.getString("REDUCE_TRANSACTION"), Locale.getString("DIVIDEND_TRANSACTION"), Locale.getString("DIVIDEND_DRP_TRANSACTION"), Locale.getString("TRANSFER_TRANSACTION")};
        if (type < typeNames.length) {
            return typeNames[type];
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return Locale.getString("TRANSFER");
    }

    public static int stringToType(String type) {
        if (type.equals(Locale.getString("ACCUMULATE_TRANSACTION"))) {
            return 4;
        }
        if (type.equals(Locale.getString("REDUCE_TRANSACTION"))) {
            return 5;
        }
        if (type.equals(Locale.getString("DEPOSIT_TRANSACTION"))) {
            return 1;
        }
        if (type.equals(Locale.getString("FEE_TRANSACTION"))) {
            return 3;
        }
        if (type.equals(Locale.getString("INTEREST_TRANSACTION"))) {
            return 2;
        }
        if (type.equals(Locale.getString("WITHDRAWAL_TRANSACTION"))) {
            return 0;
        }
        if (type.equals(Locale.getString("DIVIDEND_TRANSACTION"))) {
            return 6;
        }
        if (type.equals(Locale.getString("DIVIDEND_DRP_TRANSACTION"))) {
            return 7;
        }
        if (!$assertionsDisabled && !type.equals(Locale.getString("TRANSFER_TRANSACTION"))) {
            throw new AssertionError();
        }
        return 8;
    }

    public int compareTo(Object object) {
        Transaction transaction = (Transaction)object;
        return this.getDate().compareTo(transaction.getDate());
    }

    public boolean equals(Object object) {
        Transaction transaction = (Transaction)object;
        if (!transaction.getDate().equals(this.getDate()) || transaction.getType() != this.getType() && !transaction.getAmount().equals(this.getAmount()) || transaction.getShares() != this.getShares() || !transaction.getTradeCost().equals(this.getTradeCost())) {
            return false;
        }
        if (transaction.getSymbol() == null != (this.getSymbol() == null) || transaction.getCashAccount() == null != (this.getCashAccount() == null) || transaction.getCashAccount2() == null != (this.getCashAccount2() == null) || transaction.getShareAccount() == null != (this.getShareAccount() == null)) {
            return false;
        }
        if (transaction.getSymbol() != null && !transaction.getSymbol().equals(this.getSymbol())) {
            return false;
        }
        if (transaction.getCashAccount() != null && !transaction.getCashAccount().getName().equals(this.getCashAccount().getName())) {
            return false;
        }
        if (transaction.getCashAccount2() != null && !transaction.getCashAccount2().getName().equals(this.getCashAccount2().getName())) {
            return false;
        }
        return transaction.getShareAccount() == null || transaction.getShareAccount().getName().equals(this.getShareAccount().getName());
    }

    public Object clone() {
        Transaction clonedTransaction = new Transaction(this.getType(), this.getDate(), this.getAmount(), this.getSymbol(), this.getShares(), this.getTradeCost(), this.getCashAccount(), this.getCashAccount2(), this.getShareAccount());
        return clonedTransaction;
    }

    public String toString() {
        String cashAccountName = "";
        String cashAccountName2 = "";
        String shareAccountName = "";
        String symbol = "-";
        if (this.getCashAccount() != null) {
            cashAccountName = this.getCashAccount().getName();
        }
        if (this.getCashAccount2() != null) {
            cashAccountName2 = this.getCashAccount2().getName();
        }
        if (this.getShareAccount() != null) {
            shareAccountName = this.getShareAccount().getName();
        }
        if (this.getSymbol() != null) {
            symbol = this.getSymbol().toString();
        }
        return new String(this.getDate().toString("dd/mm/yyyy") + "\t" + Transaction.typeToString(this.getType()) + "\t" + this.getAmount() + "\t" + symbol + "\t" + this.getShares() + "\t" + this.getTradeCost() + "\t" + cashAccountName + "\t" + cashAccountName2 + "\t" + shareAccountName);
    }

    public int getType() {
        return this.type;
    }

    public TradingDate getDate() {
        return this.date;
    }

    public Money getAmount() {
        return this.amount;
    }

    public Symbol getSymbol() {
        return this.symbol;
    }

    public int getShares() {
        return this.shares;
    }

    public Money getTradeCost() {
        return this.tradeCost;
    }

    public CashAccount getCashAccount() {
        return this.cashAccount;
    }

    public CashAccount getCashAccount2() {
        return this.cashAccount2;
    }

    public ShareAccount getShareAccount() {
        return this.shareAccount;
    }

    public void setCashAccount(CashAccount cashAccount) {
        this.cashAccount = cashAccount;
    }

    public void setCashAccount2(CashAccount cashAccount2) {
        this.cashAccount2 = cashAccount2;
    }

    public void setShareAccount(ShareAccount shareAccount) {
        this.shareAccount = shareAccount;
    }

    static {
        $assertionsDisabled = !Transaction.class.desiredAssertionStatus();
    }
}

