/*
 * Decompiled with CFR 0.152.
 */
package org.mov.portfolio;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.mov.portfolio.Account;
import org.mov.portfolio.CashAccount;
import org.mov.portfolio.Portfolio;
import org.mov.portfolio.PortfolioSymbolComboBox;
import org.mov.portfolio.ShareAccount;
import org.mov.portfolio.Transaction;
import org.mov.quote.Symbol;
import org.mov.quote.SymbolFormatException;
import org.mov.ui.GridBagHelper;
import org.mov.util.Locale;
import org.mov.util.Money;
import org.mov.util.MoneyFormatException;
import org.mov.util.TradingDate;
import org.mov.util.TradingDateFormatException;

public class TransactionDialog
extends JInternalFrame
implements ActionListener {
    private JDesktopPane desktop;
    private JButton okButton;
    private JButton cancelButton;
    private JPanel mainPanel;
    private JPanel transactionPanel;
    private JComboBox typeComboBox;
    private JTextField dateTextField;
    private JTextField amountTextField;
    private JTextField symbolTextField;
    private JTextField sharesTextField;
    private JTextField tradeCostTextField;
    private JComboBox cashAccountComboBox;
    private JComboBox cashAccountComboBox2;
    private JComboBox shareAccountComboBox;
    private PortfolioSymbolComboBox symbolComboBox;
    private Portfolio portfolio;
    private boolean isDone = false;
    private boolean okButtonPressed = false;
    private Transaction transaction;
    static final /* synthetic */ boolean $assertionsDisabled;

    public TransactionDialog(JDesktopPane desktop, Portfolio portfolio) {
        this.desktop = desktop;
        this.portfolio = portfolio;
        this.setLayer(JLayeredPane.MODAL_LAYER);
        this.getContentPane().setLayout(new BorderLayout());
        this.mainPanel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.mainPanel.setLayout(gridbag);
        c.weightx = 1.0;
        c.ipadx = 5;
        c.anchor = 17;
        JLabel typeLabel = new JLabel(Locale.getString("TRANSACTION_TYPE"));
        c.gridwidth = 1;
        gridbag.setConstraints(typeLabel, c);
        this.mainPanel.add(typeLabel);
        this.typeComboBox = new JComboBox();
        if (portfolio.countAccounts(1) > 0) {
            boolean haveShares = portfolio.getSymbolsTraded().size() > 0;
            this.typeComboBox.addItem(Transaction.typeToString(4));
            this.typeComboBox.addItem(Transaction.typeToString(1));
            if (haveShares) {
                this.typeComboBox.addItem(Transaction.typeToString(6));
                this.typeComboBox.addItem(Transaction.typeToString(7));
            }
            this.typeComboBox.addItem(Transaction.typeToString(3));
            this.typeComboBox.addItem(Transaction.typeToString(2));
            if (haveShares) {
                this.typeComboBox.addItem(Transaction.typeToString(5));
            }
            if (portfolio.countAccounts(0) >= 2) {
                this.typeComboBox.addItem(Transaction.typeToString(8));
            }
            this.typeComboBox.addItem(Transaction.typeToString(0));
        } else {
            this.typeComboBox.addItem(Transaction.typeToString(1));
            this.typeComboBox.addItem(Transaction.typeToString(3));
            this.typeComboBox.addItem(Transaction.typeToString(2));
            if (portfolio.countAccounts(0) >= 2) {
                this.typeComboBox.addItem(Transaction.typeToString(8));
            }
            this.typeComboBox.addItem(Transaction.typeToString(0));
        }
        this.typeComboBox.addActionListener(this);
        c.gridwidth = 0;
        gridbag.setConstraints(this.typeComboBox, c);
        this.mainPanel.add(this.typeComboBox);
        TradingDate today = new TradingDate();
        this.dateTextField = GridBagHelper.addTextRow(this.mainPanel, Locale.getString("DATE"), today.toString("dd/mm/yyyy"), gridbag, c, 10);
        JPanel buttonPanel = new JPanel();
        this.okButton = new JButton(Locale.getString("OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(Locale.getString("CANCEL"));
        this.cancelButton.addActionListener(this);
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        this.getContentPane().add((Component)this.mainPanel, "North");
        this.getContentPane().add((Component)buttonPanel, "South");
        this.setFrameSize();
        this.symbolComboBox = null;
        this.symbolTextField = null;
        this.transactionPanel = portfolio.countAccounts(1) > 0 ? this.getAccumulatePanel() : this.getCashPanel();
        this.getContentPane().add((Component)this.transactionPanel, "Center");
    }

    private JComboBox getCashAccountComboBox() {
        List accounts = this.portfolio.getAccounts();
        Iterator iterator = accounts.iterator();
        this.cashAccountComboBox = new JComboBox();
        while (iterator.hasNext()) {
            Account account = (Account)iterator.next();
            if (account.getType() != 0) continue;
            this.cashAccountComboBox.addItem(account.getName());
        }
        return this.cashAccountComboBox;
    }

    private JComboBox getCashAccountComboBox2() {
        List accounts = this.portfolio.getAccounts();
        Iterator iterator = accounts.iterator();
        this.cashAccountComboBox2 = new JComboBox();
        while (iterator.hasNext()) {
            Account account = (Account)iterator.next();
            if (account.getType() != 0) continue;
            this.cashAccountComboBox2.addItem(account.getName());
        }
        return this.cashAccountComboBox2;
    }

    private JComboBox getSymbolComboBox() {
        this.symbolComboBox = new PortfolioSymbolComboBox(this.portfolio, null);
        return this.symbolComboBox;
    }

    private JComboBox getShareAccountComboBox() {
        List accounts = this.portfolio.getAccounts();
        Iterator iterator = accounts.iterator();
        this.shareAccountComboBox = new JComboBox();
        while (iterator.hasNext()) {
            Account account = (Account)iterator.next();
            if (account.getType() != 1) continue;
            this.shareAccountComboBox.addItem(account.getName());
        }
        return this.shareAccountComboBox;
    }

    private JPanel getDividendPanel() {
        JPanel borderPanel = new JPanel();
        TitledBorder titled = new TitledBorder(Locale.getString("DIVIDEND_TRANSACTION"));
        borderPanel.setBorder(titled);
        borderPanel.setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        panel.setLayout(gridbag);
        c.weightx = 1.0;
        c.ipadx = 5;
        c.anchor = 17;
        JLabel cashAccountLabel = new JLabel(Locale.getString("CASH_ACCOUNT"));
        c.gridwidth = 1;
        gridbag.setConstraints(cashAccountLabel, c);
        panel.add(cashAccountLabel);
        JComboBox cashAccountComboBox = this.getCashAccountComboBox();
        c.gridwidth = 0;
        gridbag.setConstraints(cashAccountComboBox, c);
        panel.add(cashAccountComboBox);
        JLabel shareAccountLabel = new JLabel(Locale.getString("SHARE_ACCOUNT"));
        c.gridwidth = 1;
        gridbag.setConstraints(shareAccountLabel, c);
        panel.add(shareAccountLabel);
        JComboBox shareAccountComboBox = this.getShareAccountComboBox();
        c.gridwidth = 0;
        gridbag.setConstraints(shareAccountComboBox, c);
        panel.add(shareAccountComboBox);
        JLabel symbolLabel = new JLabel(Locale.getString("SYMBOL"));
        c.gridwidth = 1;
        gridbag.setConstraints(symbolLabel, c);
        panel.add(symbolLabel);
        JComboBox symbolComboBox = this.getSymbolComboBox();
        c.gridwidth = 0;
        gridbag.setConstraints(symbolComboBox, c);
        panel.add(symbolComboBox);
        this.amountTextField = GridBagHelper.addTextRow(panel, Locale.getString("TOTAL_DIVIDEND_VALUE"), "", gridbag, c, 15);
        borderPanel.add((Component)panel, "North");
        return borderPanel;
    }

    private JPanel getDividendDRPPanel() {
        JPanel borderPanel = new JPanel();
        TitledBorder titled = new TitledBorder(Locale.getString("DIVIDEND_DRP_TRANSACTION"));
        borderPanel.setBorder(titled);
        borderPanel.setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        panel.setLayout(gridbag);
        c.weightx = 1.0;
        c.ipadx = 5;
        c.anchor = 17;
        JLabel shareAccountLabel = new JLabel(Locale.getString("SHARE_ACCOUNT"));
        c.gridwidth = 1;
        gridbag.setConstraints(shareAccountLabel, c);
        panel.add(shareAccountLabel);
        JComboBox shareAccountComboBox = this.getShareAccountComboBox();
        c.gridwidth = 0;
        gridbag.setConstraints(shareAccountComboBox, c);
        panel.add(shareAccountComboBox);
        JLabel symbolLabel = new JLabel(Locale.getString("SYMBOL"));
        c.gridwidth = 1;
        gridbag.setConstraints(symbolLabel, c);
        panel.add(symbolLabel);
        JComboBox symbolComboBox = this.getSymbolComboBox();
        c.gridwidth = 0;
        gridbag.setConstraints(symbolComboBox, c);
        panel.add(symbolComboBox);
        this.sharesTextField = GridBagHelper.addTextRow(panel, Locale.getString("SHARES"), "", gridbag, c, 15);
        borderPanel.add((Component)panel, "North");
        return borderPanel;
    }

    private JPanel getAccumulatePanel() {
        JPanel borderPanel = new JPanel();
        TitledBorder titled = new TitledBorder(Locale.getString("ACCUMULATE_TRANSACTION"));
        borderPanel.setBorder(titled);
        borderPanel.setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        panel.setLayout(gridbag);
        c.weightx = 1.0;
        c.ipadx = 5;
        c.anchor = 17;
        JLabel cashAccountLabel = new JLabel(Locale.getString("CASH_ACCOUNT"));
        c.gridwidth = 1;
        gridbag.setConstraints(cashAccountLabel, c);
        panel.add(cashAccountLabel);
        JComboBox cashAccountComboBox = this.getCashAccountComboBox();
        c.gridwidth = 0;
        gridbag.setConstraints(cashAccountComboBox, c);
        panel.add(cashAccountComboBox);
        JLabel shareAccountLabel = new JLabel(Locale.getString("SHARE_ACCOUNT"));
        c.gridwidth = 1;
        gridbag.setConstraints(shareAccountLabel, c);
        panel.add(shareAccountLabel);
        JComboBox shareAccountComboBox = this.getShareAccountComboBox();
        c.gridwidth = 0;
        gridbag.setConstraints(shareAccountComboBox, c);
        panel.add(shareAccountComboBox);
        this.symbolTextField = GridBagHelper.addTextRow(panel, Locale.getString("SYMBOL"), "", gridbag, c, 5);
        this.sharesTextField = GridBagHelper.addTextRow(panel, Locale.getString("SHARES"), "", gridbag, c, 15);
        this.amountTextField = GridBagHelper.addTextRow(panel, Locale.getString("TOTAL_SHARE_VALUE"), "", gridbag, c, 15);
        this.tradeCostTextField = GridBagHelper.addTextRow(panel, Locale.getString("TRADE_COST"), "", gridbag, c, 15);
        borderPanel.add((Component)panel, "North");
        return borderPanel;
    }

    private JPanel getReducePanel() {
        JPanel borderPanel = new JPanel();
        TitledBorder titled = new TitledBorder(Locale.getString("REDUCE_TRANSACTION"));
        borderPanel.setBorder(titled);
        borderPanel.setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        panel.setLayout(gridbag);
        c.weightx = 1.0;
        c.ipadx = 5;
        c.anchor = 17;
        JLabel cashAccountLabel = new JLabel(Locale.getString("CASH_ACCOUNT"));
        c.gridwidth = 1;
        gridbag.setConstraints(cashAccountLabel, c);
        panel.add(cashAccountLabel);
        JComboBox cashAccountComboBox = this.getCashAccountComboBox();
        c.gridwidth = 0;
        gridbag.setConstraints(cashAccountComboBox, c);
        panel.add(cashAccountComboBox);
        JLabel shareAccountLabel = new JLabel(Locale.getString("SHARE_ACCOUNT"));
        c.gridwidth = 1;
        gridbag.setConstraints(shareAccountLabel, c);
        panel.add(shareAccountLabel);
        JComboBox shareAccountComboBox = this.getShareAccountComboBox();
        c.gridwidth = 0;
        gridbag.setConstraints(shareAccountComboBox, c);
        panel.add(shareAccountComboBox);
        JLabel symbolLabel = new JLabel(Locale.getString("SYMBOL"));
        c.gridwidth = 1;
        gridbag.setConstraints(symbolLabel, c);
        panel.add(symbolLabel);
        JComboBox symbolComboBox = this.getSymbolComboBox();
        c.gridwidth = 0;
        gridbag.setConstraints(symbolComboBox, c);
        panel.add(symbolComboBox);
        this.sharesTextField = GridBagHelper.addTextRow(panel, Locale.getString("SHARES"), "", gridbag, c, 15);
        this.amountTextField = GridBagHelper.addTextRow(panel, Locale.getString("TOTAL_SHARE_VALUE"), "", gridbag, c, 15);
        this.tradeCostTextField = GridBagHelper.addTextRow(panel, Locale.getString("TRADE_COST"), "", gridbag, c, 15);
        borderPanel.add((Component)panel, "North");
        return borderPanel;
    }

    private JPanel getCashPanel() {
        JPanel borderPanel = new JPanel();
        TitledBorder titled = new TitledBorder(Locale.getString("CASH_TRANSACTION"));
        borderPanel.setBorder(titled);
        borderPanel.setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        panel.setLayout(gridbag);
        c.weightx = 1.0;
        c.ipadx = 5;
        c.anchor = 17;
        JLabel cashAccountLabel = new JLabel(Locale.getString("CASH_ACCOUNT"));
        c.gridwidth = 1;
        gridbag.setConstraints(cashAccountLabel, c);
        panel.add(cashAccountLabel);
        JComboBox cashAccountComboBox = this.getCashAccountComboBox();
        c.gridwidth = 0;
        gridbag.setConstraints(cashAccountComboBox, c);
        panel.add(cashAccountComboBox);
        this.amountTextField = GridBagHelper.addTextRow(panel, Locale.getString("AMOUNT"), "", gridbag, c, 15);
        borderPanel.add((Component)panel, "North");
        return borderPanel;
    }

    private JPanel getTransferPanel() {
        JPanel borderPanel = new JPanel();
        TitledBorder titled = new TitledBorder(Locale.getString("TRANSFER_TRANSACTION"));
        borderPanel.setBorder(titled);
        borderPanel.setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        panel.setLayout(gridbag);
        c.weightx = 1.0;
        c.ipadx = 5;
        c.anchor = 17;
        JLabel cashAccountLabel = new JLabel(Locale.getString("SOURCE_CASH_ACCOUNT"));
        c.gridwidth = 1;
        gridbag.setConstraints(cashAccountLabel, c);
        panel.add(cashAccountLabel);
        JComboBox cashAccountComboBox = this.getCashAccountComboBox();
        c.gridwidth = 0;
        gridbag.setConstraints(cashAccountComboBox, c);
        panel.add(cashAccountComboBox);
        JLabel cashAccountLabel2 = new JLabel(Locale.getString("DESTINATION_CASH_ACCOUNT"));
        c.gridwidth = 1;
        gridbag.setConstraints(cashAccountLabel2, c);
        panel.add(cashAccountLabel2);
        JComboBox cashAccountComboBox2 = this.getCashAccountComboBox2();
        c.gridwidth = 0;
        gridbag.setConstraints(cashAccountComboBox2, c);
        panel.add(cashAccountComboBox2);
        this.amountTextField = GridBagHelper.addTextRow(panel, Locale.getString("AMOUNT"), "", gridbag, c, 15);
        borderPanel.add((Component)panel, "North");
        return borderPanel;
    }

    private Dimension getPreferredSizeWithPanel(JPanel panel) {
        if (this.transactionPanel != null) {
            this.getContentPane().remove(this.transactionPanel);
        }
        this.getContentPane().add((Component)panel, "Center");
        this.transactionPanel = panel;
        return this.getPreferredSize();
    }

    private void setFrameSize() {
        int width = 0;
        int height = 0;
        Dimension preferred = this.getPreferredSizeWithPanel(this.getDividendDRPPanel());
        width = preferred.width;
        height = preferred.height;
        preferred = this.getPreferredSizeWithPanel(this.getCashPanel());
        width = Math.max(width, preferred.width);
        height = Math.max(height, preferred.height);
        preferred = this.getPreferredSizeWithPanel(this.getDividendPanel());
        width = Math.max(width, preferred.width);
        height = Math.max(height, preferred.height);
        preferred = this.getPreferredSizeWithPanel(this.getAccumulatePanel());
        width = Math.max(width, preferred.width);
        height = Math.max(height, preferred.height);
        preferred = this.getPreferredSizeWithPanel(this.getReducePanel());
        width = Math.max(width, preferred.width);
        height = Math.max(height, preferred.height);
        preferred = this.getPreferredSizeWithPanel(this.getTransferPanel());
        width = Math.max(width, preferred.width);
        height = Math.max(height, preferred.height);
        int x = (this.desktop.getWidth() - width) / 2;
        int y = (this.desktop.getHeight() - height) / 2;
        this.setBounds(x, y, width, height);
    }

    public boolean newTransaction() {
        this.setTitle(Locale.getString("NEW_TRANSACTION"));
        this.desktop.add(this);
        this.show();
        try {
            while (!this.isDone) {
                Thread.sleep(10L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.okButtonPressed) {
            this.portfolio.addTransaction(this.transaction);
        }
        return this.okButtonPressed;
    }

    public boolean editTransaction(Transaction oldTransaction) {
        this.setTitle(Locale.getString("EDIT_TRANSACTION"));
        this.displayTransaction(oldTransaction);
        this.desktop.add(this);
        this.show();
        try {
            while (!this.isDone) {
                Thread.sleep(10L);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.okButtonPressed) {
            ArrayList<Transaction> transactions = new ArrayList<Transaction>(this.portfolio.getTransactions());
            Iterator iterator = transactions.iterator();
            while (iterator.hasNext()) {
                Transaction traverseTransaction = (Transaction)iterator.next();
                if (traverseTransaction != oldTransaction) continue;
                iterator.remove();
                break;
            }
            transactions.add(this.transaction);
            this.portfolio.removeAllTransactions();
            this.portfolio.addTransactions(transactions);
        }
        return this.okButtonPressed;
    }

    private void displayTransaction(Transaction transaction) {
        int type = transaction.getType();
        this.setTransactionPanel(type);
        this.typeComboBox.setSelectedItem(Transaction.typeToString(type));
        this.dateTextField.setText(transaction.getDate().toString("dd/mm/yyyy"));
        if (type == 4) {
            this.cashAccountComboBox.setSelectedItem(transaction.getCashAccount().getName());
            this.shareAccountComboBox.setSelectedItem(transaction.getShareAccount().getName());
            this.symbolTextField.setText(transaction.getSymbol().toString());
            this.sharesTextField.setText(String.valueOf(transaction.getShares()));
            this.amountTextField.setText(String.valueOf(transaction.getAmount()));
            this.tradeCostTextField.setText(String.valueOf(transaction.getTradeCost()));
        } else if (type == 5) {
            this.cashAccountComboBox.setSelectedItem(transaction.getCashAccount().getName());
            this.shareAccountComboBox.setSelectedItem(transaction.getShareAccount().getName());
            this.symbolComboBox.setSelectedItem(transaction.getSymbol());
            this.sharesTextField.setText(String.valueOf(transaction.getShares()));
            this.amountTextField.setText(String.valueOf(transaction.getAmount()));
            this.tradeCostTextField.setText(String.valueOf(transaction.getTradeCost()));
        } else if (type == 1 || type == 3 || type == 2 || type == 0) {
            this.amountTextField.setText(String.valueOf(transaction.getAmount()));
            this.cashAccountComboBox.setSelectedItem(transaction.getCashAccount().getName());
        } else if (type == 6) {
            this.cashAccountComboBox.setSelectedItem(transaction.getCashAccount().getName());
            this.shareAccountComboBox.setSelectedItem(transaction.getShareAccount().getName());
            this.symbolComboBox.setSelectedItem(transaction.getSymbol());
            this.amountTextField.setText(String.valueOf(transaction.getAmount()));
        } else if (type == 7) {
            this.shareAccountComboBox.setSelectedItem(transaction.getShareAccount().getName());
            this.symbolComboBox.setSelectedItem(transaction.getSymbol());
            this.sharesTextField.setText(String.valueOf(transaction.getShares()));
        } else {
            if (!$assertionsDisabled && type != 8) {
                throw new AssertionError();
            }
            this.cashAccountComboBox.setSelectedItem(transaction.getCashAccount().getName());
            this.cashAccountComboBox2.setSelectedItem(transaction.getCashAccount2().getName());
            this.amountTextField.setText(String.valueOf(transaction.getAmount()));
        }
    }

    private void setTransactionPanel(int type) {
        this.getContentPane().remove(this.transactionPanel);
        this.symbolComboBox = null;
        this.symbolTextField = null;
        if (type == 4) {
            this.transactionPanel = this.getAccumulatePanel();
        } else if (type == 5) {
            this.transactionPanel = this.getReducePanel();
        } else if (type == 1 || type == 3 || type == 2 || type == 0) {
            this.transactionPanel = this.getCashPanel();
        } else if (type == 6) {
            this.transactionPanel = this.getDividendPanel();
        } else if (type == 7) {
            this.transactionPanel = this.getDividendDRPPanel();
        } else {
            if (!$assertionsDisabled && type != 8) {
                throw new AssertionError();
            }
            this.transactionPanel = this.getTransferPanel();
        }
        this.getContentPane().add((Component)this.transactionPanel, "Center");
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.transaction = this.buildTransaction();
            if (this.transaction != null) {
                this.dispose();
                this.isDone = true;
                this.okButtonPressed = true;
            }
        } else if (e.getSource() == this.cancelButton) {
            this.transaction = null;
            this.dispose();
            this.isDone = true;
            this.okButtonPressed = false;
        } else if (e.getSource() == this.typeComboBox) {
            String selected = (String)this.typeComboBox.getSelectedItem();
            int type = Transaction.stringToType(selected);
            this.setTransactionPanel(type);
            this.validate();
            this.repaint();
        }
    }

    private Transaction buildTransaction() {
        Transaction transaction = null;
        String symbolParseError = null;
        TradingDate date = null;
        int type = Transaction.stringToType((String)this.typeComboBox.getSelectedItem());
        try {
            date = new TradingDate(this.dateTextField.getText(), 1);
        }
        catch (TradingDateFormatException e) {
            String message = new String(Locale.getString("ERROR_PARSING_DATE", this.dateTextField.getText()));
            JOptionPane.showInternalMessageDialog(this.desktop, message, Locale.getString("ERROR_BUILDING_TRANSACTION"), 0);
            return null;
        }
        Symbol symbol = null;
        if (this.symbolComboBox != null) {
            symbol = (Symbol)this.symbolComboBox.getSelectedItem();
        } else if (this.symbolTextField != null) {
            try {
                symbol = Symbol.toSymbol(this.symbolTextField.getText());
            }
            catch (SymbolFormatException e) {
                symbolParseError = e.getMessage();
            }
        }
        CashAccount cashAccount = null;
        if (this.cashAccountComboBox != null) {
            String accountName = (String)this.cashAccountComboBox.getSelectedItem();
            cashAccount = (CashAccount)this.portfolio.findAccountByName(accountName);
        }
        CashAccount cashAccount2 = null;
        if (this.cashAccountComboBox2 != null) {
            String accountName = (String)this.cashAccountComboBox2.getSelectedItem();
            cashAccount2 = (CashAccount)this.portfolio.findAccountByName(accountName);
        }
        ShareAccount shareAccount = null;
        if (this.shareAccountComboBox != null) {
            String accountName = (String)this.shareAccountComboBox.getSelectedItem();
            shareAccount = (ShareAccount)this.portfolio.findAccountByName(accountName);
        }
        Money amount = Money.ZERO;
        int shares = 0;
        Money tradeCost = Money.ZERO;
        try {
            if (this.amountTextField != null && !this.amountTextField.getText().equals("")) {
                amount = new Money(this.amountTextField.getText());
            }
            if (this.sharesTextField != null && !this.sharesTextField.getText().equals("")) {
                shares = Integer.parseInt(this.sharesTextField.getText());
            }
            if (this.tradeCostTextField != null && !this.tradeCostTextField.getText().equals("")) {
                tradeCost = new Money(this.tradeCostTextField.getText());
            }
        }
        catch (MoneyFormatException e) {
            String message = new String(Locale.getString("ERROR_PARSING_NUMBER", e.getReason()));
            JOptionPane.showInternalMessageDialog(this.desktop, message, Locale.getString("ERROR_BUILDING_TRANSACTION"), 0);
            return null;
        }
        catch (NumberFormatException e) {
            String message = new String(Locale.getString("CANT_PARSE_NUMBER", e.getMessage()));
            JOptionPane.showInternalMessageDialog(this.desktop, message, Locale.getString("ERROR_BUILDING_TRANSACTION"), 0);
            return null;
        }
        if (type == 8 && cashAccount == cashAccount2) {
            JOptionPane.showInternalMessageDialog(this.desktop, Locale.getString("SOURCE_AND_DESTINATION_SAME"), Locale.getString("ERROR_BUILDING_TRANSACTION"), 0);
            return null;
        }
        if ((type == 4 || type == 5 || type == 7) && symbolParseError != null) {
            JOptionPane.showInternalMessageDialog(this.desktop, symbolParseError, Locale.getString("ERROR_BUILDING_TRANSACTION"), 0);
            return null;
        }
        if ((type == 4 || type == 5 || type == 7) && shares <= 0) {
            JOptionPane.showInternalMessageDialog(this.desktop, Locale.getString("SHARES_GREATER_THAN_ZERO"), Locale.getString("ERROR_BUILDING_TRANSACTION"), 0);
            return null;
        }
        if (type == 0) {
            transaction = Transaction.newWithdrawal(date, amount, cashAccount);
        } else if (type == 1) {
            transaction = Transaction.newDeposit(date, amount, cashAccount);
        } else if (type == 2) {
            transaction = Transaction.newInterest(date, amount, cashAccount);
        } else if (type == 3) {
            transaction = Transaction.newFee(date, amount, cashAccount);
        } else if (type == 4) {
            transaction = Transaction.newAccumulate(date, amount, symbol, shares, tradeCost, cashAccount, shareAccount);
        } else if (type == 5) {
            transaction = Transaction.newReduce(date, amount, symbol, shares, tradeCost, cashAccount, shareAccount);
        } else if (type == 6) {
            transaction = Transaction.newDividend(date, amount, symbol, cashAccount, shareAccount);
        } else if (type == 7) {
            transaction = Transaction.newDividendDRP(date, amount, symbol, shares, shareAccount);
        } else {
            if (!$assertionsDisabled && type != 8) {
                throw new AssertionError();
            }
            transaction = Transaction.newTransfer(date, amount, cashAccount, cashAccount2);
        }
        return transaction;
    }

    static {
        $assertionsDisabled = !TransactionDialog.class.desiredAssertionStatus();
    }
}

