/*
 * Decompiled with CFR 0.152.
 */
package org.mov.portfolio;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.mov.main.Module;
import org.mov.portfolio.Portfolio;
import org.mov.portfolio.PortfolioModule;
import org.mov.portfolio.Transaction;
import org.mov.portfolio.TransactionDialog;
import org.mov.ui.AbstractTable;
import org.mov.ui.AbstractTableModel;
import org.mov.ui.Column;
import org.mov.ui.ConfirmDialog;
import org.mov.ui.DesktopManager;
import org.mov.ui.MenuHelper;
import org.mov.util.Locale;
import org.mov.util.Money;
import org.mov.util.TradingDate;

public class TransactionModule
extends AbstractTable
implements Module,
ActionListener {
    private static final int DATE_COLUMN = 0;
    private static final int TRANSACTION_COLUMN = 1;
    private static final int CREDIT_COLUMN = 2;
    private static final int DEBIT_COLUMN = 3;
    private JMenuBar menuBar;
    private JMenuItem transactionNew;
    private JMenuItem transactionEdit;
    private JMenuItem transactionDelete;
    private JMenuItem transactionClose;
    private JMenuItem popupTransactionNew;
    private JMenuItem popupTransactionEdit;
    private JMenuItem popupTransactionDelete;
    private PropertyChangeSupport propertySupport;
    private PortfolioModule portfolioModule;
    private Portfolio portfolio;
    private Model model;
    static /* synthetic */ Class class$org$mov$portfolio$TransactionModule;

    private String getTransactionString(Transaction transaction) {
        int type = transaction.getType();
        String transactionString = Transaction.typeToString(type);
        switch (type) {
            case 4: 
            case 5: {
                Money pricePerShare = transaction.getAmount().divide(transaction.getShares());
                transactionString = transactionString.concat(" " + transaction.getShares() + " " + transaction.getSymbol() + " @ " + pricePerShare);
                break;
            }
            case 6: {
                transactionString = transactionString.concat(" " + transaction.getSymbol());
                break;
            }
            case 7: {
                transactionString = transactionString.concat(" " + transaction.getShares() + " " + transaction.getSymbol());
                break;
            }
            case 8: {
                transactionString = transactionString.concat(" " + Locale.getString("FROM") + " " + transaction.getCashAccount().getName() + " " + Locale.getString("TO") + " " + transaction.getCashAccount2().getName());
            }
        }
        return transactionString;
    }

    public TransactionModule(PortfolioModule portfolioModule, Portfolio portfolio) {
        ArrayList<Column> columns = new ArrayList<Column>();
        columns.add(new Column(0, Locale.getString("DATE"), Locale.getString("DATE"), TradingDate.class, 1));
        columns.add(new Column(1, Locale.getString("TRANSACTION"), Locale.getString("TRANSACTION"), String.class, 1));
        columns.add(new Column(2, Locale.getString("CREDIT"), Locale.getString("CREDIT"), Money.class, 1));
        columns.add(new Column(2, Locale.getString("DEBIT"), Locale.getString("DEBIT"), Money.class, 1));
        this.portfolioModule = portfolioModule;
        this.portfolio = portfolio;
        this.model = new Model(columns, portfolio.getTransactions());
        this.setModel(this.model);
        this.propertySupport = new PropertyChangeSupport(this);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                TransactionModule.this.handleMouseClicked(evt);
            }
        });
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                TransactionModule.this.checkMenuDisabledStatus();
            }
        });
        this.createMenu();
    }

    private void handleMouseClicked(MouseEvent event) {
        Point point = event.getPoint();
        if (event.getButton() == 3) {
            JPopupMenu menu = new JPopupMenu();
            this.popupTransactionNew = MenuHelper.addMenuItem((ActionListener)this, menu, Locale.getString("NEW"));
            this.popupTransactionEdit = MenuHelper.addMenuItem((ActionListener)this, menu, Locale.getString("EDIT"));
            this.popupTransactionDelete = MenuHelper.addMenuItem((ActionListener)this, menu, Locale.getString("DELETE"));
            int numberOfSelectedRows = this.getSelectedRowCount();
            this.popupTransactionEdit.setEnabled(numberOfSelectedRows == 1);
            this.popupTransactionDelete.setEnabled(numberOfSelectedRows > 0);
            menu.show(this, point.x, point.y);
        } else if (event.getButton() == 1 && event.getClickCount() == 2) {
            int row = this.getUnsortedRow(this.rowAtPoint(point));
            Transaction transaction = this.model.getTransactionAtRow(row);
            this.editTransaction(transaction);
        }
    }

    private void createMenu() {
        this.menuBar = new JMenuBar();
        JMenu transactionMenu = MenuHelper.addMenu(this.menuBar, Locale.getString("TRANSACTION"), 'T');
        this.transactionNew = MenuHelper.addMenuItem((ActionListener)this, transactionMenu, Locale.getString("NEW"));
        this.transactionEdit = MenuHelper.addMenuItem((ActionListener)this, transactionMenu, Locale.getString("EDIT"));
        this.transactionDelete = MenuHelper.addMenuItem((ActionListener)this, transactionMenu, Locale.getString("DELETE"));
        transactionMenu.addSeparator();
        this.transactionClose = MenuHelper.addMenuItem((ActionListener)this, transactionMenu, Locale.getString("CLOSE"));
        this.checkMenuDisabledStatus();
    }

    private void checkMenuDisabledStatus() {
        int numberOfSelectedRows = this.getSelectedRowCount();
        this.transactionEdit.setEnabled(numberOfSelectedRows == 1);
        this.transactionDelete.setEnabled(numberOfSelectedRows > 0);
    }

    public void redraw() {
        this.resort();
        this.revalidate();
        this.repaint();
    }

    public void save() {
    }

    public String getTitle() {
        return Locale.getString("TRANSACTION_HISTORY_TITLE", this.portfolio.getName());
    }

    public void addModuleChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void removeModuleChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    public ImageIcon getFrameIcon() {
        return null;
    }

    public JComponent getComponent() {
        return this;
    }

    public JMenuBar getJMenuBar() {
        return this.menuBar;
    }

    public boolean encloseInScrollPane() {
        return true;
    }

    private void editTransaction(final Transaction transaction) {
        Thread showEditDialog = new Thread(){

            public void run() {
                JDesktopPane desktop = DesktopManager.getDesktop();
                TransactionDialog dialog = new TransactionDialog(desktop, TransactionModule.this.portfolio);
                if (dialog.editTransaction(transaction)) {
                    SwingUtilities.invokeLater(new Runnable(this){
                        private final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            TransactionModule.access$500(3.access$400(this.this$1)).setTransactions(TransactionModule.access$300(3.access$400(this.this$1)).getTransactions());
                            3.access$400(this.this$1).redraw();
                            TransactionModule.access$600(3.access$400(this.this$1)).redraw();
                        }
                    });
                }
            }

            static /* synthetic */ TransactionModule access$400(3 x0) {
                return x0.TransactionModule.this;
            }
        };
        showEditDialog.start();
    }

    private void deleteTransactions(final List deleteTransactions) {
        JDesktopPane desktop = DesktopManager.getDesktop();
        ConfirmDialog dialog = new ConfirmDialog(desktop, Locale.getString("SURE_DELETE_TRANSACTIONS"), Locale.getString("DELETE_TRANSACTIONS"));
        boolean option = dialog.showDialog();
        if (option) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ArrayList transactions = new ArrayList(TransactionModule.this.portfolio.getTransactions());
                    Iterator iterator = transactions.iterator();
                    while (iterator.hasNext()) {
                        Transaction traverseTransaction = (Transaction)iterator.next();
                        if (!deleteTransactions.contains(traverseTransaction)) continue;
                        iterator.remove();
                    }
                    TransactionModule.this.portfolio.removeAllTransactions();
                    TransactionModule.this.portfolio.addTransactions(transactions);
                    TransactionModule.this.model.setTransactions(TransactionModule.this.portfolio.getTransactions());
                    TransactionModule.this.redraw();
                    TransactionModule.this.portfolioModule.redraw();
                    TransactionModule.this.clearSelection();
                }
            });
        }
    }

    private void newTransaction() {
        this.portfolioModule.newTransaction();
    }

    public void actionPerformed(final ActionEvent e) {
        Thread menuAction = new Thread(){
            static final /* synthetic */ boolean $assertionsDisabled;

            public void run() {
                if (e.getSource() == TransactionModule.this.transactionNew || TransactionModule.this.popupTransactionNew != null && e.getSource() == TransactionModule.this.popupTransactionNew) {
                    TransactionModule.this.newTransaction();
                } else if (e.getSource() == TransactionModule.this.transactionEdit || TransactionModule.this.popupTransactionEdit != null && e.getSource() == TransactionModule.this.popupTransactionEdit) {
                    Transaction transaction = TransactionModule.this.model.getTransactionAtRow(TransactionModule.this.getSelectedRow());
                    TransactionModule.this.editTransaction(transaction);
                } else if (e.getSource() == TransactionModule.this.transactionDelete || TransactionModule.this.popupTransactionDelete != null && e.getSource() == TransactionModule.this.popupTransactionDelete) {
                    int[] selectedRows = TransactionModule.this.getSelectedRows();
                    ArrayList<Transaction> transactions = new ArrayList<Transaction>();
                    for (int i = 0; i < selectedRows.length; ++i) {
                        transactions.add(TransactionModule.this.model.getTransactionAtRow(selectedRows[i]));
                    }
                    TransactionModule.this.deleteTransactions(transactions);
                } else if (e.getSource() == TransactionModule.this.transactionClose) {
                    TransactionModule.this.propertySupport.firePropertyChange("window close", 0, 1);
                } else if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }

            static {
                $assertionsDisabled = !(class$org$mov$portfolio$TransactionModule == null ? (class$org$mov$portfolio$TransactionModule = TransactionModule.class$("org.mov.portfolio.TransactionModule")) : class$org$mov$portfolio$TransactionModule).desiredAssertionStatus();
            }
        };
        menuAction.start();
    }

    class Model
    extends AbstractTableModel {
        private List transactions;

        public Model(List columns, List transactions) {
            super(columns);
            this.transactions = transactions;
        }

        public void setTransactions(List transactions) {
            this.transactions = transactions;
            this.fireTableDataChanged();
        }

        public Transaction getTransactionAtRow(int row) {
            return (Transaction)this.transactions.get(row);
        }

        public int getRowCount() {
            return this.transactions.size();
        }

        public Object getValueAt(int row, int column) {
            if (row >= this.getRowCount()) {
                return "";
            }
            Transaction transaction = (Transaction)this.transactions.get(row);
            int type = transaction.getType();
            switch (column) {
                case 0: {
                    return transaction.getDate();
                }
                case 1: {
                    return TransactionModule.this.getTransactionString(transaction);
                }
                case 2: {
                    switch (type) {
                        case 1: 
                        case 2: 
                        case 6: 
                        case 8: {
                            return transaction.getAmount();
                        }
                    }
                    return Money.ZERO;
                }
                case 3: {
                    switch (type) {
                        case 0: 
                        case 3: 
                        case 8: {
                            return transaction.getAmount();
                        }
                        case 4: 
                        case 5: {
                            return transaction.getTradeCost();
                        }
                    }
                    return Money.ZERO;
                }
            }
            return "";
        }
    }
}

