/*
 * Decompiled with CFR 0.152.
 */
package org.mov.prefs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.mov.prefs.EquationTable;
import org.mov.prefs.PreferencesPage;
import org.mov.util.Locale;

public class EquationPage
extends JPanel
implements PreferencesPage {
    private JDesktopPane desktop;
    private EquationTable equationTable;
    private JButton addEquationButton;
    private JButton editEquationButton;
    private JButton deleteEquationsButton;

    public EquationPage(JDesktopPane desktop) {
        this.desktop = desktop;
        this.setLayout(new BorderLayout());
        this.equationTable = new EquationTable();
        this.add((Component)new JScrollPane(this.equationTable), "Center");
        JPanel buttonPanel = new JPanel();
        this.addEquationButton = new JButton(Locale.getString("ADD"));
        this.addEquationButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EquationPage.this.equationTable.add();
                EquationPage.this.checkButtonDisabledStatus();
            }
        });
        this.editEquationButton = new JButton(Locale.getString("EDIT"));
        this.editEquationButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int[] selectedRows = EquationPage.this.equationTable.getSelectedRows();
                if (selectedRows.length == 1) {
                    EquationPage.this.equationTable.edit(selectedRows[0]);
                }
            }
        });
        this.deleteEquationsButton = new JButton(Locale.getString("DELETE"));
        this.deleteEquationsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EquationPage.this.equationTable.delete(EquationPage.this.equationTable.getSelectedRows());
                EquationPage.this.checkButtonDisabledStatus();
            }
        });
        buttonPanel.add(this.addEquationButton);
        buttonPanel.add(this.editEquationButton);
        buttonPanel.add(this.deleteEquationsButton);
        this.add((Component)buttonPanel, "South");
        this.checkButtonDisabledStatus();
        this.equationTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent event) {
                EquationPage.this.handleMouseClicked(event);
            }
        });
        this.equationTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                EquationPage.this.checkButtonDisabledStatus();
            }
        });
    }

    private void handleMouseClicked(MouseEvent event) {
        if (event.getButton() == 1 && event.getClickCount() == 2) {
            Point point = event.getPoint();
            int row = this.equationTable.getUnsortedRow(this.equationTable.rowAtPoint(point));
            this.equationTable.edit(row);
        }
    }

    private void checkButtonDisabledStatus() {
        int numberOfSelectedRows = this.equationTable.getSelectedRowCount();
        this.editEquationButton.setEnabled(numberOfSelectedRows == 1);
        this.deleteEquationsButton.setEnabled(numberOfSelectedRows > 0);
    }

    public void save() {
        this.equationTable.save();
    }

    public JComponent getComponent() {
        return this;
    }

    public String getTitle() {
        return Locale.getString("EQUATION_PAGE_TITLE");
    }
}

