/*
 * Decompiled with CFR 0.152.
 */
package org.mov.prefs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.mov.prefs.PreferencesManager;
import org.mov.prefs.StoredEquation;
import org.mov.ui.AbstractTable;
import org.mov.ui.AbstractTableModel;
import org.mov.ui.Column;
import org.mov.ui.EquationComboBox;
import org.mov.ui.ExpressionEditorDialog;
import org.mov.util.Locale;

public class EquationTable
extends AbstractTable {
    private static final int NAME_COLUMN = 0;
    private static final int EQUATION_COLUMN = 1;
    private Model model;
    private List storedEquations;
    static /* synthetic */ Class class$org$mov$prefs$EquationTable;

    public EquationTable() {
        ArrayList<Column> columns = new ArrayList<Column>();
        columns.add(new Column(0, Locale.getString("NAME"), Locale.getString("NAME_COLUMN_HEADER"), String.class, 1));
        columns.add(new Column(1, Locale.getString("EQUATION"), Locale.getString("FULL_EQUATION_COLUMN_HEADER"), String.class, 1));
        this.storedEquations = PreferencesManager.loadStoredEquations();
        this.model = new Model(columns, this.storedEquations);
        this.setModel(this.model);
        this.showColumns(this.model);
    }

    public void add() {
        Thread thread2 = new Thread(new Runnable(){

            public void run() {
                StoredEquation storedEquation = ExpressionEditorDialog.showAddDialog(EquationTable.this.storedEquations, Locale.getString("ADD_EQUATION"));
                if (storedEquation != null) {
                    EquationTable.this.storedEquations.add(storedEquation);
                    EquationTable.this.setModel(EquationTable.this.model);
                    EquationTable.this.model.fireTableDataChanged();
                    EquationTable.this.repaint();
                }
            }
        });
        thread2.start();
    }

    public void edit(int row) {
        if (row >= 0 && row < this.storedEquations.size()) {
            final StoredEquation storedEquation = (StoredEquation)this.storedEquations.get(row);
            Thread thread2 = new Thread(new Runnable(){

                public void run() {
                    ExpressionEditorDialog.showEditDialog(EquationTable.this.storedEquations, Locale.getString("EDIT_EQUATION"), storedEquation);
                    EquationTable.this.model.fireTableDataChanged();
                    EquationTable.this.repaint();
                }
            });
            thread2.start();
        }
    }

    public void delete(int[] rows) {
        Arrays.sort(rows);
        for (int i = rows.length - 1; i >= 0; --i) {
            int row = rows[i];
            if (row < 0 || row >= this.storedEquations.size()) continue;
            this.storedEquations.remove(row);
        }
        this.model.fireTableDataChanged();
        this.repaint();
    }

    public void save() {
        PreferencesManager.saveStoredEquations(this.storedEquations);
        EquationComboBox.updateEquations();
    }

    private class Model
    extends AbstractTableModel {
        private List storedEquations;
        static final /* synthetic */ boolean $assertionsDisabled;

        public Model(List columns, List storedEquations) {
            super(columns);
            this.storedEquations = storedEquations;
        }

        public int getRowCount() {
            return this.storedEquations.size();
        }

        public Object getValueAt(int row, int column) {
            if (!$assertionsDisabled && row >= this.storedEquations.size()) {
                throw new AssertionError();
            }
            StoredEquation storedEquation = (StoredEquation)this.storedEquations.get(row);
            if (column == 0) {
                return storedEquation.name;
            }
            return storedEquation.equation;
        }

        static {
            $assertionsDisabled = !(class$org$mov$prefs$EquationTable == null ? (class$org$mov$prefs$EquationTable = EquationTable.class$("org.mov.prefs.EquationTable")) : class$org$mov$prefs$EquationTable).desiredAssertionStatus();
        }
    }
}

