/*
 * Decompiled with CFR 0.152.
 */
package org.mov.prefs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.mov.prefs.PreferencesManager;
import org.mov.prefs.PreferencesPage;
import org.mov.util.Locale;
import org.mov.util.LocaleConstants;

public class LanguagePage
extends JPanel
implements PreferencesPage {
    private static final int localeCount = LocaleConstants.localeCount;
    private static final java.util.Locale[] locales = LocaleConstants.locales;
    private final ButtonGroup group = new ButtonGroup();
    private final JRadioButton[] radioButtons = new JRadioButton[localeCount];
    private JDesktopPane desktop = null;
    private String languageCode = null;

    public LanguagePage(JDesktopPane desktop) {
        this.desktop = desktop;
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.createLanguagePanel());
    }

    private JPanel createLanguagePanel() {
        JPanel languagePanel = new JPanel();
        languagePanel.setLayout(new BorderLayout());
        JPanel borderPanel = new JPanel();
        borderPanel.setLayout(new BoxLayout(borderPanel, 3));
        this.languageCode = PreferencesManager.loadLanguageCode();
        if (this.languageCode == null) {
            this.languageCode = Locale.getLocale().getISO3Language();
        }
        for (int i = 0; i < localeCount; ++i) {
            this.radioButtons[i] = new JRadioButton(locales[i].getDisplayLanguage(Locale.getLocale()));
            this.radioButtons[i].setActionCommand(new Integer(i).toString());
            if (this.languageCode.equals(locales[i].getISO3Language())) {
                this.radioButtons[i].setSelected(true);
            }
            this.group.add(this.radioButtons[i]);
            borderPanel.add(this.radioButtons[i]);
            this.radioButtons[i].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String command = LanguagePage.this.group.getSelection().getActionCommand();
                    int i = Integer.parseInt(command);
                    LanguagePage.this.languageCode = locales[i].getISO3Language();
                }
            });
        }
        languagePanel.add((Component)borderPanel, "North");
        return languagePanel;
    }

    public String getTitle() {
        return Locale.getString("LANGUAGE_PAGE_TITLE");
    }

    public void save() {
        PreferencesManager.saveLanguageCode(this.languageCode);
    }

    public JComponent getComponent() {
        return this;
    }
}

