/*
 * Decompiled with CFR 0.152.
 */
package org.mov.prefs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.table.TableColumn;
import javax.swing.text.Caret;
import org.mov.macro.StoredMacro;
import org.mov.prefs.PreferencesManager;
import org.mov.prefs.PreferencesPage;
import org.mov.ui.AbstractTableModel;
import org.mov.ui.MacroEditor;
import org.mov.ui.MainMenu;
import org.mov.util.Locale;

public class MacrosPage
extends JPanel
implements PreferencesPage {
    private JDesktopPane desktop;
    private JTextField directory_text = null;
    private JTable macros_table = null;
    private AbstractTableModel table_model = null;
    private int startup_items = 0;
    private static final int FILENAME_COLUMN = 0;
    private static final int NAME_COLUMN = 1;
    private static final int STARTUP_COLUMN = 2;
    private static final int INMENU_COLUMN = 3;
    final String[] names = new String[]{Locale.getString("FILENAME_COLUMN_HEADER"), Locale.getString("MACRO_NAME_COLUMN_HEADER"), Locale.getString("STARTUP_COLUMN_HEADER"), Locale.getString("INMENU_COLUMN_HEADER")};
    private List stored_macros;
    private int selected_row = -1;
    private int edited_row = -1;
    private StoredMacro edited_macro = null;
    private MacroEditor editor = null;
    private JButton add_button = null;
    private JButton edit_button = null;
    private JButton delete_button = null;
    private JButton up_button = null;
    private JButton down_button = null;

    public String getTitle() {
        return Locale.getString("MACROS_PAGE_TITLE");
    }

    public void save() {
        PreferencesManager.saveDirectoryLocation("macros", this.directory_text.getText());
        PreferencesManager.saveStoredMacros(this.stored_macros);
        MainMenu.getInstance().buildMacroMenu();
    }

    public JComponent getComponent() {
        return this;
    }

    public MacrosPage(JDesktopPane desktop_pane) {
        this.desktop = desktop_pane;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(300, 200);
        this.add((Component)this.getDir_panel(), "North");
        this.add((Component)this.getTable_panel(), "Center");
        this.add((Component)this.getButton_panel(), "South");
    }

    private JPanel getDir_panel() {
        Object browse_button = null;
        JPanel dir_panel = new JPanel();
        dir_panel.setLayout(new BorderLayout());
        JLabel label = new JLabel();
        label.setText(Locale.getString("MACROS_DIRECTORY"));
        dir_panel.add((Component)label, "West");
        dir_panel.add((Component)this.getDirectory_text(), "Center");
        dir_panel.add((Component)this.getBrowse_button(), "East");
        return dir_panel;
    }

    private JTextField getDirectory_text() {
        if (this.directory_text == null) {
            this.directory_text = new JTextField();
            this.directory_text.setText(PreferencesManager.loadDirectoryLocation("macros"));
        }
        return this.directory_text;
    }

    private JButton getBrowse_button() {
        JButton browse_button = new JButton();
        browse_button.setText(Locale.getString("BROWSE"));
        browse_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String lastDirectory = PreferencesManager.loadDirectoryLocation("macros");
                JFileChooser chooser = lastDirectory != null ? new JFileChooser(lastDirectory) : new JFileChooser();
                chooser.setMultiSelectionEnabled(false);
                chooser.setFileSelectionMode(1);
                int action = chooser.showOpenDialog(MacrosPage.this.desktop);
                if (action == 0) {
                    File file = chooser.getSelectedFile();
                    String directory = file.getPath();
                    MacrosPage.this.directory_text.setText(directory);
                    PreferencesManager.saveDirectoryLocation("macros", directory);
                    MacrosPage.this.stored_macros = PreferencesManager.loadStoredMacros();
                    MacrosPage.this.table_model.fireTableDataChanged();
                }
            }
        });
        return browse_button;
    }

    private JPanel getTable_panel() {
        JPanel table_panel = new JPanel();
        table_panel.setLayout(new BorderLayout());
        table_panel.add((Component)this.getJScrollPane(), "Center");
        return table_panel;
    }

    private JScrollPane getJScrollPane() {
        JScrollPane jScrollPane = new JScrollPane(this.getMacros_table());
        return jScrollPane;
    }

    private JTable getMacros_table() {
        if (this.macros_table == null) {
            this.stored_macros = PreferencesManager.loadStoredMacros();
            this.table_model = new AbstractTableModel(){

                public int getColumnCount() {
                    return MacrosPage.this.names.length;
                }

                public int getRowCount() {
                    return MacrosPage.this.stored_macros.size();
                }

                public boolean isCellEditable(int row, int col) {
                    return col != 0;
                }

                public String getColumnName(int column) {
                    return MacrosPage.this.names[column];
                }

                public Class getColumnClass(int c) {
                    return this.getValueAt(0, c).getClass();
                }

                public void setValueAt(Object value, int row, int col) {
                    StoredMacro m = (StoredMacro)MacrosPage.this.stored_macros.get(row);
                    MacrosPage.this.selected_row = row;
                    switch (col) {
                        case 1: {
                            m.setName(value.toString());
                            break;
                        }
                        case 0: {
                            m.setFilename(value.toString());
                            break;
                        }
                        case 2: {
                            String s = value.toString();
                            int old_seq = m.getStart_sequence();
                            if (s.equals(Locale.getString("NO_START"))) {
                                for (int i = 0; i < MacrosPage.this.stored_macros.size(); ++i) {
                                    StoredMacro t;
                                    int other_old_seq;
                                    if (i == row || (other_old_seq = (t = (StoredMacro)MacrosPage.this.stored_macros.get(i)).getStart_sequence()) <= 1 || other_old_seq <= old_seq) continue;
                                    t.setStart_sequence(other_old_seq - 1);
                                }
                                if (m.isOn_startup()) {
                                    MacrosPage.this.startup_items--;
                                }
                                MacrosPage.this.setComboEditor();
                                m.setOn_startup(false);
                                m.setStart_sequence(0);
                            } else {
                                Integer i_value = (Integer)value;
                                int new_seq = i_value;
                                if (!m.isOn_startup()) {
                                    MacrosPage.this.startup_items++;
                                }
                                for (int i = 0; i < MacrosPage.this.stored_macros.size(); ++i) {
                                    if (i == row) continue;
                                    StoredMacro t = (StoredMacro)MacrosPage.this.stored_macros.get(i);
                                    int other_old_seq = t.getStart_sequence();
                                    if (t.isOn_startup() && other_old_seq >= new_seq && (other_old_seq < old_seq || !m.isOn_startup())) {
                                        t.setStart_sequence(other_old_seq + 1);
                                        continue;
                                    }
                                    if (!t.isOn_startup() || other_old_seq <= 1 || other_old_seq <= old_seq || other_old_seq > new_seq) continue;
                                    t.setStart_sequence(other_old_seq - 1);
                                }
                                MacrosPage.this.setComboEditor();
                                m.setOn_startup(true);
                                m.setStart_sequence(new_seq);
                            }
                            this.fireTableDataChanged();
                            break;
                        }
                        case 3: {
                            Boolean b = (Boolean)value;
                            m.setIn_menu(b);
                            break;
                        }
                        default: {
                            System.err.println("Macros table: invalid column selected");
                        }
                    }
                    MacrosPage.this.stored_macros.set(MacrosPage.this.selected_row, m);
                }

                public Object getValueAt(int row, int col) {
                    StoredMacro m = (StoredMacro)MacrosPage.this.stored_macros.get(row);
                    switch (col) {
                        case 1: {
                            return m.getName();
                        }
                        case 0: {
                            return m.getFilename();
                        }
                        case 2: {
                            if (m.isOn_startup()) {
                                return new Integer(m.getStart_sequence());
                            }
                            return Locale.getString("NO_START");
                        }
                        case 3: {
                            return new Boolean(m.isIn_menu());
                        }
                    }
                    System.err.println("Macros table: invalid column selected");
                    return null;
                }
            };
            this.macros_table = new JTable(this.table_model);
            JTextField t = new JTextField();
            t.setBackground(Color.pink);
            Caret caret = t.getCaret();
            caret.setVisible(true);
            t.setCaret(caret);
            DefaultCellEditor ce = new DefaultCellEditor(t);
            this.macros_table.setDefaultEditor(String.class, ce);
            TableColumn mc = this.macros_table.getColumn(Locale.getString("INMENU_COLUMN_HEADER"));
            int width = (int)new JCheckBox().getPreferredSize().getWidth();
            mc.setWidth(width);
            mc.setPreferredWidth(width);
            for (int i = 0; i < this.stored_macros.size(); ++i) {
                if (!((StoredMacro)this.stored_macros.get(i)).isOn_startup()) continue;
                ++this.startup_items;
            }
            this.setComboEditor();
            this.macros_table.addMouseListener(new MouseListener(){

                public void mouseClicked(MouseEvent e) {
                    MacrosPage.this.selected_row = MacrosPage.this.macros_table.getSelectedRow();
                    MacrosPage.this.edit_button.setEnabled(true);
                    MacrosPage.this.delete_button.setEnabled(true);
                    int rows = MacrosPage.this.stored_macros.size();
                    if (MacrosPage.this.selected_row < rows - 1) {
                        MacrosPage.this.down_button.setEnabled(true);
                    } else {
                        MacrosPage.this.down_button.setEnabled(false);
                    }
                    if (MacrosPage.this.selected_row > 0) {
                        MacrosPage.this.up_button.setEnabled(true);
                    } else {
                        MacrosPage.this.up_button.setEnabled(false);
                    }
                    if (e.getClickCount() > 1) {
                        MacrosPage.this.editMacro();
                    }
                }

                public void mousePressed(MouseEvent e) {
                }

                public void mouseReleased(MouseEvent e) {
                }

                public void mouseEntered(MouseEvent e) {
                }

                public void mouseExited(MouseEvent e) {
                }
            });
        }
        return this.macros_table;
    }

    private void setComboEditor() {
        JComboBox<Object> combo = new JComboBox<Object>();
        combo.addItem(Locale.getString("NO_START"));
        int add_new = 0;
        if (this.startup_items != this.stored_macros.size()) {
            add_new = 1;
        }
        for (int i = 1; i <= this.startup_items + add_new; ++i) {
            combo.addItem(new Integer(i));
        }
        TableColumn col = this.macros_table.getColumn(Locale.getString("STARTUP_COLUMN_HEADER"));
        col.setCellEditor(new DefaultCellEditor(combo));
    }

    private JPanel getButton_panel() {
        JPanel button_panel = new JPanel();
        button_panel.add((Component)this.getAdd_button(), null);
        button_panel.add((Component)this.getEdit_button(), null);
        button_panel.add((Component)this.getDelete_button(), null);
        button_panel.add((Component)this.getUp_button(), null);
        button_panel.add((Component)this.getDown_button(), null);
        return button_panel;
    }

    private JButton getUp_button() {
        this.up_button = new JButton();
        this.up_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int row = MacrosPage.this.macros_table.getSelectedRow();
                if (row > 0) {
                    StoredMacro prev = (StoredMacro)MacrosPage.this.stored_macros.get(row - 1);
                    MacrosPage.this.stored_macros.set(row - 1, MacrosPage.this.stored_macros.get(row));
                    MacrosPage.this.stored_macros.set(row, prev);
                    MacrosPage.this.table_model.fireTableDataChanged();
                    MacrosPage.this.macros_table.changeSelection(row - 1, MacrosPage.this.macros_table.getSelectedColumn(), false, false);
                }
            }
        });
        this.up_button.setText(Locale.getString("UP"));
        this.up_button.setEnabled(false);
        return this.up_button;
    }

    private JButton getDown_button() {
        this.down_button = new JButton();
        this.down_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int max;
                int row = MacrosPage.this.macros_table.getSelectedRow();
                if (row < (max = MacrosPage.this.stored_macros.size())) {
                    StoredMacro next = (StoredMacro)MacrosPage.this.stored_macros.get(row + 1);
                    MacrosPage.this.stored_macros.set(row + 1, MacrosPage.this.stored_macros.get(row));
                    MacrosPage.this.stored_macros.set(row, next);
                    MacrosPage.this.table_model.fireTableDataChanged();
                    MacrosPage.this.macros_table.changeSelection(row + 1, MacrosPage.this.macros_table.getSelectedColumn(), false, false);
                }
            }
        });
        this.down_button.setText(Locale.getString("DOWN"));
        this.down_button.setEnabled(false);
        return this.down_button;
    }

    private JButton getEdit_button() {
        if (this.edit_button == null) {
            this.edit_button = new JButton();
            this.edit_button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MacrosPage.this.editMacro();
                }
            });
            this.edit_button.setText(Locale.getString("EDIT"));
            this.edit_button.setEnabled(false);
        }
        return this.edit_button;
    }

    private JButton getAdd_button() {
        if (this.add_button == null) {
            this.add_button = new JButton();
            this.add_button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MacrosPage.this.selected_row = -1;
                    if (MacrosPage.this.editor != null) {
                        return;
                    }
                    MacrosPage.this.editMacro(new StoredMacro());
                }
            });
            this.add_button.setText(Locale.getString("ADD"));
        }
        return this.add_button;
    }

    private JButton getDelete_button() {
        if (this.delete_button == null) {
            this.delete_button = new JButton();
            this.delete_button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (MacrosPage.this.selected_row == -1) {
                        return;
                    }
                    StoredMacro macro = (StoredMacro)MacrosPage.this.stored_macros.get(MacrosPage.this.selected_row);
                    String filepath = PreferencesManager.loadDirectoryLocation("macros") + File.separator + macro.getFilename();
                    int response = JOptionPane.showInternalConfirmDialog(MacrosPage.this.delete_button, Locale.getString("SURE_DELETE_MACRO", macro.getName(), filepath), Locale.getString("DELETE_MACRO_TITLE"), 0);
                    if (response == 0) {
                        if (macro.delete()) {
                            MacrosPage.this.stored_macros.remove(MacrosPage.this.selected_row);
                            PreferencesManager.saveStoredMacros(MacrosPage.this.stored_macros);
                            MacrosPage.this.selected_row = -1;
                            MacrosPage.this.table_model.fireTableDataChanged();
                        } else {
                            JOptionPane.showInternalMessageDialog(MacrosPage.this.delete_button, Locale.getString("UNABLE_TO_DELETE_NAME_ERROR", filepath), Locale.getString("WARNINGTITLE"), 0);
                        }
                    }
                }
            });
            this.delete_button.setText(Locale.getString("DELETE"));
        }
        this.delete_button.setEnabled(false);
        return this.delete_button;
    }

    public void editMacro() {
        this.edited_row = this.selected_row = this.macros_table.getSelectedRow();
        this.editMacro((StoredMacro)this.stored_macros.get(this.edited_row));
    }

    public void editMacro(StoredMacro macro) {
        this.edited_macro = macro;
        if (this.editor != null) {
            return;
        }
        this.editor = new MacroEditor(this.edited_macro);
        this.add_button.setEnabled(false);
        this.edit_button.setEnabled(false);
        this.editor.addInternalFrameListener(new InternalFrameListener(){

            public void internalFrameClosed(InternalFrameEvent arg0) {
                MacrosPage.this.add_button.setEnabled(true);
                MacrosPage.this.edit_button.setEnabled(true);
                MacrosPage.this.delete_button.setEnabled(true);
                MacrosPage.this.up_button.setEnabled(true);
                if (MacrosPage.this.editor.isOk_clicked()) {
                    if (MacrosPage.this.edited_row == -1) {
                        System.out.println("clicked ok");
                        MacrosPage.this.stored_macros.add(MacrosPage.this.edited_macro);
                        MacrosPage.this.edited_row = MacrosPage.this.stored_macros.size() - 1;
                        MacrosPage.this.selected_row = MacrosPage.this.edited_row;
                    } else {
                        MacrosPage.this.stored_macros.set(MacrosPage.this.edited_row, MacrosPage.this.edited_macro);
                    }
                    PreferencesManager.saveStoredMacros(MacrosPage.this.stored_macros);
                }
                MacrosPage.this.table_model.fireTableDataChanged();
                MacrosPage.this.macros_table.changeSelection(MacrosPage.this.edited_row, 0, false, false);
                MacrosPage.this.editor = null;
            }

            public void internalFrameActivated(InternalFrameEvent arg0) {
            }

            public void internalFrameClosing(InternalFrameEvent e) {
            }

            public void internalFrameDeactivated(InternalFrameEvent e) {
            }

            public void internalFrameDeiconified(InternalFrameEvent arg0) {
            }

            public void internalFrameIconified(InternalFrameEvent arg0) {
            }

            public void internalFrameOpened(InternalFrameEvent arg0) {
            }
        });
    }
}

