/*
 * Decompiled with CFR 0.152.
 */
package org.mov.prefs;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.mov.macro.StoredMacro;
import org.mov.main.Main;
import org.mov.portfolio.AbstractAccount;
import org.mov.portfolio.Account;
import org.mov.portfolio.CashAccount;
import org.mov.portfolio.Portfolio;
import org.mov.portfolio.ShareAccount;
import org.mov.portfolio.Transaction;
import org.mov.prefs.StoredEquation;
import org.mov.quote.Symbol;
import org.mov.quote.SymbolFormatException;
import org.mov.table.WatchScreen;
import org.mov.util.Money;
import org.mov.util.TradingDate;
import org.mov.util.TradingDateFormatException;

public class PreferencesManager {
    private static final String base = "org.mov";
    private static Preferences userRoot;
    private static String DEFAULT_INTERNAL_FILE_NAME;
    public static int SAMPLES;
    public static int FILES;
    public static int DATABASE;
    public static int INTERNAL;
    static final /* synthetic */ boolean $assertionsDisabled;

    private PreferencesManager() {
    }

    public static void flush() {
        try {
            userRoot.flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    public static Preferences getUserNode(String node) {
        if (node.charAt(0) == '/') {
            node = node.substring(1);
        }
        return userRoot.node(node);
    }

    public static boolean requireGPLAcceptance() {
        Preferences node = PreferencesManager.getUserNode("/license");
        String acceptedVersion = node.get("accepted_version", "not_accepted");
        return !acceptedVersion.equals(Main.SHORT_VERSION);
    }

    public static void setGPLAcceptance() {
        Preferences node = PreferencesManager.getUserNode("/license");
        node.put("accepted_version", Main.SHORT_VERSION);
    }

    public static String loadDirectoryLocation(String dirtype) {
        Preferences prefs = PreferencesManager.getUserNode("/" + dirtype);
        String directory = prefs.get("directory", "");
        if (directory.length() != 0) {
            return directory;
        }
        return null;
    }

    public static void saveDirectoryLocation(String dirtype, String directory) {
        Preferences prefs = PreferencesManager.getUserNode("/" + dirtype);
        prefs.put("directory", directory);
    }

    public static synchronized List loadStoredEquations() {
        ArrayList<StoredEquation> storedEquations = new ArrayList<StoredEquation>();
        Preferences prefs = PreferencesManager.getUserNode("/equations");
        try {
            String[] keys = prefs.keys();
            for (int i = 0; i < keys.length; ++i) {
                storedEquations.add(new StoredEquation(keys[i], prefs.get(keys[i], "")));
            }
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        return storedEquations;
    }

    public static synchronized void saveStoredEquations(List storedEquations) {
        try {
            Preferences prefs = PreferencesManager.getUserNode("/equations");
            prefs.removeNode();
            prefs = PreferencesManager.getUserNode("/equations");
            Iterator iterator = storedEquations.iterator();
            while (iterator.hasNext()) {
                StoredEquation storedEquation = (StoredEquation)iterator.next();
                prefs.put(storedEquation.name, storedEquation.equation);
            }
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    public static synchronized List loadStoredMacros() {
        ArrayList<StoredMacro> stored_macros = new ArrayList<StoredMacro>();
        Preferences prefs = PreferencesManager.getUserNode("/macros/info");
        String dirname = PreferencesManager.loadDirectoryLocation("macros");
        if (dirname == null) {
            return stored_macros;
        }
        File directory = new File(dirname);
        if (!directory.isDirectory()) {
            return null;
        }
        String[] list = directory.list(new FilenameFilter(){

            public boolean accept(File dir, String filename) {
                return dir.getAbsolutePath().equals(PreferencesManager.loadDirectoryLocation("macros")) && filename.indexOf(".py") == filename.length() - 3;
            }
        });
        for (int i = 0; i < list.length; ++i) {
            String name = list[i].substring(0, list[i].length() - 3);
            Preferences macro_node = PreferencesManager.getUserNode("/macros/info/" + list[i]);
            stored_macros.add(new StoredMacro(macro_node.get("name", name), list[i], macro_node.getBoolean("on_startup", false), macro_node.getInt("start_sequence", 0), macro_node.getBoolean("in_menu", false)));
        }
        return stored_macros;
    }

    public static synchronized void saveStoredMacros(List stored_macros) {
        try {
            Preferences prefs = PreferencesManager.getUserNode("/macros_info");
            prefs.removeNode();
            prefs = PreferencesManager.getUserNode("/macros_info");
            Iterator iterator = stored_macros.iterator();
            while (iterator.hasNext()) {
                StoredMacro stored_macro = (StoredMacro)iterator.next();
                Preferences macro_node = PreferencesManager.getUserNode("/macros/info/" + stored_macro.getFilename());
                macro_node.put("name", stored_macro.getName());
                macro_node.putBoolean("on_startup", stored_macro.isOn_startup());
                macro_node.putInt("start_sequence", stored_macro.getStart_sequence());
                macro_node.putBoolean("in_menu", stored_macro.isIn_menu());
            }
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    public static void saveUserNotes(String symbol, String text) {
        String xpath = "/userNotes/" + symbol;
        Preferences prefs = PreferencesManager.getUserNode("/userNotes");
        prefs = PreferencesManager.getUserNode("/userNotes");
        prefs.put(symbol, text);
    }

    public static String loadUserNotes(String symbol) {
        String text = "";
        String xpath = "/userNotes" + symbol;
        Preferences prefs = PreferencesManager.getUserNode("/userNotes");
        if (prefs != null) {
            text = prefs.get(symbol, "");
        }
        return text;
    }

    public static HashMap loadAnalyserPageSettings(String key) {
        HashMap<String, String> settings = new HashMap<String, String>();
        Preferences p = PreferencesManager.getUserNode("/analyser/" + key);
        String[] settingList = null;
        try {
            settingList = p.keys();
        }
        catch (BackingStoreException e) {
            // empty catch block
        }
        for (int i = 0; i < settingList.length; ++i) {
            String value = p.get(settingList[i], "");
            settings.put(settingList[i], value);
        }
        return settings;
    }

    public static void saveAnalyserPageSettings(String key, HashMap settings) {
        Preferences p = PreferencesManager.getUserNode("/analyser/" + key);
        Iterator iterator = settings.keySet().iterator();
        while (iterator.hasNext()) {
            String setting = (String)iterator.next();
            String value = (String)settings.get(setting);
            p.put(setting, value);
        }
    }

    public static int loadLastPreferencesPage() {
        Preferences prefs = PreferencesManager.getUserNode("/prefs");
        return prefs.getInt("page", 0);
    }

    public static void saveLastPreferencesPage(int page) {
        Preferences prefs = PreferencesManager.getUserNode("/prefs");
        prefs.putInt("page", page);
    }

    public static int loadMaximumCachedQuotes() {
        Preferences prefs = PreferencesManager.getUserNode("/cache");
        return prefs.getInt("maximumQuotes", 100000);
    }

    public static void saveMaximumCachedQuotes(int maximumCachedQuotes) {
        Preferences prefs = PreferencesManager.getUserNode("/cache");
        prefs.putInt("maximumQuotes", maximumCachedQuotes);
    }

    public static String[] getWatchScreenNames() {
        Preferences p = PreferencesManager.getUserNode("/watchscreens");
        String[] names = null;
        try {
            names = p.childrenNames();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        return names;
    }

    public static synchronized WatchScreen loadWatchScreen(String name) {
        WatchScreen watchScreen = new WatchScreen(name);
        Preferences p = PreferencesManager.getUserNode("/watchscreens/" + name);
        try {
            String[] symbols = p.node("symbols").childrenNames();
            for (int i = 0; i < symbols.length; ++i) {
                try {
                    watchScreen.addSymbol(Symbol.find(symbols[i]));
                    continue;
                }
                catch (SymbolFormatException e) {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    continue;
                }
            }
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        return watchScreen;
    }

    public static synchronized void saveWatchScreen(WatchScreen watchScreen) {
        Preferences p = PreferencesManager.getUserNode("/watchscreens/" + watchScreen.getName());
        p.put("name", watchScreen.getName());
        try {
            p.node("symbols").removeNode();
        }
        catch (BackingStoreException e) {
            // empty catch block
        }
        List symbols = watchScreen.getSymbols();
        Iterator iterator = symbols.iterator();
        while (iterator.hasNext()) {
            Symbol symbol = (Symbol)iterator.next();
            Preferences symbolPrefs = p.node("symbols").node(symbol.toString());
            symbolPrefs.put("present", "1");
        }
    }

    public static synchronized void deleteWatchScreen(String name) {
        Preferences p = PreferencesManager.getUserNode("/watchscreens/" + name);
        try {
            p.removeNode();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    public static synchronized String[] getPortfolioNames() {
        Preferences p = PreferencesManager.getUserNode("/portfolio");
        String[] portfolioNames = null;
        try {
            portfolioNames = p.childrenNames();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        return portfolioNames;
    }

    public static synchronized void deletePortfolio(String name) {
        Preferences p = PreferencesManager.getUserNode("/portfolio/" + name);
        try {
            p.removeNode();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    public static synchronized Portfolio loadPortfolio(String name) {
        Portfolio portfolio = new Portfolio(name);
        Preferences p = PreferencesManager.getUserNode("/portfolio/" + name);
        try {
            String[] accountNames = p.node("accounts").childrenNames();
            for (int i = 0; i < accountNames.length; ++i) {
                Preferences accountPrefs = p.node("accounts").node(accountNames[i]);
                String accountType = accountPrefs.get("type", "share");
                AbstractAccount account = accountType.equals("share") ? new ShareAccount(accountNames[i]) : new CashAccount(accountNames[i]);
                portfolio.addAccount(account);
            }
            ArrayList<Transaction> transactions = new ArrayList<Transaction>();
            String[] transactionNumbers = p.node("transactions").childrenNames();
            for (int i = 0; i < transactionNumbers.length; ++i) {
                Preferences transactionPrefs = p.node("transactions").node(transactionNumbers[i]);
                int type = PreferencesManager.getTransactionType(transactionPrefs.get("type", ""));
                TradingDate date = null;
                try {
                    date = new TradingDate(transactionPrefs.get("date", "01/01/2000"), 1);
                }
                catch (TradingDateFormatException e) {
                    // empty catch block
                }
                Money amount = new Money(transactionPrefs.getDouble("amount", 0.0));
                Symbol symbol = null;
                int shares = transactionPrefs.getInt("shares", 0);
                Money tradeCost = new Money(transactionPrefs.getDouble("trade_cost", 0.0));
                try {
                    symbol = Symbol.find(transactionPrefs.get("symbol", ""));
                }
                catch (SymbolFormatException e) {
                    // empty catch block
                }
                try {
                    String cashAccountName = transactionPrefs.get("cash_account", "");
                    CashAccount cashAccount = (CashAccount)portfolio.findAccountByName(cashAccountName);
                    String cashAccountName2 = transactionPrefs.get("cash_account2", "");
                    CashAccount cashAccount2 = (CashAccount)portfolio.findAccountByName(cashAccountName2);
                    String shareAccountName = transactionPrefs.get("share_account", "");
                    ShareAccount shareAccount = (ShareAccount)portfolio.findAccountByName(shareAccountName);
                    Transaction transaction = new Transaction(type, date, amount, symbol, shares, tradeCost, cashAccount, cashAccount2, shareAccount);
                    transactions.add(transaction);
                    continue;
                }
                catch (ClassCastException e) {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    continue;
                }
            }
            portfolio.addTransactions(transactions);
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        return portfolio;
    }

    private static int getTransactionType(String transactionType) {
        try {
            return Integer.parseInt(transactionType);
        }
        catch (NumberFormatException numberFormatException) {
            if (transactionType.equals("Accumulate")) {
                return 4;
            }
            if (transactionType.equals("Reduce")) {
                return 5;
            }
            if (transactionType.equals("Deposit")) {
                return 1;
            }
            if (transactionType.equals("Fee")) {
                return 3;
            }
            if (transactionType.equals("Interest")) {
                return 2;
            }
            if (transactionType.equals("Withdrawal")) {
                return 0;
            }
            if (transactionType.equals("Dividend")) {
                return 6;
            }
            if (transactionType.equals("Dividend DRP")) {
                return 7;
            }
            return 8;
        }
    }

    public static synchronized void savePortfolio(Portfolio portfolio) {
        Preferences p = PreferencesManager.getUserNode("/portfolio/" + portfolio.getName());
        p.put("name", portfolio.getName());
        try {
            p.node("accounts").removeNode();
            p.node("transactions").removeNode();
        }
        catch (BackingStoreException e) {
            // empty catch block
        }
        List accounts = portfolio.getAccounts();
        Iterator iterator = accounts.iterator();
        while (iterator.hasNext()) {
            Account account = (Account)iterator.next();
            Preferences accountPrefs = p.node("accounts").node(account.getName());
            if (account.getType() == 1) {
                accountPrefs.put("type", "share");
                continue;
            }
            accountPrefs.put("type", "cash");
        }
        List transactions = portfolio.getTransactions();
        iterator = transactions.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            ShareAccount shareAccount;
            CashAccount cashAccount2;
            Transaction transaction = (Transaction)iterator.next();
            Preferences transactionPrefs = p.node("transactions/" + Integer.toString(i++));
            transactionPrefs.put("type", Integer.toString(transaction.getType()));
            transactionPrefs.put("date", transaction.getDate().toString("dd/mm/yyyy"));
            transactionPrefs.putDouble("amount", transaction.getAmount().doubleValue());
            if (transaction.getSymbol() != null) {
                transactionPrefs.put("symbol", transaction.getSymbol().toString());
            }
            transactionPrefs.putInt("shares", transaction.getShares());
            transactionPrefs.putDouble("trade_cost", transaction.getTradeCost().doubleValue());
            CashAccount cashAccount = transaction.getCashAccount();
            if (cashAccount != null) {
                transactionPrefs.put("cash_account", cashAccount.getName());
            }
            if ((cashAccount2 = transaction.getCashAccount2()) != null) {
                transactionPrefs.put("cash_account2", cashAccount2.getName());
            }
            if ((shareAccount = transaction.getShareAccount()) == null) continue;
            transactionPrefs.put("share_account", shareAccount.getName());
        }
    }

    public static ProxyPreferences loadProxySettings() {
        Preferences prefs = PreferencesManager.getUserNode("/proxy");
        PreferencesManager preferencesManager = new PreferencesManager();
        ProxyPreferences proxyPreferences = preferencesManager.new ProxyPreferences();
        proxyPreferences.host = prefs.get("host", "proxy");
        proxyPreferences.port = prefs.get("port", "8080");
        proxyPreferences.isEnabled = prefs.getBoolean("enabled", false);
        proxyPreferences.user = prefs.get("user", "");
        proxyPreferences.password = prefs.get("password", "");
        proxyPreferences.authEnabled = prefs.getBoolean("authEnabled", false);
        return proxyPreferences;
    }

    public static void saveProxySettings(ProxyPreferences proxyPreferences) {
        Preferences prefs = PreferencesManager.getUserNode("/proxy");
        prefs.put("host", proxyPreferences.host);
        prefs.put("port", proxyPreferences.port);
        prefs.putBoolean("enabled", proxyPreferences.isEnabled);
        prefs.put("user", proxyPreferences.user);
        prefs.put("password", proxyPreferences.password);
        prefs.putBoolean("authEnabled", proxyPreferences.authEnabled);
    }

    public static String loadLanguageCode() {
        Preferences prefs = PreferencesManager.getUserNode("/language");
        return prefs.get("locale", null);
    }

    public static void saveLanguageCode(String languageCode) {
        Preferences prefs = PreferencesManager.getUserNode("/language");
        prefs.put("locale", languageCode);
    }

    public static int getQuoteSource() {
        Preferences prefs = PreferencesManager.getUserNode("/quote_source");
        String quoteSource = prefs.get("source", "samples");
        if (quoteSource.equals("samples")) {
            return SAMPLES;
        }
        if (quoteSource.equals("files")) {
            return INTERNAL;
        }
        if (quoteSource.equals("database")) {
            return DATABASE;
        }
        return INTERNAL;
    }

    public static void setQuoteSource(int quoteSource) {
        if (!$assertionsDisabled && quoteSource != DATABASE && quoteSource != SAMPLES && quoteSource != INTERNAL) {
            throw new AssertionError();
        }
        Preferences prefs = PreferencesManager.getUserNode("/quote_source");
        String source = quoteSource == SAMPLES ? "samples" : (quoteSource == DATABASE ? "database" : "internal");
        prefs.put("source", source);
    }

    public static DatabasePreferences loadDatabaseSettings() {
        Preferences prefs = PreferencesManager.getUserNode("/quote_source/database");
        PreferencesManager preferencesManager = new PreferencesManager();
        DatabasePreferences databasePreferences = preferencesManager.new DatabasePreferences();
        databasePreferences.software = prefs.get("software", "mysql");
        databasePreferences.driver = prefs.get("driver", "com.mysql.jdbc.Driver");
        databasePreferences.host = prefs.get("host", "db");
        databasePreferences.port = prefs.get("port", "3306");
        databasePreferences.database = prefs.get("dbname", "shares");
        databasePreferences.username = prefs.get("username", "");
        databasePreferences.password = prefs.get("password", "3306");
        return databasePreferences;
    }

    public static void saveDatabaseSettings(DatabasePreferences databasePreferences) {
        Preferences prefs = PreferencesManager.getUserNode("/quote_source/database");
        prefs.put("software", databasePreferences.software);
        prefs.put("driver", databasePreferences.driver);
        prefs.put("host", databasePreferences.host);
        prefs.put("port", databasePreferences.port);
        prefs.put("dbname", databasePreferences.database);
        prefs.put("username", databasePreferences.username);
        prefs.put("password", databasePreferences.password);
    }

    public static String loadInternalFileName() {
        Preferences prefs = PreferencesManager.getUserNode("/quote_source/internal");
        String defaultFileName = DEFAULT_INTERNAL_FILE_NAME;
        try {
            File defaultFile = new File(System.getProperty("user.home"), DEFAULT_INTERNAL_FILE_NAME);
            defaultFileName = defaultFile.getCanonicalPath();
        }
        catch (IOException e) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return prefs.get("file_name", defaultFileName);
    }

    public static void saveInternalFileName(String fileName) {
        Preferences prefs = PreferencesManager.getUserNode("/quote_source/internal");
        prefs.put("file_name", fileName);
    }

    public static DisplayPreferences loadDisplaySettings() {
        Preferences prefs = PreferencesManager.getUserNode("/display");
        PreferencesManager preferencesManager = new PreferencesManager();
        DisplayPreferences displayPreferences = preferencesManager.new DisplayPreferences();
        displayPreferences.x = prefs.getInt("default_x", 0);
        displayPreferences.y = prefs.getInt("default_y", 0);
        displayPreferences.width = prefs.getInt("default_width", 400);
        displayPreferences.height = prefs.getInt("default_height", 400);
        return displayPreferences;
    }

    public static void saveDisplaySettings(DisplayPreferences displayPreferences) {
        Preferences prefs = PreferencesManager.getUserNode("/display");
        prefs.putInt("default_x", displayPreferences.x);
        prefs.putInt("default_y", displayPreferences.y);
        prefs.putInt("default_width", displayPreferences.width);
        prefs.putInt("default_height", displayPreferences.height);
    }

    static {
        $assertionsDisabled = !PreferencesManager.class.desiredAssertionStatus();
        userRoot = Preferences.userRoot().node(base);
        DEFAULT_INTERNAL_FILE_NAME = "venice_quotes.bin";
        SAMPLES = 0;
        FILES = 1;
        DATABASE = 2;
        INTERNAL = 3;
    }

    public class DisplayPreferences {
        public int x;
        public int y;
        public int width;
        public int height;
    }

    public class DatabasePreferences {
        public String software;
        public String driver;
        public String host;
        public String port;
        public String database;
        public String username;
        public String password;
    }

    public class ProxyPreferences {
        public String host;
        public String port;
        public boolean isEnabled;
        public boolean authEnabled;
        public String user;
        public String password;
    }
}

