/*
 * Decompiled with CFR 0.152.
 */
package org.mov.prefs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JList;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.mov.main.Module;
import org.mov.prefs.EquationPage;
import org.mov.prefs.LanguagePage;
import org.mov.prefs.MacrosPage;
import org.mov.prefs.PreferencesManager;
import org.mov.prefs.PreferencesPage;
import org.mov.prefs.ProxyPage;
import org.mov.prefs.QuoteSourcePage;
import org.mov.prefs.TuningPage;
import org.mov.util.Locale;

public class PreferencesModule
extends JPanel
implements Module,
ActionListener {
    public static final int EQUATION_PAGE = 0;
    public static final int QUOTE_SOURCE_PAGE = 1;
    public static final int TUNING_PAGE = 2;
    public static final int PROXY_PAGE = 3;
    public static final int MACROS_PAGE = 4;
    public static final int LANGUAGE_PAGE = 5;
    private Vector pages;
    private DefaultListModel pageListModel;
    private JDesktopPane desktop;
    private PropertyChangeSupport propertySupport;
    private PreferencesPage activePage;
    private JList pageList;
    private JButton okButton;
    private JButton cancelButton;
    private JSplitPane split;

    public PreferencesModule(JDesktopPane desktop) {
        this(desktop, PreferencesManager.loadLastPreferencesPage());
    }

    public PreferencesModule(JDesktopPane desktop, int page) {
        this.desktop = desktop;
        this.propertySupport = new PropertyChangeSupport(this);
        this.pageListModel = new DefaultListModel();
        this.pages = new Vector();
        JPanel buttonPanel = new JPanel();
        this.okButton = new JButton(Locale.getString("OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(Locale.getString("CANCEL"));
        this.cancelButton.addActionListener(this);
        this.addPage(new EquationPage(desktop));
        this.addPage(new LanguagePage(desktop));
        this.addPage(new MacrosPage(desktop));
        this.addPage(new ProxyPage(desktop));
        this.addPage(new QuoteSourcePage(desktop));
        this.addPage(new TuningPage(desktop));
        this.pageList = new JList(this.pageListModel);
        this.pageList.setSelectedIndex(page);
        this.activePage = (PreferencesPage)this.pages.elementAt(page);
        this.pageList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                int index = PreferencesModule.this.pageList.getSelectedIndex();
                if (index != -1 && PreferencesModule.this.pages.elementAt(index) != PreferencesModule.this.activePage) {
                    PreferencesModule.this.activePage = (PreferencesPage)PreferencesModule.this.pages.elementAt(index);
                    PreferencesModule.this.split.setRightComponent(PreferencesModule.this.activePage.getComponent());
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.split = new JSplitPane(1, this.pageList, this.activePage.getComponent());
        this.add((Component)this.split, "Center");
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        this.add((Component)buttonPanel, "South");
    }

    private void addPage(PreferencesPage page) {
        page.getComponent().setBorder(new TitledBorder(page.getTitle()));
        this.pageListModel.addElement(page.getTitle());
        this.pages.addElement(page);
    }

    public Dimension getPreferredSize() {
        Dimension d = new Dimension();
        for (int i = 0; i < this.pages.size(); ++i) {
            JPanel activePage = (JPanel)this.pages.elementAt(i);
            if (activePage.getPreferredSize().width > d.width) {
                d.width = activePage.getPreferredSize().width;
            }
            if (activePage.getPreferredSize().height <= d.height) continue;
            d.height = activePage.getPreferredSize().height;
        }
        d.width += this.okButton.getPreferredSize().width;
        d.height += this.okButton.getPreferredSize().height;
        d.width += this.cancelButton.getPreferredSize().width;
        d.height += this.cancelButton.getPreferredSize().height;
        return d;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            Iterator iterator = this.pages.iterator();
            while (iterator.hasNext()) {
                PreferencesPage page = (PreferencesPage)iterator.next();
                page.save();
            }
            PreferencesManager.flush();
        }
        this.propertySupport.firePropertyChange("window close", 0, 1);
    }

    public void addModuleChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void removeModuleChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    public JComponent getComponent() {
        return this;
    }

    public JMenuBar getJMenuBar() {
        return null;
    }

    public ImageIcon getFrameIcon() {
        return null;
    }

    public String getTitle() {
        return Locale.getString("PREFERENCES_TITLE");
    }

    public boolean encloseInScrollPane() {
        return false;
    }

    public void save() {
        PreferencesManager.saveLastPreferencesPage(this.pageList.getSelectedIndex());
    }
}

