/*
 * Decompiled with CFR 0.152.
 */
package org.mov.prefs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.Authenticator;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.mov.prefs.PreferencesManager;
import org.mov.prefs.PreferencesPage;
import org.mov.prefs.ProxyAuthenticator;
import org.mov.ui.GridBagHelper;
import org.mov.util.Locale;

public class ProxyPage
extends JPanel
implements PreferencesPage {
    private JDesktopPane desktop = null;
    private PreferencesManager.ProxyPreferences proxyPreferences = null;
    private JCheckBox useProxyCheckBox = null;
    private JTextField hostTextField = null;
    private JTextField portTextField = null;
    private JCheckBox useAuthCheckBox = null;
    private JTextField userTextField = null;
    private JPasswordField passwordTextField = null;

    public ProxyPage(JDesktopPane desktop) {
        this.desktop = desktop;
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.createProxyPanel());
    }

    private JPanel createProxyPanel() {
        JPanel proxyPanel = new JPanel();
        proxyPanel.setLayout(new BorderLayout());
        JPanel borderPanel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        borderPanel.setLayout(gridbag);
        c.weightx = 1.0;
        c.ipadx = 5;
        c.anchor = 17;
        this.proxyPreferences = PreferencesManager.loadProxySettings();
        this.useProxyCheckBox = GridBagHelper.addCheckBoxRow(borderPanel, Locale.getString("USE_PROXY"), this.proxyPreferences.isEnabled, gridbag, c);
        this.useProxyCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProxyPage.this.checkDisabledStatus();
            }
        });
        this.hostTextField = GridBagHelper.addTextRow(borderPanel, Locale.getString("PROXY_HOST"), this.proxyPreferences.host, gridbag, c, 20);
        this.portTextField = GridBagHelper.addTextRow(borderPanel, Locale.getString("PROXY_PORT"), this.proxyPreferences.port, gridbag, c, 5);
        this.useAuthCheckBox = GridBagHelper.addCheckBoxRow(borderPanel, Locale.getString("PROXY_AUTH"), this.proxyPreferences.authEnabled, gridbag, c);
        this.useAuthCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProxyPage.this.checkAuthDisabledStatus();
            }
        });
        this.userTextField = GridBagHelper.addTextRow(borderPanel, Locale.getString("PROXY_USER"), this.proxyPreferences.user, gridbag, c, 10);
        this.passwordTextField = GridBagHelper.addPasswordRow(borderPanel, Locale.getString("PROXY_PASSWORD"), this.proxyPreferences.password, gridbag, c, 10);
        proxyPanel.add((Component)borderPanel, "North");
        this.checkDisabledStatus();
        this.checkAuthDisabledStatus();
        return proxyPanel;
    }

    public String getTitle() {
        return Locale.getString("PROXY_PAGE_TITLE");
    }

    public void save() {
        this.proxyPreferences.host = this.hostTextField.getText();
        this.proxyPreferences.port = this.portTextField.getText();
        this.proxyPreferences.isEnabled = this.useProxyCheckBox.isSelected();
        this.proxyPreferences.user = this.userTextField.getText();
        this.proxyPreferences.password = new String(this.passwordTextField.getPassword());
        this.proxyPreferences.authEnabled = this.useAuthCheckBox.isSelected();
        PreferencesManager.saveProxySettings(this.proxyPreferences);
    }

    public JComponent getComponent() {
        return this;
    }

    private void checkAuthDisabledStatus() {
        boolean useAuth = this.useAuthCheckBox.isSelected();
        this.userTextField.setEnabled(useAuth);
        this.passwordTextField.setEnabled(useAuth);
    }

    private void checkDisabledStatus() {
        boolean useProxy = this.useProxyCheckBox.isSelected();
        this.hostTextField.setEnabled(useProxy);
        this.portTextField.setEnabled(useProxy);
    }

    public static void setupNetworking() {
        PreferencesManager.ProxyPreferences proxyPreferences = PreferencesManager.loadProxySettings();
        if (proxyPreferences.isEnabled) {
            System.getProperties().put("http.proxyHost", proxyPreferences.host);
            System.getProperties().put("http.proxyPort", proxyPreferences.port);
            if (proxyPreferences.authEnabled) {
                Authenticator.setDefault(new ProxyAuthenticator(proxyPreferences.user, proxyPreferences.password));
            }
        }
    }
}

