/*
 * Decompiled with CFR 0.152.
 */
package org.mov.prefs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.mov.prefs.PreferencesManager;
import org.mov.prefs.PreferencesPage;
import org.mov.quote.QuoteSourceManager;
import org.mov.ui.GridBagHelper;
import org.mov.util.Locale;

public class QuoteSourcePage
extends JPanel
implements PreferencesPage {
    private JDesktopPane desktop;
    private JRadioButton useDatabase;
    private JComboBox databaseSoftware;
    private JComboBox databaseDriver;
    private JTextField databaseHost;
    private JRadioButton useInternal;
    private JTextField internalFileNameTextField;
    private JTextField databasePort = null;
    private JTextField databaseUsername;
    private JPasswordField databasePassword;
    private JTextField databaseName;
    private JRadioButton useInternet;
    private JComboBox internetHost;
    private JTextField internetUsername;
    private JPasswordField internetPassword;
    private JRadioButton useSamples;
    private PreferencesManager.DatabasePreferences databasePreferences = null;
    private static final int SAMPLES = 0;
    private static final int INTERNAL = 1;
    private static final int DATABASE = 2;
    private static final int MYSQL = 0;
    private static final int POSTGRESQL = 1;
    private static final int HSQL = 2;
    private static final int OTHER = 3;
    private static final String[] mysql_drivers = new String[]{"org.gjt.mm.mysql.Driver", "com.mysql.jdbc.Driver"};
    private static final String[] postgresql_drivers = new String[]{"org.postgresql.Driver"};
    private static final String[] hsql_drivers = new String[]{"org.hsqldb.jdbcDriver"};
    private static final int MYSQL_DEFAULT_PORT = 3306;
    private static final int POSTGRESQL_DEFAULT_PORT = 5432;
    private static final int HSQLDB_DEFAULT_PORT = 9001;

    public QuoteSourcePage(JDesktopPane desktop) {
        this.desktop = desktop;
        this.setLayout(new BoxLayout(this, 1));
        int quoteSource = PreferencesManager.getQuoteSource();
        JTabbedPane pane = new JTabbedPane(1);
        ButtonGroup buttonGroup = new ButtonGroup();
        pane.addTab(Locale.getString("SAMPLES"), this.createSamplesPanel(quoteSource, buttonGroup));
        pane.addTab(Locale.getString("INTERNAL"), this.createInternalPanel(quoteSource, buttonGroup));
        pane.addTab(Locale.getString("DATABASE"), this.createDatabasePanel(quoteSource, buttonGroup));
        if (quoteSource == PreferencesManager.INTERNAL) {
            pane.setSelectedIndex(1);
        } else if (quoteSource == PreferencesManager.DATABASE) {
            pane.setSelectedIndex(2);
        } else {
            pane.setSelectedIndex(0);
        }
        this.add(pane);
    }

    private JPanel createInternalPanel(int quoteSource, ButtonGroup buttonGroup) {
        String internalFileName = PreferencesManager.loadInternalFileName();
        this.useInternal = new JRadioButton(Locale.getString("USE_INTERNAL"), true);
        buttonGroup.add(this.useInternal);
        this.useInternal.setSelected(quoteSource == PreferencesManager.INTERNAL);
        TitledBorder titled = new TitledBorder(Locale.getString("INTERNAL_PREFERENCES"));
        JPanel preferencesPanel = new JPanel();
        preferencesPanel.setBorder(titled);
        preferencesPanel.setLayout(new BorderLayout());
        JPanel borderPanel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        borderPanel.setLayout(gridbag);
        c.weightx = 1.0;
        c.ipadx = 5;
        c.anchor = 17;
        this.internalFileNameTextField = GridBagHelper.addTextRow(borderPanel, Locale.getString("FILE"), internalFileName, gridbag, c, 15);
        preferencesPanel.add((Component)borderPanel, "North");
        JPanel outerPanel = new JPanel();
        outerPanel.setLayout(new BorderLayout());
        outerPanel.add((Component)this.useInternal, "North");
        outerPanel.add((Component)preferencesPanel, "Center");
        return outerPanel;
    }

    private JPanel createDatabasePanel(int quoteSource, ButtonGroup buttonGroup) {
        this.databasePreferences = PreferencesManager.loadDatabaseSettings();
        this.useDatabase = new JRadioButton(Locale.getString("USE_DATABASE"), true);
        buttonGroup.add(this.useDatabase);
        this.useDatabase.setSelected(quoteSource == PreferencesManager.DATABASE);
        TitledBorder titled = new TitledBorder(Locale.getString("DATABASE_PREFERENCES"));
        JPanel preferencesPanel = new JPanel();
        preferencesPanel.setBorder(titled);
        preferencesPanel.setLayout(new BorderLayout());
        JPanel borderPanel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        borderPanel.setLayout(gridbag);
        c.weightx = 1.0;
        c.ipadx = 5;
        c.anchor = 17;
        JLabel label = new JLabel(Locale.getString("DATABASE"));
        gridbag.setConstraints(label, c);
        borderPanel.add(label);
        this.databaseSoftware = new JComboBox();
        this.databaseSoftware.addItem(Locale.getString("MYSQL"));
        this.databaseSoftware.addItem(Locale.getString("POSTGRESQL"));
        this.databaseSoftware.addItem(Locale.getString("HSQLDB"));
        this.databaseSoftware.addItem(Locale.getString("OTHER"));
        if (this.databasePreferences.software.equals("mysql")) {
            this.databaseSoftware.setSelectedIndex(0);
        } else if (this.databasePreferences.software.equals("postgresql")) {
            this.databaseSoftware.setSelectedIndex(1);
        } else if (this.databasePreferences.software.equals("hsql")) {
            this.databaseSoftware.setSelectedIndex(2);
        } else {
            this.databaseSoftware.setSelectedIndex(3);
        }
        this.databaseSoftware.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (QuoteSourcePage.this.databasePort != null && QuoteSourcePage.this.databaseDriver != null) {
                    QuoteSourcePage.this.populateDatabaseDrivers();
                    QuoteSourcePage.this.databaseUsername.setEnabled(true);
                    QuoteSourcePage.this.databasePassword.setEnabled(true);
                    if (QuoteSourcePage.this.databaseSoftware.getSelectedIndex() == 0) {
                        QuoteSourcePage.this.databasePort.setText(Integer.toString(3306));
                    } else if (QuoteSourcePage.this.databaseSoftware.getSelectedIndex() == 1) {
                        QuoteSourcePage.this.databasePort.setText(Integer.toString(5432));
                    } else if (QuoteSourcePage.this.databaseSoftware.getSelectedIndex() == 2) {
                        QuoteSourcePage.this.databasePort.setText(Integer.toString(9001));
                        QuoteSourcePage.this.databaseUsername.setEnabled(false);
                        QuoteSourcePage.this.databasePassword.setEnabled(false);
                    }
                }
            }
        });
        c.gridwidth = 0;
        gridbag.setConstraints(this.databaseSoftware, c);
        borderPanel.add(this.databaseSoftware);
        label = new JLabel(Locale.getString("DRIVER"));
        c.gridwidth = 1;
        gridbag.setConstraints(label, c);
        borderPanel.add(label);
        this.databaseDriver = new JComboBox();
        this.databaseDriver.setEditable(true);
        this.populateDatabaseDrivers();
        c.gridwidth = 0;
        gridbag.setConstraints(this.databaseDriver, c);
        borderPanel.add(this.databaseDriver);
        this.databaseHost = GridBagHelper.addTextRow(borderPanel, Locale.getString("HOST"), this.databasePreferences.host, gridbag, c, 15);
        this.databasePort = GridBagHelper.addTextRow(borderPanel, Locale.getString("PORT"), this.databasePreferences.port, gridbag, c, 15);
        this.databaseUsername = GridBagHelper.addTextRow(borderPanel, Locale.getString("USERNAME"), this.databasePreferences.username, gridbag, c, 15);
        this.databasePassword = GridBagHelper.addPasswordRow(borderPanel, Locale.getString("PASSWORD"), this.databasePreferences.password, gridbag, c, 15);
        if (this.databaseSoftware.getSelectedIndex() == 2) {
            this.databaseUsername.setEnabled(false);
            this.databasePassword.setEnabled(false);
        }
        this.databaseName = GridBagHelper.addTextRow(borderPanel, Locale.getString("DATABASE_NAME"), this.databasePreferences.database, gridbag, c, 15);
        preferencesPanel.add((Component)borderPanel, "North");
        JPanel database = new JPanel();
        database.setLayout(new BorderLayout());
        database.add((Component)this.useDatabase, "North");
        database.add((Component)preferencesPanel, "Center");
        return database;
    }

    private void populateDatabaseDrivers() {
        String[] drivers = new String[]{};
        this.databaseDriver.removeAllItems();
        if (this.databaseSoftware.getSelectedIndex() == 0) {
            drivers = mysql_drivers;
        } else if (this.databaseSoftware.getSelectedIndex() == 1) {
            drivers = postgresql_drivers;
        } else if (this.databaseSoftware.getSelectedIndex() == 2) {
            drivers = hsql_drivers;
        }
        for (int i = 0; i < drivers.length; ++i) {
            try {
                Class.forName(drivers[i]);
                this.databaseDriver.addItem(drivers[i]);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (this.databasePreferences.driver != null) {
            try {
                Class.forName(this.databasePreferences.driver);
                this.databaseDriver.setSelectedItem(this.databasePreferences.driver);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        } else {
            this.databaseDriver.setSelectedIndex(0);
        }
        if (this.databaseDriver.getSelectedItem() == null) {
            this.databaseDriver.addItem(Locale.getString("DATABASE_NO_DRIVERS"));
            this.databaseDriver.setToolTipText(Locale.getString("DATABASE_NO_DRIVERS_DETAIL"));
            this.databaseDriver.setSelectedIndex(0);
        } else {
            this.databaseDriver.setToolTipText(null);
        }
    }

    private JPanel createSamplesPanel(int quoteSource, ButtonGroup buttonGroup) {
        this.useSamples = new JRadioButton(Locale.getString("USE_SAMPLES"), true);
        buttonGroup.add(this.useSamples);
        this.useSamples.setSelected(quoteSource == PreferencesManager.SAMPLES);
        JPanel samples = new JPanel();
        samples.setLayout(new BorderLayout());
        samples.add((Component)this.useSamples, "North");
        return samples;
    }

    public JComponent getComponent() {
        return this;
    }

    public String getTitle() {
        return Locale.getString("QUOTE_SOURCE_PAGE_TITLE");
    }

    public void save() {
        int quoteSource = this.useInternal.isSelected() ? PreferencesManager.INTERNAL : (this.useDatabase.isSelected() ? PreferencesManager.DATABASE : PreferencesManager.SAMPLES);
        PreferencesManager.setQuoteSource(quoteSource);
        PreferencesManager.saveInternalFileName(this.internalFileNameTextField.getText());
        String software = (String)this.databaseSoftware.getSelectedItem();
        this.databasePreferences.software = software.equals(Locale.getString("MYSQL")) ? "mysql" : (software.equals(Locale.getString("POSTGRESQL")) ? "postgresql" : "hsql");
        this.databasePreferences.driver = this.databaseDriver.getSelectedItem().toString();
        this.databasePreferences.host = this.databaseHost.getText();
        this.databasePreferences.port = this.databasePort.getText();
        this.databasePreferences.username = this.databaseUsername.getText();
        this.databasePreferences.password = new String(this.databasePassword.getPassword());
        this.databasePreferences.database = this.databaseName.getText();
        PreferencesManager.saveDatabaseSettings(this.databasePreferences);
        QuoteSourceManager.flush();
    }
}

