/*
 * Decompiled with CFR 0.152.
 */
package org.mov.prefs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.mov.prefs.PreferencesManager;
import org.mov.prefs.PreferencesPage;
import org.mov.quote.QuoteCache;
import org.mov.ui.GridBagHelper;
import org.mov.util.Locale;

public class TuningPage
extends JPanel
implements PreferencesPage {
    private JDesktopPane desktop;
    private JTextField maxCachedQuotesTextField;

    public TuningPage(JDesktopPane desktop) {
        this.desktop = desktop;
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.createQuotesPanel());
    }

    private JPanel createQuotesPanel() {
        JPanel quotesPanel = new JPanel();
        quotesPanel.setLayout(new BorderLayout());
        JPanel borderPanel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        borderPanel.setLayout(gridbag);
        c.weightx = 1.0;
        c.ipadx = 5;
        c.anchor = 17;
        int currentCachedQuotes = QuoteCache.isInstantiated() ? QuoteCache.getInstance().size() : 0;
        GridBagHelper.addLabelRow(borderPanel, Locale.getString("CURRENT_CACHED_QUOTES"), Integer.toString(currentCachedQuotes), gridbag, c);
        int maximumCachedQuotes = PreferencesManager.loadMaximumCachedQuotes();
        this.maxCachedQuotesTextField = GridBagHelper.addTextRow(borderPanel, Locale.getString("MAXIMUM_CACHED_QUOTES"), Integer.toString(maximumCachedQuotes), gridbag, c, 10);
        quotesPanel.add((Component)borderPanel, "North");
        return quotesPanel;
    }

    public JComponent getComponent() {
        return this;
    }

    public String getTitle() {
        return Locale.getString("TUNING_PAGE_TITLE");
    }

    public void save() {
        int maximumCachedQuotes = 0;
        try {
            maximumCachedQuotes = Integer.parseInt(this.maxCachedQuotesTextField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (maximumCachedQuotes > 0) {
            PreferencesManager.saveMaximumCachedQuotes(maximumCachedQuotes);
        }
    }
}

