/*
 * Decompiled with CFR 0.152.
 */
package org.mov.quote;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.mov.quote.MissingQuoteException;
import org.mov.quote.Quote;
import org.mov.quote.QuoteCache;
import org.mov.quote.QuoteFilter;
import org.mov.quote.QuoteRange;
import org.mov.quote.QuoteSource;
import org.mov.quote.Symbol;
import org.mov.quote.SymbolFormatException;
import org.mov.ui.DesktopManager;
import org.mov.ui.ProgressDialog;
import org.mov.ui.ProgressDialogManager;
import org.mov.util.Locale;
import org.mov.util.TradingDate;

public class DatabaseQuoteSource
implements QuoteSource {
    private Connection connection = null;
    private boolean checkedTables = false;
    private TradingDate firstDate = null;
    private TradingDate lastDate = null;
    public static final int MYSQL = 0;
    public static final int POSTGRESQL = 1;
    public static final int HSQLDB = 2;
    public static final int OTHER = 3;
    public static final int INTERNAL = 0;
    public static final int EXTERNAL = 1;
    public static final String MYSQL_SOFTWARE = "mysql";
    public static final String POSTGRESQL_SOFTWARE = "postgresql";
    public static final String HSQLDB_SOFTWARE = "hsql";
    private static final String SHARE_TABLE_NAME = "shares";
    private static final String SYMBOL_FIELD = "symbol";
    private static final String DATE_FIELD = "date";
    private static final String DAY_OPEN_FIELD = "open";
    private static final String DAY_CLOSE_FIELD = "close";
    private static final String DAY_HIGH_FIELD = "high";
    private static final String DAY_LOW_FIELD = "low";
    private static final String DAY_VOLUME_FIELD = "volume";
    private static final String DATE_INDEX_NAME = "date_index";
    private static final String SYMBOL_INDEX_NAME = "symbol_index";
    private static final String LOOKUP_TABLE_NAME = "lookup";
    private static final String NAME_FIELD = "name";
    private int mode;
    private String software;
    private String driver;
    private String host;
    private String port;
    private String database;
    private String username;
    private String password;
    private String fileName;
    private QuoteFilter filter;
    private List fileURLs;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DatabaseQuoteSource(String software, String driver, String host, String port, String database, String username, String password) {
        this.mode = 1;
        this.software = software;
        this.driver = driver;
        this.host = host;
        this.port = port;
        this.database = database;
        this.username = username;
        this.password = password;
    }

    public DatabaseQuoteSource(String fileName) {
        this.mode = 0;
        this.software = HSQLDB_SOFTWARE;
        this.driver = "org.hsqldb.jdbcDriver";
        this.fileName = fileName;
    }

    private boolean checkConnection() {
        boolean success = true;
        if (this.connection == null) {
            success = this.connect();
        }
        if (this.connection != null && !this.checkedTables) {
            this.checkedTables = this.checkDatabase() && this.checkTables();
            success = this.checkedTables;
        }
        return success;
    }

    private boolean connect() {
        try {
            Class.forName(this.driver);
            String connectionURL = null;
            if (this.mode == 0 && this.software.equals(HSQLDB_SOFTWARE)) {
                connectionURL = new String("jdbc:hsqldb:file:/" + this.fileName);
            } else {
                connectionURL = new String("jdbc:" + this.software + "://" + this.host + ":" + this.port + "/" + this.database);
                if (this.username != null) {
                    connectionURL = connectionURL + new String("?user=" + this.username + "&password=" + this.password);
                }
            }
            this.connection = DriverManager.getConnection(connectionURL);
        }
        catch (ClassNotFoundException e) {
            DesktopManager.showErrorMessage(Locale.getString("UNABLE_TO_LOAD_DATABASE_DRIVER", this.driver, this.software));
            return false;
        }
        catch (SQLException e) {
            DesktopManager.showErrorMessage(Locale.getString("ERROR_CONNECTING_TO_DATABASE", e.getMessage()));
            return false;
        }
        return true;
    }

    public String getSymbolName(Symbol symbol) {
        String name = null;
        if (this.checkConnection()) {
            try {
                Statement statement = this.connection.createStatement();
                ResultSet RS = statement.executeQuery("SELECT name FROM lookup WHERE symbol = '" + symbol + "'");
                RS.next();
                name = RS.getString(1);
                RS.close();
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return name;
    }

    public Symbol getSymbol(String partialCompanyName) {
        Symbol symbol = null;
        if (this.checkConnection()) {
            try {
                Statement statement = this.connection.createStatement();
                ResultSet RS = statement.executeQuery("SELECT symbol FROM lookup WHERE LOCATE(UPPER('" + partialCompanyName + "'), " + NAME_FIELD + ") != 0");
                RS.next();
                try {
                    symbol = Symbol.find(RS.getString(1));
                }
                catch (SymbolFormatException e) {
                    // empty catch block
                }
                RS.close();
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return symbol;
    }

    public boolean symbolExists(Symbol symbol) {
        boolean symbolExists = false;
        if (this.checkConnection()) {
            try {
                Statement statement = this.connection.createStatement();
                String query = this.buildSymbolPresentQuery(symbol);
                ResultSet RS = statement.executeQuery(query);
                symbolExists = RS.next();
                RS.close();
                statement.close();
            }
            catch (SQLException e) {
                DesktopManager.showErrorMessage(Locale.getString("ERROR_TALKING_TO_DATABASE", e.getMessage()));
            }
        }
        return symbolExists;
    }

    public TradingDate getFirstDate() {
        if (this.firstDate != null) {
            return this.firstDate;
        }
        Date date = null;
        if (this.checkConnection()) {
            try {
                Statement statement = this.connection.createStatement();
                ResultSet RS = statement.executeQuery("SELECT MIN(date) FROM shares");
                RS.next();
                date = RS.getDate(1);
                RS.close();
                statement.close();
            }
            catch (SQLException e) {
                DesktopManager.showErrorMessage(Locale.getString("ERROR_TALKING_TO_DATABASE", e.getMessage()));
            }
        }
        if (date != null) {
            this.firstDate = new TradingDate(date);
            return this.firstDate;
        }
        this.showEmptyDatabaseError();
        return null;
    }

    public TradingDate getLastDate() {
        if (this.lastDate != null) {
            return this.lastDate;
        }
        Date date = null;
        if (this.checkConnection()) {
            try {
                Statement statement = this.connection.createStatement();
                ResultSet RS = statement.executeQuery("SELECT MAX(date) FROM shares");
                RS.next();
                date = RS.getDate(1);
                RS.close();
                statement.close();
            }
            catch (SQLException e) {
                DesktopManager.showErrorMessage(Locale.getString("ERROR_TALKING_TO_DATABASE", e.getMessage()));
            }
        }
        if (date != null) {
            this.lastDate = new TradingDate(date);
            return this.lastDate;
        }
        this.showEmptyDatabaseError();
        return null;
    }

    public boolean isMarketIndex(Symbol symbol) {
        if (!$assertionsDisabled && symbol == null) {
            throw new AssertionError();
        }
        return symbol.length() == 3 && symbol.charAt(0) == 'X';
    }

    public boolean loadQuoteRange(QuoteRange quoteRange) {
        String queryString = this.buildSQLString(quoteRange);
        ProgressDialog progress = ProgressDialogManager.getProgressDialog();
        progress.setNote(Locale.getString("LOADING_QUOTES"));
        progress.setIndeterminate(true);
        boolean success = this.executeSQLString(progress, queryString);
        ProgressDialogManager.closeProgressDialog(progress);
        return success;
    }

    private boolean executeSQLString(ProgressDialog progress, String SQLString) {
        if (this.checkConnection()) {
            try {
                Statement statement = this.connection.createStatement();
                Thread monitor = this.cancelOnInterrupt(statement);
                Thread thread2 = Thread.currentThread();
                ResultSet RS = statement.executeQuery(SQLString);
                monitor.interrupt();
                if (!thread2.isInterrupted()) {
                    QuoteCache quoteCache = QuoteCache.getInstance();
                    while (RS.next()) {
                        quoteCache.load(Symbol.find(RS.getString(SYMBOL_FIELD)), new TradingDate(RS.getDate(DATE_FIELD)), RS.getInt(DAY_VOLUME_FIELD), RS.getFloat(DAY_LOW_FIELD), RS.getFloat(DAY_HIGH_FIELD), RS.getFloat(DAY_OPEN_FIELD), RS.getFloat(DAY_CLOSE_FIELD));
                    }
                }
                RS.close();
                statement.close();
                return !thread2.isInterrupted();
            }
            catch (SQLException e) {
                DesktopManager.showErrorMessage(Locale.getString("ERROR_TALKING_TO_DATABASE", e.getMessage()));
            }
            catch (SymbolFormatException e2) {
                DesktopManager.showErrorMessage(Locale.getString("DATABASE_BADLY_FORMATTED_SYMBOL", e2.getMessage()));
            }
        }
        return false;
    }

    private Thread cancelOnInterrupt(final Statement statement) {
        final Thread sqlThread = Thread.currentThread();
        Thread thread2 = new Thread(new Runnable(){

            public void run() {
                block5: {
                    Thread currentThread = Thread.currentThread();
                    do {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            break block5;
                        }
                        if (currentThread.isInterrupted()) break block5;
                    } while (!sqlThread.isInterrupted());
                    try {
                        statement.cancel();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        });
        thread2.start();
        return thread2;
    }

    private String buildSQLString(QuoteRange quoteRange) {
        String queryString = "SELECT * FROM shares WHERE ";
        String filterString = new String("");
        if (quoteRange.getType() == 4) {
            List symbols = quoteRange.getAllSymbols();
            if (symbols.size() == 1) {
                Symbol symbol = (Symbol)symbols.get(0);
                filterString = filterString.concat("symbol = '" + symbol + "' ");
            } else {
                if (!$assertionsDisabled && symbols.size() <= 1) {
                    throw new AssertionError();
                }
                filterString = filterString.concat("symbol IN (");
                Iterator iterator = symbols.iterator();
                while (iterator.hasNext()) {
                    Symbol symbol = (Symbol)iterator.next();
                    filterString = filterString.concat("'" + symbol + "'");
                    if (!iterator.hasNext()) continue;
                    filterString = filterString.concat(", ");
                }
                filterString = filterString.concat(") ");
            }
        } else if (quoteRange.getType() != 2) {
            if (quoteRange.getType() == 1) {
                filterString = filterString.concat("LENGTH(symbol) = 3 AND " + this.left(SYMBOL_FIELD, 1) + " != 'X' ");
            } else {
                if (!$assertionsDisabled && quoteRange.getType() != 3) {
                    throw new AssertionError();
                }
                filterString = filterString.concat("LENGTH(symbol) = 3 AND " + this.left(SYMBOL_FIELD, 1) + " = 'X' ");
            }
        }
        if (quoteRange.getFirstDate() != null) {
            if (quoteRange.getFirstDate().equals(quoteRange.getLastDate())) {
                if (filterString.length() > 0) {
                    filterString = filterString.concat("AND ");
                }
                filterString = filterString.concat("date = '" + quoteRange.getFirstDate() + "' ");
            } else {
                if (filterString.length() > 0) {
                    filterString = filterString.concat("AND ");
                }
                filterString = filterString.concat("date >= '" + quoteRange.getFirstDate() + "' AND " + DATE_FIELD + " <= '" + quoteRange.getLastDate() + "' ");
            }
        }
        return queryString.concat(filterString);
    }

    private boolean createTables() {
        boolean success = false;
        try {
            Statement statement = this.connection.createStatement();
            statement.executeUpdate("CREATE TABLE shares (date DATE NOT NULL, symbol CHAR(12) NOT NULL, open FLOAT DEFAULT 0.0, close FLOAT DEFAULT 0.0, high FLOAT DEFAULT 0.0, low FLOAT DEFAULT 0.0, volume INT DEFAULT 0, PRIMARY KEY(date, symbol))");
            statement.executeUpdate("CREATE INDEX date_index ON shares (date)");
            statement.executeUpdate("CREATE INDEX symbol_index ON shares (symbol)");
            statement.executeUpdate("CREATE TABLE lookup (symbol CHAR(12) NOT NULL, name VARCHAR(100), PRIMARY KEY(symbol))");
            success = true;
        }
        catch (SQLException e) {
            if (this.software != HSQLDB_SOFTWARE) {
                DesktopManager.showErrorMessage(Locale.getString("ERROR_TALKING_TO_DATABASE", e.getMessage()));
            }
            success = true;
        }
        return success;
    }

    private boolean checkDatabase() {
        boolean success = true;
        if (this.software != HSQLDB_SOFTWARE) {
            try {
                DatabaseMetaData meta = this.connection.getMetaData();
                ResultSet RS = meta.getCatalogs();
                boolean foundDatabase = false;
                while (RS.next()) {
                    String traverseDatabaseName = RS.getString(1);
                    if (!traverseDatabaseName.equals(this.database)) continue;
                    foundDatabase = true;
                    break;
                }
                if (!foundDatabase) {
                    DesktopManager.showErrorMessage(Locale.getString("CANT_FIND_DATABASE", this.database));
                    return false;
                }
            }
            catch (SQLException e) {
                DesktopManager.showErrorMessage(Locale.getString("ERROR_TALKING_TO_DATABASE", e.getMessage()));
                return false;
            }
        }
        return success;
    }

    private boolean checkTables() {
        boolean success = false;
        try {
            boolean foundTable = false;
            if (this.software != HSQLDB_SOFTWARE) {
                DatabaseMetaData meta = this.connection.getMetaData();
                ResultSet RS = meta.getTables(this.database, null, "%", null);
                while (RS.next()) {
                    String traverseTables = RS.getString(3);
                    if (!traverseTables.equals(SHARE_TABLE_NAME)) continue;
                    foundTable = true;
                    break;
                }
            }
            success = !foundTable ? this.createTables() : true;
        }
        catch (SQLException e) {
            DesktopManager.showErrorMessage(Locale.getString("ERROR_TALKING_TO_DATABASE", e.getMessage()));
        }
        return success;
    }

    public int importQuotes(List quotes) {
        int quotesImported = 0;
        if (quotes.size() > 0 && this.checkConnection()) {
            List existingQuotes = this.findMatchingQuotes(quotes);
            ArrayList<Quote> newQuotes = new ArrayList<Quote>();
            Iterator iterator = quotes.iterator();
            while (iterator.hasNext()) {
                Quote quote = (Quote)iterator.next();
                if (this.containsQuote(existingQuotes, quote)) continue;
                newQuotes.add(quote);
            }
            if (newQuotes.size() > 0) {
                quotesImported = this.software == HSQLDB_SOFTWARE ? this.importQuoteMultipleStatements(newQuotes) : this.importQuoteSingleStatement(newQuotes);
            }
        }
        return quotesImported;
    }

    private boolean containsQuote(List quotes, Quote quote) {
        Iterator iterator = quotes.iterator();
        while (iterator.hasNext()) {
            Quote containedQuote = (Quote)iterator.next();
            if (!containedQuote.getSymbol().equals(quote.getSymbol()) || !containedQuote.getDate().equals(quote.getDate())) continue;
            return true;
        }
        return false;
    }

    private int importQuoteMultipleStatements(List quotes) {
        int quotesImported = 0;
        Iterator iterator = quotes.iterator();
        try {
            while (iterator.hasNext()) {
                Quote quote = (Quote)iterator.next();
                String insertQuery = new String("INSERT INTO shares VALUES ('" + quote.getDate() + "', " + "'" + quote.getSymbol() + "', " + "'" + quote.getDayOpen() + "', " + "'" + quote.getDayClose() + "', " + "'" + quote.getDayHigh() + "', " + "'" + quote.getDayLow() + "', " + "'" + quote.getDayVolume() + "')");
                Statement statement = this.connection.createStatement();
                statement.executeUpdate(insertQuery);
                ++quotesImported;
            }
        }
        catch (SQLException e) {
            DesktopManager.showErrorMessage(Locale.getString("ERROR_TALKING_TO_DATABASE", e.getMessage()));
        }
        return quotesImported;
    }

    private int importQuoteSingleStatement(List quotes) {
        int quotesImported = 0;
        StringBuffer insertString = new StringBuffer();
        boolean firstQuote = true;
        Iterator iterator = quotes.iterator();
        while (iterator.hasNext()) {
            Quote quote = (Quote)iterator.next();
            if (firstQuote) {
                insertString.append("INSERT INTO shares VALUES (");
                firstQuote = false;
            } else {
                insertString.append(", (");
            }
            insertString.append("'" + quote.getDate() + "', " + "'" + quote.getSymbol() + "', " + "'" + quote.getDayOpen() + "', " + "'" + quote.getDayClose() + "', " + "'" + quote.getDayHigh() + "', " + "'" + quote.getDayLow() + "', " + "'" + quote.getDayVolume() + "')");
        }
        try {
            Statement statement = this.connection.createStatement();
            statement.executeUpdate(insertString.toString());
            quotesImported = quotes.size();
        }
        catch (SQLException e) {
            DesktopManager.showErrorMessage(Locale.getString("ERROR_TALKING_TO_DATABASE", e.getMessage()));
        }
        return quotesImported;
    }

    public boolean containsDate(TradingDate date) {
        boolean containsDate = false;
        if (this.checkConnection()) {
            try {
                Statement statement = this.connection.createStatement();
                String query = this.buildDatePresentQuery(date);
                ResultSet RS = statement.executeQuery(query);
                containsDate = RS.next();
                RS.close();
                statement.close();
            }
            catch (SQLException e) {
                DesktopManager.showErrorMessage(Locale.getString("ERROR_TALKING_TO_DATABASE", e.getMessage()));
            }
        }
        return containsDate;
    }

    public List getDates() {
        ArrayList<TradingDate> dates = new ArrayList<TradingDate>();
        if (this.checkConnection()) {
            ProgressDialog progress = ProgressDialogManager.getProgressDialog();
            progress.setIndeterminate(true);
            progress.show(Locale.getString("GETTING_DATES"));
            progress.setNote(Locale.getString("GETTING_DATES"));
            try {
                Statement statement = this.connection.createStatement();
                ResultSet RS = statement.executeQuery("SELECT DISTINCT(date) FROM shares");
                while (RS.next()) {
                    dates.add(new TradingDate(RS.getDate(1)));
                    progress.increment();
                }
            }
            catch (SQLException e) {
                DesktopManager.showErrorMessage(Locale.getString("ERROR_TALKING_TO_DATABASE", e.getMessage()));
            }
            ProgressDialogManager.closeProgressDialog(progress);
        }
        return dates;
    }

    public int getAdvanceDecline(TradingDate date) throws MissingQuoteException {
        if (!this.checkConnection()) {
            return 0;
        }
        try {
            Statement statement = this.connection.createStatement();
            String query = new String("SELECT COUNT(*) FROM shares WHERE date = '" + date + "' AND " + DAY_CLOSE_FIELD + " > " + DAY_OPEN_FIELD + " AND " + "LENGTH(" + SYMBOL_FIELD + ") = 3 AND " + this.left(SYMBOL_FIELD, 1) + " != 'X' ");
            ResultSet RS = statement.executeQuery(query);
            boolean isDatePresent = RS.next();
            int advanceDecline = 0;
            if (!isDatePresent) {
                RS.close();
                statement.close();
                throw MissingQuoteException.getInstance();
            }
            advanceDecline = RS.getInt(1);
            RS.close();
            statement.close();
            statement = this.connection.createStatement();
            query = new String("SELECT COUNT(*) FROM shares WHERE date = '" + date + "' AND " + DAY_CLOSE_FIELD + " < " + DAY_OPEN_FIELD + " AND " + "LENGTH(" + SYMBOL_FIELD + ") = 3 AND " + this.left(SYMBOL_FIELD, 1) + " != 'X' ");
            RS = statement.executeQuery(query);
            isDatePresent = RS.next();
            if (isDatePresent) {
                advanceDecline -= RS.getInt(1);
                RS.close();
                statement.close();
            } else {
                RS.close();
                statement.close();
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            return advanceDecline;
        }
        catch (SQLException e) {
            DesktopManager.showErrorMessage(Locale.getString("ERROR_TALKING_TO_DATABASE", e.getMessage()));
            return 0;
        }
    }

    public void shutdown() {
        if (this.software == HSQLDB_SOFTWARE && this.mode == 0 && this.checkConnection()) {
            try {
                Statement statement = this.connection.createStatement();
                ResultSet RS = statement.executeQuery("SHUTDOWN");
                RS.close();
                statement.close();
            }
            catch (SQLException e) {
                DesktopManager.showErrorMessage(Locale.getString("ERROR_TALKING_TO_DATABASE", e.getMessage()));
            }
        }
    }

    private String buildMatchingQuoteQuery(List quotes) {
        Quote quote;
        boolean sameSymbol = true;
        boolean sameDate = true;
        Symbol symbol = null;
        TradingDate date = null;
        TradingDate startDate = null;
        TradingDate endDate = null;
        if (!$assertionsDisabled && quotes.size() <= 0) {
            throw new AssertionError();
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT symbol,date FROM shares WHERE ");
        Iterator iterator = quotes.iterator();
        while (iterator.hasNext()) {
            quote = (Quote)iterator.next();
            if (symbol == null || date == null) {
                symbol = quote.getSymbol();
                endDate = date = quote.getDate();
                startDate = date;
                continue;
            }
            if (!symbol.equals(quote.getSymbol())) {
                sameSymbol = false;
            }
            if (!date.equals(quote.getDate())) {
                sameDate = false;
            }
            if (quote.getDate().before(startDate)) {
                startDate = quote.getDate();
            }
            if (!quote.getDate().after(endDate)) continue;
            endDate = quote.getDate();
        }
        if (sameSymbol) {
            buffer.append("symbol = '" + symbol.toString() + "' AND " + DATE_FIELD + " >= '" + startDate + "' AND " + DATE_FIELD + " <= '" + endDate + "' ");
        } else if (sameDate) {
            buffer.append("date = '" + date.toString() + "'");
        } else {
            iterator = quotes.iterator();
            while (iterator.hasNext()) {
                quote = (Quote)iterator.next();
                buffer.append("(symbol = '" + quote.getSymbol() + "' AND " + DATE_FIELD + " = '" + quote.getDate() + "')");
                if (!iterator.hasNext()) continue;
                buffer.append(" OR ");
            }
        }
        return buffer.toString();
    }

    private List findMatchingQuotes(List quotes) {
        ArrayList<Quote> matchingQuotes = new ArrayList<Quote>();
        if (this.checkConnection() && quotes.size() > 0) {
            try {
                Statement statement = this.connection.createStatement();
                String query = this.buildMatchingQuoteQuery(quotes);
                ResultSet RS = statement.executeQuery(query);
                while (RS.next()) {
                    try {
                        matchingQuotes.add(new Quote(Symbol.find(RS.getString(SYMBOL_FIELD)), new TradingDate(RS.getDate(DATE_FIELD)), 0, 0.0, 0.0, 0.0, 0.0));
                    }
                    catch (SymbolFormatException e) {
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                    }
                }
                RS.close();
                statement.close();
            }
            catch (SQLException e2) {
                DesktopManager.showErrorMessage(Locale.getString("ERROR_TALKING_TO_DATABASE", e2.getMessage()));
            }
        }
        return matchingQuotes;
    }

    private void showEmptyDatabaseError() {
        DesktopManager.showErrorMessage(Locale.getString("NO_QUOTES_FOUND"));
    }

    private String left(String field, int length) {
        if (this.software.equals(MYSQL_SOFTWARE)) {
            return new String("LEFT(" + field + ", " + length + ")");
        }
        return new String("SUBSTR(" + field + ", 1, " + length + ")");
    }

    private String buildDatePresentQuery(TradingDate date) {
        if (this.software == HSQLDB_SOFTWARE) {
            return new String("SELECT TOP 1 date FROM shares WHERE date = '" + date + "' ");
        }
        return new String("SELECT date FROM shares WHERE date = '" + date + "' LIMIT 1");
    }

    private String buildSymbolPresentQuery(Symbol symbol) {
        if (this.software == HSQLDB_SOFTWARE) {
            return new String("SELECT TOP 1 symbol FROM shares WHERE symbol = '" + symbol + "' ");
        }
        return new String("SELECT symbol FROM shares WHERE symbol = '" + symbol + "' LIMIT 1");
    }

    static {
        $assertionsDisabled = !DatabaseQuoteSource.class.desiredAssertionStatus();
    }
}

