/*
 * Decompiled with CFR 0.152.
 */
package org.mov.quote;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.mov.main.Module;
import org.mov.prefs.PreferencesManager;
import org.mov.quote.FileImportExport;
import org.mov.quote.QuoteFilter;
import org.mov.quote.QuoteFilterList;
import org.mov.quote.QuoteRange;
import org.mov.quote.QuoteSource;
import org.mov.quote.QuoteSourceManager;
import org.mov.quote.ScriptQuoteBundle;
import org.mov.ui.DesktopManager;
import org.mov.ui.GridBagHelper;
import org.mov.ui.ProgressDialog;
import org.mov.ui.ProgressDialogManager;
import org.mov.util.Locale;
import org.mov.util.TradingDate;

public class ExportQuoteModule
extends JPanel
implements Module {
    private JDesktopPane desktop;
    private PropertyChangeSupport propertySupport;
    private JComboBox formatComboBox;
    private JTextField fileNamesTextField;
    private QuoteFilter filter;
    private String fileNames;

    public ExportQuoteModule(JDesktopPane desktop) {
        this.desktop = desktop;
        this.propertySupport = new PropertyChangeSupport(this);
        this.setLayout(new BorderLayout());
        this.buildGUI();
    }

    private void buildGUI() {
        Preferences p = PreferencesManager.getUserNode("/export_quotes");
        TitledBorder titledBorder = new TitledBorder(Locale.getString("EXPORT_TO_FILES"));
        JPanel titledPanel = new JPanel();
        titledPanel.setBorder(titledBorder);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        titledPanel.setLayout(gridbag);
        c.weightx = 1.0;
        c.ipadx = 5;
        c.anchor = 17;
        c.fill = 2;
        JLabel label = new JLabel(Locale.getString("FORMAT"));
        c.gridwidth = 1;
        gridbag.setConstraints(label, c);
        titledPanel.add(label);
        this.formatComboBox = new JComboBox();
        List formats = QuoteFilterList.getInstance().getList();
        String selectedFilter = p.get("fileFilter", "MetaStock");
        Iterator iterator = formats.iterator();
        while (iterator.hasNext()) {
            QuoteFilter filter = (QuoteFilter)iterator.next();
            this.formatComboBox.addItem(filter.getName());
            if (!filter.getName().equals(selectedFilter)) continue;
            this.formatComboBox.setSelectedItem(filter.getName());
        }
        c.gridwidth = 0;
        gridbag.setConstraints(this.formatComboBox, c);
        titledPanel.add(this.formatComboBox);
        String fileNames = p.get("toFileNames", "/tmp/quotes/dd-mm-yy.txt");
        this.fileNamesTextField = GridBagHelper.addTextRow(titledPanel, Locale.getString("FILE_NAMES"), fileNames, gridbag, c, 15);
        this.add((Component)titledPanel, "Center");
        JPanel buttonPanel = new JPanel();
        JButton exportButton = new JButton(Locale.getString("EXPORT"));
        exportButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExportQuoteModule.this.exportQuotes();
            }
        });
        JButton cancelButton = new JButton(Locale.getString("CANCEL"));
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExportQuoteModule.this.propertySupport.firePropertyChange("window close", 0, 1);
            }
        });
        buttonPanel.add(exportButton);
        buttonPanel.add(cancelButton);
        this.add((Component)buttonPanel, "South");
    }

    private void exportQuotes() {
        this.saveConfiguration();
        Thread thread2 = new Thread(){

            public void run() {
                ExportQuoteModule.this.parseFields();
                ExportQuoteModule.this.exportQuotesToFiles();
            }
        };
        thread2.start();
    }

    private void saveConfiguration() {
        Preferences p = PreferencesManager.getUserNode("/export_quotes");
        p.put("fileFilter", (String)this.formatComboBox.getSelectedItem());
        p.put("fileNames", this.fileNamesTextField.getText());
    }

    private void parseFields() {
        String format = (String)this.formatComboBox.getSelectedItem();
        this.filter = QuoteFilterList.getInstance().getFilter(format);
        this.fileNames = this.fileNamesTextField.getText();
    }

    private void exportQuotesToFiles() {
        this.propertySupport.firePropertyChange("window close", 0, 1);
        ProgressDialog progress = ProgressDialogManager.getProgressDialog();
        progress.setIndeterminate(true);
        progress.setMaster(true);
        progress.show(Locale.getString("EXPORTING"));
        QuoteSource source = QuoteSourceManager.getSource();
        TradingDate firstDate = source.getFirstDate();
        if (Thread.currentThread().isInterrupted()) {
            ProgressDialogManager.closeProgressDialog(progress);
            return;
        }
        TradingDate lastDate = source.getLastDate();
        List dateRange = TradingDate.dateRangeToList(firstDate, lastDate);
        progress.setIndeterminate(false);
        progress.setMaximum(dateRange.size());
        progress.setProgress(0);
        Iterator iterator = dateRange.iterator();
        while (iterator.hasNext()) {
            TradingDate date = (TradingDate)iterator.next();
            String fileName = date.toString(this.fileNames);
            QuoteRange quoteRange = new QuoteRange(2, date);
            ScriptQuoteBundle quoteBundle = new ScriptQuoteBundle(quoteRange);
            ArrayList quotes = new ArrayList();
            Iterator innerIterator = quoteBundle.iterator();
            while (innerIterator.hasNext()) {
                quotes.add(innerIterator.next());
            }
            if (Thread.currentThread().isInterrupted()) break;
            try {
                FileImportExport.exportFile(this.filter, new File(fileName), quotes);
            }
            catch (IOException e) {
                DesktopManager.showErrorMessage(Locale.getString("ERROR_WRITING_TO_FILE", fileName));
                break;
            }
            progress.increment();
        }
        ProgressDialogManager.closeProgressDialog(progress);
        JOptionPane.showInternalMessageDialog(this.desktop, Locale.getString("EXPORT_COMPLETE"), Locale.getString("EXPORT_COMPLETE_TITLE"), 1);
    }

    public void addModuleChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void removeModuleChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    public JComponent getComponent() {
        return this;
    }

    public JMenuBar getJMenuBar() {
        return null;
    }

    public ImageIcon getFrameIcon() {
        return null;
    }

    public String getTitle() {
        return Locale.getString("EXPORT_TITLE");
    }

    public boolean encloseInScrollPane() {
        return true;
    }

    public void save() {
    }
}

