/*
 * Decompiled with CFR 0.152.
 */
package org.mov.quote;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.mov.quote.Quote;
import org.mov.quote.QuoteFilter;
import org.mov.quote.QuoteFormatException;
import org.mov.util.Locale;
import org.mov.util.Report;

public class FileImportExport {
    static final /* synthetic */ boolean $assertionsDisabled;

    private FileImportExport() {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public static List importFile(Report report, QuoteFilter filter, File file) {
        ArrayList<Quote> quotes = new ArrayList<Quote>();
        String fileName = file.getName();
        try {
            FileInputStream fileStream = new FileInputStream(file);
            InputStreamReader inputStream = new InputStreamReader(fileStream);
            BufferedReader fileReader = new BufferedReader(inputStream);
            int lineNumber = 1;
            String line = fileReader.readLine();
            while (line != null) {
                try {
                    Quote quote = filter.toQuote(line);
                    quotes.add(quote);
                    FileImportExport.verify(report, fileName, lineNumber, quote);
                }
                catch (QuoteFormatException e) {
                    report.addError(fileName + ":" + Integer.toString(lineNumber) + ":" + Locale.getString("ERROR") + ": " + e.getMessage());
                }
                line = fileReader.readLine();
                ++lineNumber;
            }
            fileReader.close();
        }
        catch (IOException e) {
            report.addError(fileName + ":" + Locale.getString("ERROR") + ": " + Locale.getString("ERROR_READING_FROM_FILE", fileName));
        }
        return quotes;
    }

    public static void exportFile(QuoteFilter filter, File file, List quotes) throws IOException {
        if (quotes.size() > 0) {
            FileWriter fileWriter = new FileWriter(file);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            PrintWriter printWriter = new PrintWriter(bufferedWriter);
            Iterator iterator = quotes.iterator();
            while (iterator.hasNext()) {
                Quote quote = (Quote)iterator.next();
                printWriter.println(filter.toString(quote));
            }
            printWriter.close();
        }
    }

    private static void verify(Report report, String fileName, int lineNumber, Quote quote) {
        try {
            quote.verify();
        }
        catch (QuoteFormatException e) {
            List messages = e.getMessages();
            Iterator iterator = messages.iterator();
            while (iterator.hasNext()) {
                String message = (String)iterator.next();
                report.addWarning(fileName + ":" + Integer.toString(lineNumber) + ":" + Locale.getString("WARNING") + ": " + message);
            }
        }
    }

    static {
        $assertionsDisabled = !FileImportExport.class.desiredAssertionStatus();
    }
}

