/*
 * Decompiled with CFR 0.152.
 */
package org.mov.quote;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.mov.quote.MissingQuoteException;
import org.mov.quote.Quote;
import org.mov.quote.QuoteCache;
import org.mov.quote.QuoteFilter;
import org.mov.quote.QuoteFilterList;
import org.mov.quote.QuoteFormatException;
import org.mov.quote.QuoteRange;
import org.mov.quote.QuoteSource;
import org.mov.quote.Symbol;
import org.mov.ui.DesktopManager;
import org.mov.ui.ProgressDialog;
import org.mov.ui.ProgressDialogManager;
import org.mov.util.Locale;
import org.mov.util.TradingDate;

public class FileQuoteSource
implements QuoteSource {
    private static final int MAXIMUM_ERRORS = 5;
    private HashMap dateToURL = null;
    private List fileURLs = null;
    private TradingDate lastDate = null;
    private TradingDate firstDate = null;
    private QuoteFilter filter;
    static final /* synthetic */ boolean $assertionsDisabled;

    public FileQuoteSource(String format, List fileURLs) {
        this.filter = QuoteFilterList.getInstance().getFilter(format);
        this.fileURLs = fileURLs;
    }

    private TradingDate getContainedDate(URL fileURL) throws IOException {
        InputStreamReader isr = new InputStreamReader(fileURL.openStream());
        BufferedReader br = new BufferedReader(isr);
        String line = br.readLine();
        while (line != null) {
            try {
                Quote quote = this.filter.toQuote(line);
                return quote.getDate();
            }
            catch (QuoteFormatException e) {
                line = br.readLine();
            }
        }
        return null;
    }

    private List getContainedQuotes(URL fileURL, QuoteRange quoteRange) {
        ArrayList<Quote> quotes = new ArrayList<Quote>();
        if (!($assertionsDisabled || fileURL != null && quoteRange != null)) {
            throw new AssertionError();
        }
        try {
            InputStreamReader isr = new InputStreamReader(fileURL.openStream());
            BufferedReader br = new BufferedReader(isr);
            String line = br.readLine();
            while (line != null) {
                block8: {
                    try {
                        Quote quote = this.filter.toQuote(line);
                        if (quoteRange.containsSymbol(quote.getSymbol())) {
                            quotes.add(quote);
                            if (quoteRange.getType() == 4 && quotes.containsAll(quoteRange.getAllSymbols())) {
                                break;
                            }
                        }
                    }
                    catch (QuoteFormatException e) {
                        if ($assertionsDisabled) break block8;
                        throw new AssertionError();
                    }
                }
                line = br.readLine();
            }
            br.close();
        }
        catch (IOException e) {
            DesktopManager.showWarningMessage(Locale.getString("ERROR_READING_FROM_FILE", fileURL.getPath()));
        }
        return quotes;
    }

    private synchronized boolean checkFiles() {
        if (this.dateToURL == null) {
            this.createIndex();
            if (this.dateToURL == null) {
                DesktopManager.showErrorMessage(Locale.getString("NO_QUOTES_FOUND"));
                return false;
            }
        }
        return true;
    }

    private void createIndex() {
        Thread thread2 = Thread.currentThread();
        this.dateToURL = new HashMap();
        int errorCount = 0;
        ProgressDialog p = ProgressDialogManager.getProgressDialog();
        p.setMaster(true);
        p.setMaximum(this.fileURLs.size());
        p.setNote(Locale.getString("INDEXING_FILES"));
        p.show(Locale.getString("INDEXING_FILES"));
        Iterator iterator = this.fileURLs.iterator();
        while (iterator.hasNext()) {
            block9: {
                URL fileURL = (URL)iterator.next();
                try {
                    TradingDate date = this.getContainedDate(fileURL);
                    if (date != null) {
                        if (this.lastDate == null || date.after(this.lastDate)) {
                            this.lastDate = date;
                        }
                        if (this.firstDate == null || date.before(this.firstDate)) {
                            this.firstDate = date;
                        }
                        this.dateToURL.put(date, fileURL);
                    } else if (errorCount++ < 5) {
                        String message = Locale.getString("NO_QUOTES_FOUND_IN_FILE", fileURL.getPath());
                        DesktopManager.showWarningMessage(message);
                    }
                }
                catch (IOException e) {
                    if (errorCount++ >= 5) break block9;
                    String message = Locale.getString("ERROR_READING_FROM_FILE", fileURL.getPath());
                    DesktopManager.showWarningMessage(message);
                }
            }
            p.increment();
        }
        ProgressDialogManager.closeProgressDialog(p);
        if (this.dateToURL.isEmpty()) {
            this.dateToURL = null;
        }
    }

    public String getSymbolName(Symbol symbol) {
        return null;
    }

    public Symbol getSymbol(String partialCompanyName) {
        return null;
    }

    public boolean symbolExists(Symbol symbol) {
        if (this.checkFiles()) {
            Iterator iterator = this.dateToURL.keySet().iterator();
            while (iterator.hasNext()) {
                TradingDate date = (TradingDate)iterator.next();
                List quotes = this.getContainedQuotes(this.getURLForDate(date), new QuoteRange(symbol));
                if (quotes.size() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public TradingDate getFirstDate() {
        this.checkFiles();
        return this.firstDate;
    }

    public TradingDate getLastDate() {
        this.checkFiles();
        return this.lastDate;
    }

    public URL getURLForDate(TradingDate date) {
        if (this.checkFiles()) {
            return (URL)this.dateToURL.get(date);
        }
        return null;
    }

    public boolean containsDate(TradingDate date) {
        if (this.checkFiles()) {
            URL fileURL = this.getURLForDate(date);
            return fileURL != null;
        }
        return false;
    }

    public List getDates() {
        if (this.checkFiles()) {
            return new ArrayList(this.dateToURL.keySet());
        }
        return new ArrayList();
    }

    public boolean loadQuoteRange(QuoteRange quoteRange) {
        if (this.checkFiles()) {
            List dates;
            QuoteCache quoteCache = QuoteCache.getInstance();
            Thread thread2 = Thread.currentThread();
            ProgressDialog progress = ProgressDialogManager.getProgressDialog();
            progress.setNote(Locale.getString("LOADING_QUOTES"));
            progress.setIndeterminate(true);
            TradingDate firstDate = quoteRange.getFirstDate();
            TradingDate lastDate = quoteRange.getLastDate();
            if (firstDate == null) {
                firstDate = this.firstDate;
                lastDate = this.lastDate;
            }
            if ((dates = TradingDate.dateRangeToList(firstDate, lastDate)).size() > 1) {
                progress.setMaximum(dates.size());
                progress.setProgress(0);
                progress.setIndeterminate(false);
            } else {
                progress.setIndeterminate(true);
            }
            Iterator iterator = dates.iterator();
            while (iterator.hasNext()) {
                TradingDate date = (TradingDate)iterator.next();
                URL fileURL = this.getURLForDate(date);
                if (fileURL != null) {
                    List quotes = this.getContainedQuotes(fileURL, quoteRange);
                    Iterator quoteIterator = quotes.iterator();
                    while (quoteIterator.hasNext()) {
                        Quote quote = (Quote)quoteIterator.next();
                        quoteCache.load(quote);
                    }
                }
                if (thread2.isInterrupted()) break;
                if (dates.size() <= 1) continue;
                progress.increment();
            }
            ProgressDialogManager.closeProgressDialog(progress);
            return !thread2.isInterrupted();
        }
        return false;
    }

    public boolean isMarketIndex(Symbol symbol) {
        if (!$assertionsDisabled && symbol == null) {
            throw new AssertionError();
        }
        return symbol.length() == 3 && symbol.charAt(0) == 'X';
    }

    public int getAdvanceDecline(TradingDate date) throws MissingQuoteException {
        if (this.checkFiles()) {
            URL fileURL = this.getURLForDate(date);
            if (fileURL == null) {
                throw MissingQuoteException.getInstance();
            }
            QuoteRange quoteRange = new QuoteRange(1, date);
            List quotes = this.getContainedQuotes(fileURL, quoteRange);
            int advanceDecline = 0;
            Iterator iterator = quotes.iterator();
            while (iterator.hasNext()) {
                Quote quote = (Quote)iterator.next();
                if (quote.getDayClose() > quote.getDayOpen()) {
                    ++advanceDecline;
                    continue;
                }
                if (!(quote.getDayClose() < quote.getDayOpen())) continue;
                --advanceDecline;
            }
            return advanceDecline;
        }
        return 0;
    }

    public void shutdown() {
    }

    static {
        $assertionsDisabled = !FileQuoteSource.class.desiredAssertionStatus();
    }
}

