/*
 * Decompiled with CFR 0.152.
 */
package org.mov.quote;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.mov.main.Module;
import org.mov.prefs.PreferencesManager;
import org.mov.prefs.ProxyPage;
import org.mov.quote.DatabaseQuoteSource;
import org.mov.quote.FileImportExport;
import org.mov.quote.InternetImport;
import org.mov.quote.QuoteFilter;
import org.mov.quote.QuoteFilterList;
import org.mov.quote.QuoteSourceManager;
import org.mov.quote.Symbol;
import org.mov.quote.SymbolFormatException;
import org.mov.ui.GridBagHelper;
import org.mov.ui.ProgressDialog;
import org.mov.ui.ProgressDialogManager;
import org.mov.ui.TextViewDialog;
import org.mov.util.Locale;
import org.mov.util.Report;
import org.mov.util.TradingDate;
import org.mov.util.TradingDateFormatException;

public class ImportQuoteModule
extends JPanel
implements Module {
    private JDesktopPane desktop;
    private PropertyChangeSupport propertySupport;
    private JRadioButton fromFiles;
    private JComboBox formatComboBox;
    private JRadioButton fromInternet;
    private JComboBox sourceComboBox;
    private JTextField symbolList;
    private JTextField startDateTextField;
    private JTextField endDateTextField;
    TradingDate startDate;
    TradingDate endDate;
    List symbols;
    QuoteFilter filter;
    File[] files;
    static /* synthetic */ Class class$org$mov$quote$ImportQuoteModule;

    public ImportQuoteModule(JDesktopPane desktop) {
        this.desktop = desktop;
        this.propertySupport = new PropertyChangeSupport(this);
        this.setLayout(new BorderLayout());
        this.buildGUI();
    }

    private void buildGUI() {
        Preferences p = PreferencesManager.getUserNode("/import_quotes");
        String importFromSource = p.get("from", "internet");
        TitledBorder titledBorder = new TitledBorder(Locale.getString("IMPORT_FROM"));
        JPanel titledPanel = new JPanel();
        titledPanel.setBorder(titledBorder);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        titledPanel.setLayout(gridbag);
        c.weightx = 1.0;
        c.ipadx = 5;
        c.anchor = 17;
        c.fill = 2;
        this.fromFiles = new JRadioButton(Locale.getString("FILES"));
        this.fromFiles.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImportQuoteModule.this.checkDisabledStatus();
            }
        });
        if (importFromSource.equals("files")) {
            this.fromFiles.setSelected(true);
        }
        c.gridwidth = 1;
        gridbag.setConstraints(this.fromFiles, c);
        titledPanel.add(this.fromFiles);
        this.formatComboBox = new JComboBox();
        List formats = QuoteFilterList.getInstance().getList();
        String selectedFilter = p.get("fileFilter", "MetaStock");
        Iterator iterator = formats.iterator();
        while (iterator.hasNext()) {
            QuoteFilter filter = (QuoteFilter)iterator.next();
            this.formatComboBox.addItem(filter.getName());
            if (!filter.getName().equals(selectedFilter)) continue;
            this.formatComboBox.setSelectedItem(filter.getName());
        }
        c.gridwidth = 0;
        gridbag.setConstraints(this.formatComboBox, c);
        titledPanel.add(this.formatComboBox);
        this.fromInternet = new JRadioButton(Locale.getString("INTERNET"));
        this.fromInternet.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImportQuoteModule.this.checkDisabledStatus();
            }
        });
        if (importFromSource.equals("internet")) {
            this.fromInternet.setSelected(true);
        }
        c.gridwidth = 1;
        gridbag.setConstraints(this.fromInternet, c);
        titledPanel.add(this.fromInternet);
        this.sourceComboBox = new JComboBox();
        this.sourceComboBox.addItem(Locale.getString("YAHOO"));
        c.gridwidth = 0;
        gridbag.setConstraints(this.sourceComboBox, c);
        titledPanel.add(this.sourceComboBox);
        c.gridx = 1;
        this.symbolList = GridBagHelper.addTextRow(titledPanel, Locale.getString("SYMBOLS"), p.get("internetSymbolList", ""), gridbag, c, 11);
        c.gridx = 1;
        TradingDate today = new TradingDate();
        TradingDate previous = today.previous(30);
        this.startDateTextField = GridBagHelper.addTextRow(titledPanel, Locale.getString("START_DATE"), p.get("internetStartDate", previous.toString("dd/mm/yyyy")), gridbag, c, 11);
        c.gridx = 1;
        this.endDateTextField = GridBagHelper.addTextRow(titledPanel, Locale.getString("END_DATE"), p.get("internetEndDate", today.toString("dd/mm/yyyy")), gridbag, c, 11);
        ButtonGroup group = new ButtonGroup();
        group.add(this.fromFiles);
        group.add(this.fromInternet);
        this.add((Component)titledPanel, "Center");
        JPanel buttonPanel = new JPanel();
        JButton importButton = new JButton(Locale.getString("IMPORT"));
        importButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImportQuoteModule.this.importQuotes();
            }
        });
        JButton cancelButton = new JButton(Locale.getString("CANCEL"));
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImportQuoteModule.this.propertySupport.firePropertyChange("window close", 0, 1);
            }
        });
        buttonPanel.add(importButton);
        buttonPanel.add(cancelButton);
        this.add((Component)buttonPanel, "South");
        this.checkDisabledStatus();
    }

    private void checkDisabledStatus() {
        this.formatComboBox.setEnabled(this.fromFiles.isSelected());
        this.sourceComboBox.setEnabled(this.fromInternet.isSelected());
        this.symbolList.setEnabled(this.fromInternet.isSelected());
        this.startDateTextField.setEnabled(this.fromInternet.isSelected());
        this.endDateTextField.setEnabled(this.fromInternet.isSelected());
    }

    private void importQuotes() {
        this.saveConfiguration();
        Thread thread2 = new Thread(){
            static final /* synthetic */ boolean $assertionsDisabled;

            public void run() {
                if (ImportQuoteModule.this.fromFiles.isSelected()) {
                    ImportQuoteModule.this.importQuotesFromFiles();
                } else {
                    if (!$assertionsDisabled && !ImportQuoteModule.this.fromInternet.isSelected()) {
                        throw new AssertionError();
                    }
                    ImportQuoteModule.this.importQuotesFromInternet();
                }
            }

            static {
                $assertionsDisabled = !(class$org$mov$quote$ImportQuoteModule == null ? (class$org$mov$quote$ImportQuoteModule = ImportQuoteModule.class$("org.mov.quote.ImportQuoteModule")) : class$org$mov$quote$ImportQuoteModule).desiredAssertionStatus();
            }
        };
        thread2.start();
    }

    private void saveConfiguration() {
        Preferences p = PreferencesManager.getUserNode("/import_quotes");
        if (this.fromFiles.isSelected()) {
            p.put("from", "files");
        } else {
            p.put("from", "internet");
        }
        p.put("internetSymbolList", this.symbolList.getText());
        p.put("internetStartDate", this.startDateTextField.getText());
        p.put("internetEndDate", this.endDateTextField.getText());
        p.put("fileFilter", (String)this.formatComboBox.getSelectedItem());
    }

    private void importQuotesFromFiles() {
        if (this.parseFileFields()) {
            Report report = new Report();
            int quotesImported = 0;
            DatabaseQuoteSource database = this.getDatabaseSource();
            this.propertySupport.firePropertyChange("window close", 0, 1);
            ProgressDialog progress = ProgressDialogManager.getProgressDialog();
            progress.setIndeterminate(false);
            progress.setMaximum(this.files.length);
            progress.setProgress(0);
            progress.setMaster(true);
            progress.show(Locale.getString("IMPORTING"));
            for (int i = 0; i < this.files.length; ++i) {
                File file = this.files[i];
                progress.setNote(Locale.getString("IMPORTING_FILE", file.getName()));
                List quotes = FileImportExport.importFile(report, this.filter, file);
                if (quotes.size() > 0) {
                    int fileQuotesImported = database.importQuotes(quotes);
                    report.addMessage(file.getName() + ": " + Locale.getString("IMPORTED_QUOTES", fileQuotesImported));
                    quotesImported += fileQuotesImported;
                }
                if (Thread.currentThread().isInterrupted()) break;
                progress.increment();
            }
            ProgressDialogManager.closeProgressDialog(progress);
            this.displayReport(report, quotesImported);
        }
    }

    private boolean parseFileFields() {
        String lastDirectory = PreferencesManager.loadDirectoryLocation("importer");
        JFileChooser chooser = lastDirectory != null ? new JFileChooser(lastDirectory) : new JFileChooser();
        chooser.setMultiSelectionEnabled(true);
        int action = chooser.showOpenDialog(this.desktop);
        if (action == 0) {
            lastDirectory = chooser.getCurrentDirectory().getAbsolutePath();
            PreferencesManager.saveDirectoryLocation("importer", lastDirectory);
            this.files = chooser.getSelectedFiles();
            if (this.files.length != 0) {
                String format = (String)this.formatComboBox.getSelectedItem();
                this.filter = QuoteFilterList.getInstance().getFilter(format);
                return true;
            }
        }
        return false;
    }

    private void importQuotesFromInternet() {
        if (this.parseInternetFields()) {
            Report report = new Report();
            int quotesImported = 0;
            DatabaseQuoteSource database = this.getDatabaseSource();
            this.propertySupport.firePropertyChange("window close", 0, 1);
            ProxyPage.setupNetworking();
            ProgressDialog progress = ProgressDialogManager.getProgressDialog();
            progress.setIndeterminate(false);
            progress.setMaximum(this.symbols.size());
            progress.setProgress(0);
            progress.setMaster(true);
            progress.show(Locale.getString("IMPORTING"));
            try {
                Iterator iterator = this.symbols.iterator();
                while (iterator.hasNext()) {
                    Symbol symbol = (Symbol)iterator.next();
                    progress.setNote(Locale.getString("IMPORTING_SYMBOL", symbol.toString()));
                    List quotes = InternetImport.importSymbol(report, symbol, this.startDate, this.endDate);
                    if (quotes.size() > 0) {
                        int symbolQuotesImported = database.importQuotes(quotes);
                        report.addMessage(Locale.getString("YAHOO") + ":" + symbol + ": " + Locale.getString("IMPORTED_QUOTES", symbolQuotesImported));
                        quotesImported += symbolQuotesImported;
                    }
                    if (!Thread.currentThread().isInterrupted()) {
                        progress.increment();
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            ProgressDialogManager.closeProgressDialog(progress);
            this.displayReport(report, quotesImported);
        }
    }

    private boolean parseInternetFields() {
        try {
            this.symbols = new ArrayList(Symbol.toSortedSet(this.symbolList.getText(), false));
        }
        catch (SymbolFormatException e) {
            JOptionPane.showInternalMessageDialog(this.desktop, e.getMessage(), Locale.getString("INVALID_SYMBOL_LIST"), 0);
            return false;
        }
        if (this.symbols.size() == 0) {
            JOptionPane.showInternalMessageDialog(this.desktop, Locale.getString("MISSING_SYMBOLS"), Locale.getString("INVALID_SYMBOL_LIST"), 0);
            return false;
        }
        try {
            this.startDate = new TradingDate(this.startDateTextField.getText(), 1);
            this.endDate = new TradingDate(this.endDateTextField.getText(), 1);
        }
        catch (TradingDateFormatException e) {
            JOptionPane.showInternalMessageDialog(this.desktop, Locale.getString("ERROR_PARSING_DATE", e.getDate()), Locale.getString("INVALID_DATE"), 0);
            return false;
        }
        if (this.startDate.after(this.endDate)) {
            JOptionPane.showInternalMessageDialog(this.desktop, Locale.getString("DATE_RANGE_ERROR"), Locale.getString("INVALID_DATE"), 0);
            return false;
        }
        return true;
    }

    private void displayReport(Report report, int quotesImported) {
        String message = Locale.getString("IMPORTED_QUOTES", quotesImported);
        if (report.getErrorCount() + report.getWarningCount() > 0) {
            message = message.concat("\n" + Locale.getString("IMPORTED_WARNINGS", report.getErrorCount(), report.getWarningCount()));
        }
        Object[] options = new Object[]{Locale.getString("OK"), Locale.getString("VIEW_REPORT")};
        int option = JOptionPane.showInternalOptionDialog(this.desktop, message, Locale.getString("IMPORT_COMPLETE_TITLE"), -1, 1, null, options, options[0]);
        if (option == 1) {
            TextViewDialog.showTextDialog(report.getText(), Locale.getString("IMPORT_REPORT"));
        }
    }

    private DatabaseQuoteSource getDatabaseSource() {
        int quoteSource = PreferencesManager.getQuoteSource();
        if (quoteSource == PreferencesManager.SAMPLES) {
            PreferencesManager.setQuoteSource(PreferencesManager.INTERNAL);
            QuoteSourceManager.flush();
        }
        return (DatabaseQuoteSource)QuoteSourceManager.getSource();
    }

    public void addModuleChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void removeModuleChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    public JComponent getComponent() {
        return this;
    }

    public JMenuBar getJMenuBar() {
        return null;
    }

    public ImageIcon getFrameIcon() {
        return null;
    }

    public String getTitle() {
        return Locale.getString("IMPORT_TITLE");
    }

    public boolean encloseInScrollPane() {
        return true;
    }

    public void save() {
    }
}

