/*
 * Decompiled with CFR 0.152.
 */
package org.mov.quote;

import org.mov.quote.Quote;
import org.mov.quote.QuoteFilter;
import org.mov.quote.QuoteFormatException;
import org.mov.quote.Symbol;
import org.mov.quote.SymbolFormatException;
import org.mov.util.Locale;
import org.mov.util.TradingDate;
import org.mov.util.TradingDateFormatException;

public class InsightTraderQuoteFilter
implements QuoteFilter {
    public String getName() {
        return "Insight Trader";
    }

    public Quote toQuote(String quoteLine) throws QuoteFormatException {
        Quote quote = null;
        if (quoteLine != null) {
            String[] quoteParts = quoteLine.split(" ");
            int i = 0;
            if (quoteParts.length == 7) {
                Symbol symbol = null;
                try {
                    symbol = Symbol.find(quoteParts[i++]);
                }
                catch (SymbolFormatException e) {
                    throw new QuoteFormatException(e.getMessage());
                }
                TradingDate date = null;
                try {
                    date = new TradingDate(quoteParts[i++], 0);
                }
                catch (TradingDateFormatException e) {
                    throw new QuoteFormatException(e.getMessage());
                }
                try {
                    float day_open = Float.parseFloat(quoteParts[i++]) / 100.0f;
                    float day_high = Float.parseFloat(quoteParts[i++]) / 100.0f;
                    float day_low = Float.parseFloat(quoteParts[i++]) / 100.0f;
                    float day_close = Float.parseFloat(quoteParts[i++]) / 100.0f;
                    int day_volume = Integer.parseInt(quoteParts[i++]) * 100;
                    quote = new Quote(symbol, date, day_volume, day_low, day_high, day_open, day_close);
                }
                catch (NumberFormatException e) {
                    throw new QuoteFormatException(Locale.getString("ERROR_PARSING_NUMBER", quoteParts[i - 1]));
                }
            }
            throw new QuoteFormatException(Locale.getString("WRONG_FIELD_COUNT"));
        }
        return quote;
    }

    public String toString(Quote quote) {
        return new String(quote.getSymbol() + " " + quote.getDate().toString("mm/dd/yy") + " " + Math.round(quote.getDayOpen() * 100.0) + " " + Math.round(quote.getDayHigh() * 100.0) + " " + Math.round(quote.getDayLow() * 100.0) + " " + Math.round(quote.getDayClose() * 100.0) + " " + quote.getDayVolume() / 100);
    }
}

