/*
 * Decompiled with CFR 0.152.
 */
package org.mov.quote;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.BindException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mov.prefs.PreferencesManager;
import org.mov.quote.Quote;
import org.mov.quote.QuoteFormatException;
import org.mov.quote.Symbol;
import org.mov.quote.YahooQuoteFilter;
import org.mov.ui.DesktopManager;
import org.mov.util.Locale;
import org.mov.util.Report;
import org.mov.util.TradingDate;

public class InternetImport {
    private static final String SYMBOL = "_SYM_";
    private static final String START_DAY = "_SD_";
    private static final String START_MONTH = "_SM_";
    private static final String START_YEAR = "_SY_";
    private static final String END_DAY = "_ED_";
    private static final String END_MONTH = "_EM_";
    private static final String END_YEAR = "_EY_";
    private static final String YAHOO_PATTERN = "?s=_SYM_&a=_SM_&b=_SD_&c=_SY_&d=_EM_&e=_ED_&f=_EY_&g=d&ignore=.csv";
    private static final String YAHOO_URL_PATTERN = "http://ichart.finance.yahoo.com/table.csv?s=_SYM_&a=_SM_&b=_SD_&c=_SY_&d=_EM_&e=_ED_&f=_EY_&g=d&ignore=.csv";
    static final /* synthetic */ boolean $assertionsDisabled;

    private InternetImport() {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public static List importSymbol(Report report, Symbol symbol, TradingDate startDate, TradingDate endDate) throws IOException {
        ArrayList<Quote> quotes = new ArrayList<Quote>();
        String URLString = InternetImport.constructURL(symbol, startDate, endDate);
        YahooQuoteFilter filter = new YahooQuoteFilter(symbol);
        PreferencesManager.ProxyPreferences proxyPreferences = PreferencesManager.loadProxySettings();
        try {
            URL url = new URL(URLString);
            InputStreamReader input = new InputStreamReader(url.openStream());
            BufferedReader bufferedInput = new BufferedReader(input);
            String line = bufferedInput.readLine();
            while (line != null) {
                line = bufferedInput.readLine();
                if (line == null) continue;
                try {
                    Quote quote = filter.toQuote(line);
                    quotes.add(quote);
                    InternetImport.verify(report, quote);
                }
                catch (QuoteFormatException e) {
                    report.addError(Locale.getString("YAHOO") + ":" + symbol + ":" + Locale.getString("ERROR") + ": " + e.getMessage());
                }
            }
            bufferedInput.close();
        }
        catch (BindException e) {
            DesktopManager.showErrorMessage(Locale.getString("UNABLE_TO_CONNECT_ERROR", e.getMessage()));
            throw new IOException();
        }
        catch (ConnectException e) {
            DesktopManager.showErrorMessage(Locale.getString("UNABLE_TO_CONNECT_ERROR", e.getMessage()));
            throw new IOException();
        }
        catch (UnknownHostException e) {
            DesktopManager.showErrorMessage(Locale.getString("UNKNOWN_HOST_ERROR", e.getMessage()));
            throw new IOException();
        }
        catch (NoRouteToHostException e) {
            DesktopManager.showErrorMessage(Locale.getString("DESTINATION_UNREACHABLE_ERROR", e.getMessage()));
            throw new IOException();
        }
        catch (MalformedURLException e) {
            DesktopManager.showErrorMessage(Locale.getString("INVALID_PROXY_ERROR", proxyPreferences.host, proxyPreferences.port));
            throw new IOException();
        }
        catch (FileNotFoundException e) {
            report.addError(Locale.getString("YAHOO") + ":" + symbol + ":" + Locale.getString("ERROR") + ": " + Locale.getString("NO_QUOTES_FOUND"));
        }
        catch (IOException e) {
            DesktopManager.showErrorMessage(Locale.getString("ERROR_DOWNLOADING_QUOTES"));
            throw new IOException();
        }
        return quotes;
    }

    private static String constructURL(Symbol symbol, TradingDate start, TradingDate end) {
        String URLString = YAHOO_URL_PATTERN;
        URLString = InternetImport.replace(URLString, SYMBOL, symbol.toString());
        URLString = InternetImport.replace(URLString, START_DAY, Integer.toString(start.getDay()));
        URLString = InternetImport.replace(URLString, START_MONTH, Integer.toString(start.getMonth() - 1));
        URLString = InternetImport.replace(URLString, START_YEAR, Integer.toString(start.getYear()));
        URLString = InternetImport.replace(URLString, END_DAY, Integer.toString(end.getDay()));
        URLString = InternetImport.replace(URLString, END_MONTH, Integer.toString(end.getMonth() - 1));
        URLString = InternetImport.replace(URLString, END_YEAR, Integer.toString(end.getYear()));
        return URLString;
    }

    private static String replace(String string, String oldSubString, String newSubString) {
        Pattern pattern = Pattern.compile(oldSubString);
        Matcher matcher = pattern.matcher(string);
        return matcher.replaceAll(newSubString);
    }

    private static void verify(Report report, Quote quote) {
        try {
            quote.verify();
        }
        catch (QuoteFormatException e) {
            List messages = e.getMessages();
            Iterator iterator = messages.iterator();
            while (iterator.hasNext()) {
                String message = (String)iterator.next();
                report.addWarning(Locale.getString("YAHOO") + ":" + quote.getSymbol() + ":" + quote.getDate() + ":" + Locale.getString("WARNING") + ": " + message);
            }
        }
    }

    static {
        $assertionsDisabled = !InternetImport.class.desiredAssertionStatus();
    }
}

