/*
 * Decompiled with CFR 0.152.
 */
package org.mov.quote;

import java.text.NumberFormat;
import org.mov.quote.Quote;
import org.mov.quote.QuoteFilter;
import org.mov.quote.QuoteFormatException;
import org.mov.quote.Symbol;
import org.mov.quote.SymbolFormatException;
import org.mov.util.Locale;
import org.mov.util.TradingDate;
import org.mov.util.TradingDateFormatException;

public class MetaStock2QuoteFilter
implements QuoteFilter {
    private NumberFormat format = null;

    public String getName() {
        return new String("MetaStock (" + Locale.getString("VOLUME") + "/100)");
    }

    public Quote toQuote(String quoteLine) throws QuoteFormatException {
        Quote quote = null;
        if (quoteLine != null) {
            String[] quoteParts = quoteLine.split(",");
            int i = 0;
            if (quoteParts.length == 7) {
                Symbol symbol = null;
                try {
                    symbol = Symbol.find(quoteParts[i++]);
                }
                catch (SymbolFormatException e) {
                    throw new QuoteFormatException(e.getMessage());
                }
                TradingDate date = null;
                try {
                    date = new TradingDate(quoteParts[i++], 1);
                }
                catch (TradingDateFormatException e) {
                    throw new QuoteFormatException(e.getMessage());
                }
                try {
                    float day_open = Float.parseFloat(quoteParts[i++]);
                    float day_high = Float.parseFloat(quoteParts[i++]);
                    float day_low = Float.parseFloat(quoteParts[i++]);
                    float day_close = Float.parseFloat(quoteParts[i++]);
                    int day_volume = Integer.parseInt(quoteParts[i++]) * 100;
                    quote = new Quote(symbol, date, day_volume, day_low, day_high, day_open, day_close);
                }
                catch (NumberFormatException e) {
                    throw new QuoteFormatException(Locale.getString("ERROR_PARSING_NUMBER", quoteParts[i - 1]));
                }
            }
            throw new QuoteFormatException(Locale.getString("WRONG_FIELD_COUNT"));
        }
        return quote;
    }

    public String toString(Quote quote) {
        if (this.format == null) {
            this.format = NumberFormat.getInstance();
            this.format.setMinimumIntegerDigits(1);
            this.format.setMinimumFractionDigits(1);
            this.format.setMaximumFractionDigits(3);
        }
        return new String(quote.getSymbol() + "," + quote.getDate().toString("yyyymmdd") + "," + this.format.format(quote.getDayOpen()) + "," + this.format.format(quote.getDayHigh()) + "," + this.format.format(quote.getDayLow()) + "," + this.format.format(quote.getDayClose()) + "," + quote.getDayVolume() / 100);
    }
}

