/*
 * Decompiled with CFR 0.152.
 */
package org.mov.quote;

import java.util.ArrayList;
import org.mov.quote.QuoteFormatException;
import org.mov.quote.Symbol;
import org.mov.ui.QuoteFormat;
import org.mov.util.Locale;
import org.mov.util.TradingDate;

public class Quote {
    private Symbol symbol;
    private TradingDate date;
    private int day_volume;
    private double day_low;
    private double day_high;
    private double day_open;
    private double day_close;
    public static final int DAY_CLOSE = 0;
    public static final int DAY_OPEN = 1;
    public static final int DAY_LOW = 2;
    public static final int DAY_HIGH = 3;
    public static final int DAY_VOLUME = 4;
    private static final int SUSPECT_YEAR = 1900;
    private static final TradingDate SUSPECT_DATE;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Quote(Symbol symbol, TradingDate date, int day_volume, double day_low, double day_high, double day_open, double day_close) {
        this.setSymbol(symbol);
        this.setDate(date);
        this.day_volume = day_volume;
        this.day_low = day_low;
        this.day_high = day_high;
        this.day_open = day_open;
        this.day_close = day_close;
    }

    public void verify() throws QuoteFormatException {
        ArrayList<String> messages = new ArrayList<String>();
        if (this.date.before(SUSPECT_DATE)) {
            messages.add(Locale.getString("SUSPECT_YEAR", 1900));
        }
        if (this.date.after(new TradingDate())) {
            messages.add(Locale.getString("FUTURE_DATE"));
        }
        if (this.day_low > this.day_open || this.day_low > this.day_close || this.day_low > this.day_high) {
            messages.add(Locale.getString("DAY_LOW_NOT_LOWEST"));
            this.day_low = Math.min(Math.min(this.day_open, this.day_close), this.day_high);
        }
        if (this.day_high < this.day_open || this.day_high < this.day_close || this.day_high < this.day_low) {
            messages.add(Locale.getString("DAY_HIGH_NOT_HIGHEST"));
            this.day_high = Math.max(Math.max(this.day_open, this.day_close), this.day_low);
        }
        if (this.day_low < 0.0) {
            messages.add(Locale.getString("DAY_LOW_LESS_THAN_ZERO"));
            this.day_low = 0.0;
        }
        if (this.day_high < 0.0) {
            messages.add(Locale.getString("DAY_HIGH_LESS_THAN_ZERO"));
            this.day_high = 0.0;
        }
        if (this.day_open < 0.0) {
            messages.add(Locale.getString("DAY_OPEN_LESS_THAN_ZERO"));
            this.day_open = 0.0;
        }
        if (this.day_close < 0.0) {
            messages.add(Locale.getString("DAY_CLOSE_LESS_THAN_ZERO"));
            this.day_close = 0.0;
        }
        if (this.day_volume < 0) {
            messages.add(Locale.getString("DAY_VOLUME_LESS_THAN_ZERO"));
            this.day_volume = 0;
        }
        if (messages.size() > 0) {
            throw new QuoteFormatException(messages);
        }
    }

    public Symbol getSymbol() {
        return this.symbol;
    }

    public TradingDate getDate() {
        return this.date;
    }

    public int getDayVolume() {
        return this.day_volume;
    }

    public double getDayLow() {
        return this.day_low;
    }

    public double getDayHigh() {
        return this.day_high;
    }

    public double getDayOpen() {
        return this.day_open;
    }

    public double getDayClose() {
        return this.day_close;
    }

    public void setSymbol(Symbol symbol) {
        this.symbol = symbol;
    }

    public void setDate(TradingDate date) {
        this.date = date;
    }

    public boolean equals(Quote quote) {
        return this.getSymbol().equals(quote.getSymbol()) && this.getDate().equals(quote.getDate()) && this.getDayLow() == quote.getDayLow() && this.getDayHigh() == quote.getDayHigh() && this.getDayOpen() == quote.getDayOpen() && this.getDayClose() == quote.getDayClose() && this.getDayVolume() == quote.getDayVolume();
    }

    public double getQuote(int quote) {
        switch (quote) {
            case 1: {
                return this.getDayOpen();
            }
            case 0: {
                return this.getDayClose();
            }
            case 2: {
                return this.getDayLow();
            }
            case 3: {
                return this.getDayHigh();
            }
            case 4: {
                return this.getDayVolume();
            }
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return 0.0;
    }

    public String toString() {
        return new String(this.getSymbol() + ", " + this.getDate() + ", " + QuoteFormat.quoteToString(this.getDayOpen()) + ", " + QuoteFormat.quoteToString(this.getDayHigh()) + ", " + QuoteFormat.quoteToString(this.getDayLow()) + ", " + QuoteFormat.quoteToString(this.getDayClose()) + ", " + this.getDayVolume());
    }

    static {
        $assertionsDisabled = !Quote.class.desiredAssertionStatus();
        SUSPECT_DATE = new TradingDate(1900, 0, 0);
    }
}

