/*
 * Decompiled with CFR 0.152.
 */
package org.mov.quote;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.mov.prefs.PreferencesManager;
import org.mov.quote.QuoteBundle;
import org.mov.quote.QuoteCache;
import org.mov.quote.QuoteRange;
import org.mov.quote.QuoteSourceManager;
import org.mov.quote.Symbol;

public class QuoteBundleCache {
    private static QuoteBundleCache instance;
    private List loadedQuoteBundles;
    private QuoteCache quoteCache = QuoteCache.getInstance();
    static final /* synthetic */ boolean $assertionsDisabled;

    private QuoteBundleCache() {
        this.loadedQuoteBundles = Collections.synchronizedList(new ArrayList());
    }

    public static synchronized QuoteBundleCache getInstance() {
        if (instance == null) {
            instance = new QuoteBundleCache();
        }
        return instance;
    }

    public void expand(QuoteBundle quoteBundle, QuoteRange expandedQuoteRange) {
        QuoteRange oldQuoteRange = quoteBundle.getQuoteRange();
        if (!$assertionsDisabled && expandedQuoteRange.getFirstDate() == null) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || expandedQuoteRange.getFirstDate().before(oldQuoteRange.getFirstDate()) || expandedQuoteRange.getLastDate().after(oldQuoteRange.getLastDate()))) {
            throw new AssertionError();
        }
        if (!this.isLoaded(quoteBundle)) {
            this.loadedQuoteBundles.add(quoteBundle);
        }
        this.forceLoad(expandedQuoteRange);
        quoteBundle.setQuoteRange(expandedQuoteRange);
    }

    public void load(QuoteBundle quoteBundle) {
        if (!this.isLoaded(quoteBundle)) {
            this.loadedQuoteBundles.add(quoteBundle);
            if (!this.forceLoad(quoteBundle.getQuoteRange())) {
                this.loadedQuoteBundles.remove(quoteBundle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean forceLoad(QuoteRange quoteRange) {
        List list = this.loadedQuoteBundles;
        synchronized (list) {
            Iterator iterator = this.loadedQuoteBundles.iterator();
            while (iterator.hasNext()) {
                QuoteBundle traverse = (QuoteBundle)iterator.next();
                if (!iterator.hasNext() || (quoteRange = traverse.getQuoteRange().clip(quoteRange)) != null) continue;
                break;
            }
        }
        if (quoteRange != null) {
            if (!QuoteSourceManager.getSource().loadQuoteRange(quoteRange)) {
                return false;
            }
            int maximumCachedQuotes = PreferencesManager.loadMaximumCachedQuotes();
            List list2 = this.loadedQuoteBundles;
            synchronized (list2) {
                while (this.quoteCache.size() > maximumCachedQuotes && this.loadedQuoteBundles.size() > 1) {
                    this.free((QuoteBundle)this.loadedQuoteBundles.get(0));
                }
            }
        }
        return true;
    }

    public boolean isLoaded(QuoteBundle quoteBundle) {
        return this.loadedQuoteBundles.contains(quoteBundle);
    }

    private void free(QuoteBundle quoteBundle) {
        int firstDateOffset = quoteBundle.getFirstDateOffset();
        int lastDateOffset = quoteBundle.getLastDateOffset();
        for (int dateOffset = firstDateOffset; dateOffset <= lastDateOffset; ++dateOffset) {
            List symbols = quoteBundle.getSymbols(dateOffset);
            Iterator iterator = symbols.iterator();
            while (iterator.hasNext()) {
                Symbol symbol = (Symbol)iterator.next();
                if (this.isQuoteUsedElsewhere(symbol, dateOffset)) continue;
                this.quoteCache.free(symbol, dateOffset);
            }
        }
        this.loadedQuoteBundles.remove(quoteBundle);
    }

    private boolean isQuoteUsedElsewhere(Symbol symbol, int dateOffset) {
        Iterator iterator = this.loadedQuoteBundles.iterator();
        if (iterator.hasNext()) {
            iterator.next();
        }
        while (iterator.hasNext()) {
            QuoteBundle quoteBundle = (QuoteBundle)iterator.next();
            if (!quoteBundle.containsQuote(symbol, dateOffset)) continue;
            return true;
        }
        return false;
    }

    static {
        $assertionsDisabled = !QuoteBundleCache.class.desiredAssertionStatus();
        instance = null;
    }
}

