/*
 * Decompiled with CFR 0.152.
 */
package org.mov.quote;

import org.mov.parser.EvaluationException;
import org.mov.quote.MissingQuoteException;
import org.mov.quote.QuoteBundle;
import org.mov.quote.QuoteFunctionSource;
import org.mov.quote.Symbol;

public class QuoteBundleFunctionSource
implements QuoteFunctionSource {
    private QuoteBundle quoteBundle;
    private Symbol symbol;
    private int quoteKind;
    private int day;
    private int offset;
    private int period;
    static final /* synthetic */ boolean $assertionsDisabled;

    public QuoteBundleFunctionSource(QuoteBundle quoteBundle, Symbol symbol, int quoteKind, int day, int offset, int period) {
        this.quoteBundle = quoteBundle;
        this.symbol = symbol;
        this.quoteKind = quoteKind;
        this.day = day;
        this.offset = offset;
        this.period = period;
    }

    public double getValue(int index) throws EvaluationException {
        if (!($assertionsDisabled || index >= 0 && index < this.period)) {
            throw new AssertionError();
        }
        try {
            return this.quoteBundle.getQuote(this.symbol, this.quoteKind, this.day, index - this.period + this.offset + 1);
        }
        catch (MissingQuoteException e) {
            return Double.NaN;
        }
    }

    static {
        $assertionsDisabled = !QuoteBundleFunctionSource.class.desiredAssertionStatus();
    }
}

