/*
 * Decompiled with CFR 0.152.
 */
package org.mov.quote;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.mov.quote.MissingQuoteException;
import org.mov.quote.Quote;
import org.mov.quote.QuoteBundle;
import org.mov.quote.QuoteCache;
import org.mov.quote.Symbol;
import org.mov.quote.WeekendDateException;
import org.mov.util.TradingDate;

public class QuoteBundleIterator
implements Iterator {
    private Iterator symbolsIterator;
    private QuoteBundle quoteBundle;
    private TradingDate nextDate;
    private Symbol nextSymbol;
    private boolean isMore;
    static final /* synthetic */ boolean $assertionsDisabled;

    public QuoteBundleIterator(QuoteBundle quoteBundle) {
        this.quoteBundle = quoteBundle;
        this.nextDate = quoteBundle.getFirstDate();
        List symbols = quoteBundle.getSymbols(this.nextDate);
        this.symbolsIterator = symbols.iterator();
        this.isMore = true;
        this.findNext();
    }

    private void findNext() {
        if (!$assertionsDisabled && !this.isMore) {
            throw new AssertionError();
        }
        boolean found = false;
        while (!found && this.isMore) {
            if (this.symbolsIterator.hasNext()) {
                this.nextSymbol = (Symbol)this.symbolsIterator.next();
            } else {
                this.nextDate = this.nextDate.next(1);
                while (this.nextDate.compareTo(this.quoteBundle.getLastDate()) <= 0) {
                    List symbols = this.quoteBundle.getSymbols(this.nextDate);
                    if (symbols.size() > 0) {
                        this.symbolsIterator = symbols.iterator();
                        this.nextSymbol = (Symbol)this.symbolsIterator.next();
                        break;
                    }
                    this.nextDate = this.nextDate.next(1);
                }
                if (this.nextDate.compareTo(this.quoteBundle.getLastDate()) > 0) {
                    this.isMore = false;
                    break;
                }
            }
            try {
                double volume = this.quoteBundle.getQuote(this.nextSymbol, 4, this.nextDate);
                found = true;
            }
            catch (MissingQuoteException e) {
                found = false;
            }
        }
    }

    public Object next() {
        if (this.hasNext()) {
            int dateOffset;
            try {
                dateOffset = QuoteCache.getInstance().dateToOffset(this.nextDate);
            }
            catch (WeekendDateException e) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                return null;
            }
            try {
                Quote quote = new Quote(this.nextSymbol, this.nextDate, (int)this.quoteBundle.getQuote(this.nextSymbol, 4, dateOffset), this.quoteBundle.getQuote(this.nextSymbol, 2, dateOffset), this.quoteBundle.getQuote(this.nextSymbol, 3, dateOffset), this.quoteBundle.getQuote(this.nextSymbol, 1, dateOffset), this.quoteBundle.getQuote(this.nextSymbol, 0, dateOffset));
                this.findNext();
                return quote;
            }
            catch (MissingQuoteException e) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                return null;
            }
        }
        throw new NoSuchElementException();
    }

    public boolean hasNext() {
        return this.isMore;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    static {
        $assertionsDisabled = !QuoteBundleIterator.class.desiredAssertionStatus();
    }
}

