/*
 * Decompiled with CFR 0.152.
 */
package org.mov.quote;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.mov.quote.Quote;
import org.mov.quote.QuoteNotLoadedException;
import org.mov.quote.QuoteSourceManager;
import org.mov.quote.Symbol;
import org.mov.quote.WeekendDateException;
import org.mov.util.TradingDate;
import org.mov.util.TradingDateComparator;

public class QuoteCache {
    private List cache = new ArrayList();
    private List dates = new ArrayList();
    private int size = 0;
    private static QuoteCache instance;
    static final /* synthetic */ boolean $assertionsDisabled;

    private QuoteCache() {
        TradingDate lastDate = QuoteSourceManager.getSource().getLastDate();
        if (lastDate != null) {
            this.addDate(lastDate);
        }
    }

    public static synchronized QuoteCache getInstance() {
        if (instance == null) {
            instance = new QuoteCache();
        }
        return instance;
    }

    public static boolean isInstantiated() {
        return instance != null;
    }

    public double getQuote(Symbol symbol, int quoteType, int dateOffset) throws QuoteNotLoadedException {
        QuoteCacheQuote quote = this.getQuoteCacheQuote(symbol, dateOffset);
        if (quote != null) {
            return quote.getQuote(quoteType);
        }
        throw QuoteNotLoadedException.getInstance();
    }

    public List getSymbols(int dateOffset) {
        HashMap quotesForDate;
        try {
            quotesForDate = this.getQuotesForDate(dateOffset);
        }
        catch (QuoteNotLoadedException e) {
            quotesForDate = new HashMap(0);
        }
        return new ArrayList(quotesForDate.keySet());
    }

    public List getSymbols(int firstDateOffset, int lastDateOffset) {
        HashMap allSymbols = new HashMap();
        for (int dateOffset = firstDateOffset; dateOffset <= lastDateOffset; ++dateOffset) {
            try {
                HashMap todaySymbols = this.getQuotesForDate(dateOffset);
                allSymbols.putAll(todaySymbols);
                continue;
            }
            catch (QuoteNotLoadedException e) {
                // empty catch block
            }
        }
        return new ArrayList(allSymbols.keySet());
    }

    public boolean containsQuote(Symbol symbol, int dateOffset) {
        QuoteCacheQuote quote;
        HashMap symbols;
        if (!$assertionsDisabled && dateOffset > 0) {
            throw new AssertionError();
        }
        return dateOffset > -this.dates.size() && (symbols = (HashMap)this.cache.get(-dateOffset)) != null && (quote = (QuoteCacheQuote)symbols.get(symbol)) != null;
    }

    private QuoteCacheQuote getQuoteCacheQuote(Symbol symbol, int dateOffset) throws QuoteNotLoadedException {
        HashMap symbols = this.getQuotesForDate(dateOffset);
        if (!$assertionsDisabled && symbols == null) {
            throw new AssertionError();
        }
        return (QuoteCacheQuote)symbols.get(symbol);
    }

    private HashMap getQuotesForDate(int dateOffset) throws QuoteNotLoadedException {
        if (!$assertionsDisabled && dateOffset > 0) {
            throw new AssertionError();
        }
        if (dateOffset <= -this.dates.size()) {
            throw QuoteNotLoadedException.getInstance();
        }
        HashMap quotesForDate = (HashMap)this.cache.get(-dateOffset);
        if (quotesForDate == null) {
            throw QuoteNotLoadedException.getInstance();
        }
        return quotesForDate;
    }

    public void load(Quote quote) {
        this.load(quote.getSymbol(), quote.getDate(), quote.getDayVolume(), (float)quote.getDayLow(), (float)quote.getDayHigh(), (float)quote.getDayOpen(), (float)quote.getDayClose());
    }

    public synchronized void load(Symbol symbol, TradingDate date, int day_volume, float day_low, float day_high, float day_open, float day_close) {
        HashMap<Symbol, QuoteCacheQuote> quotesForDate;
        int dateOffset;
        try {
            dateOffset = this.dateToOffset(date);
        }
        catch (WeekendDateException e) {
            return;
        }
        try {
            quotesForDate = this.getQuotesForDate(dateOffset);
        }
        catch (QuoteNotLoadedException e) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            quotesForDate = new HashMap<Symbol, QuoteCacheQuote>(0);
        }
        QuoteCacheQuote yesterdayQuote = null;
        QuoteCacheQuote todayQuote = null;
        try {
            yesterdayQuote = this.getQuoteCacheQuote(symbol, dateOffset - 1);
        }
        catch (QuoteNotLoadedException e) {
            // empty catch block
        }
        todayQuote = yesterdayQuote != null && yesterdayQuote.equals(day_volume, day_low, day_high, day_open, day_close) ? yesterdayQuote : new QuoteCacheQuote(day_volume, day_low, day_high, day_open, day_close);
        QuoteCacheQuote previousQuote = quotesForDate.put(symbol, todayQuote);
        if (previousQuote == null) {
            ++this.size;
        }
    }

    public synchronized void free(Symbol symbol, int dateOffset) {
        block5: {
            try {
                HashMap quotesForDate = this.getQuotesForDate(dateOffset);
                Object quote = quotesForDate.remove(symbol);
                if (quote != null) {
                    --this.size;
                    if (quotesForDate.isEmpty()) {
                        this.cache.set(-dateOffset, new HashMap());
                    }
                }
                if (!$assertionsDisabled && this.size < 0) {
                    throw new AssertionError();
                }
            }
            catch (QuoteNotLoadedException e) {
                if ($assertionsDisabled) break block5;
                throw new AssertionError();
            }
        }
    }

    public int dateToOffset(TradingDate date) throws WeekendDateException {
        TradingDateComparator comparator = new TradingDateComparator(TradingDateComparator.BACKWARDS);
        int dateOffset = -Collections.binarySearch(this.dates, date, comparator);
        if (dateOffset > this.dates.size() || dateOffset == 1) {
            this.expandToDate(date);
            dateOffset = -Collections.binarySearch(this.dates, date, comparator);
        }
        if (dateOffset > 0) {
            throw new WeekendDateException();
        }
        return dateOffset;
    }

    public TradingDate offsetToDate(int dateOffset) {
        if (!$assertionsDisabled && dateOffset > 0) {
            throw new AssertionError();
        }
        while (dateOffset <= -this.dates.size()) {
            TradingDate date = this.getFirstDate().previous(1);
            this.addDate(date);
        }
        return (TradingDate)this.dates.get(-dateOffset);
    }

    public int size() {
        return this.size;
    }

    public TradingDate getFirstDate() {
        if (this.dates.size() > 0) {
            return (TradingDate)this.dates.get(this.dates.size() - 1);
        }
        return null;
    }

    public TradingDate getLastDate() {
        if (this.dates.size() > 0) {
            return (TradingDate)this.dates.get(0);
        }
        return null;
    }

    public int getFirstDateOffset() {
        return -(this.dates.size() - 1);
    }

    private void addDate(TradingDate date) {
        HashMap map = new HashMap(0);
        this.cache.add(map);
        this.dates.add(date);
    }

    private void insertDate(TradingDate date) {
        HashMap map = new HashMap(0);
        this.cache.add(0, map);
        this.dates.add(0, date);
    }

    private void expandToDate(TradingDate date) {
        block4: {
            TradingDate lastDate;
            block5: {
                TradingDate firstDate;
                block3: {
                    if (!$assertionsDisabled && date == null) {
                        throw new AssertionError();
                    }
                    firstDate = this.getFirstDate();
                    lastDate = this.getLastDate();
                    if (firstDate != null) break block3;
                    this.addDate(date);
                    break block4;
                }
                if (!date.before(firstDate)) break block5;
                while (date.before(firstDate)) {
                    firstDate = firstDate.previous(1);
                    this.addDate(firstDate);
                }
                break block4;
            }
            if (!date.after(lastDate)) break block4;
            while (date.after(lastDate)) {
                lastDate = lastDate.next(1);
                this.insertDate(lastDate);
            }
        }
    }

    static {
        $assertionsDisabled = !QuoteCache.class.desiredAssertionStatus();
        instance = null;
    }

    private class QuoteCacheQuote {
        public int day_volume;
        public float day_low;
        public float day_high;
        public float day_open;
        public float day_close;
        static final /* synthetic */ boolean $assertionsDisabled;

        public QuoteCacheQuote(int day_volume, float day_low, float day_high, float day_open, float day_close) {
            this.day_volume = day_volume;
            this.day_low = day_low;
            this.day_high = day_high;
            this.day_open = day_open;
            this.day_close = day_close;
        }

        public double getQuote(int quote) {
            switch (quote) {
                case 1: {
                    return this.day_open;
                }
                case 0: {
                    return this.day_close;
                }
                case 2: {
                    return this.day_low;
                }
                case 3: {
                    return this.day_high;
                }
                case 4: {
                    return this.day_volume;
                }
            }
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return 0.0;
        }

        public boolean equals(int day_volume, float day_low, float day_high, float day_open, float day_close) {
            return day_volume == this.day_volume && day_low == this.day_low && day_high == this.day_high && day_open == this.day_open && day_close == this.day_close;
        }

        static {
            $assertionsDisabled = !(class$org$mov$quote$QuoteCache == null ? (class$org$mov$quote$QuoteCache = QuoteCache.class$("org.mov.quote.QuoteCache")) : class$org$mov$quote$QuoteCache).desiredAssertionStatus();
        }
    }
}

