/*
 * Decompiled with CFR 0.152.
 */
package org.mov.quote;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.mov.quote.EzyChartQuoteFilter;
import org.mov.quote.InsightTraderQuoteFilter;
import org.mov.quote.MetaStock2QuoteFilter;
import org.mov.quote.MetaStockQuoteFilter;
import org.mov.quote.QuoteFilter;

public class QuoteFilterList {
    private static QuoteFilterList instance = null;
    private List filters = new ArrayList();

    private QuoteFilterList() {
        this.filters.add(new EzyChartQuoteFilter());
        this.filters.add(new InsightTraderQuoteFilter());
        this.filters.add(new MetaStockQuoteFilter());
        this.filters.add(new MetaStock2QuoteFilter());
    }

    public QuoteFilter getFilter(String filterName) {
        Iterator iterator = this.filters.iterator();
        while (iterator.hasNext()) {
            QuoteFilter filter = (QuoteFilter)iterator.next();
            if (!filter.getName().equals(filterName)) continue;
            return filter;
        }
        return (QuoteFilter)this.filters.get(0);
    }

    public static QuoteFilterList getInstance() {
        if (instance == null) {
            instance = new QuoteFilterList();
        }
        return instance;
    }

    public List getList() {
        return this.filters;
    }

    public boolean isFilter(String filterName) {
        Iterator iterator = this.getList().iterator();
        while (iterator.hasNext()) {
            QuoteFilter filter = (QuoteFilter)iterator.next();
            if (!filter.getName().equals(filterName)) continue;
            return true;
        }
        return false;
    }
}

