/*
 * Decompiled with CFR 0.152.
 */
package org.mov.quote;

import org.mov.parser.EvaluationException;
import org.mov.quote.QuoteFunctionSource;

public class QuoteFunctions {
    public static final int DEFAULT_RSI_PERIOD = 45;
    static final /* synthetic */ boolean $assertionsDisabled;

    private QuoteFunctions() {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public static double sd(QuoteFunctionSource source, int period) throws EvaluationException {
        double average = QuoteFunctions.avg(source, period);
        double deviationSum = 0.0;
        int actualPeriod = 0;
        for (int i = 0; i < period; ++i) {
            double value = source.getValue(i);
            if (Double.isNaN(value)) continue;
            deviationSum += (value - average) * (value - average);
            ++actualPeriod;
        }
        if (actualPeriod > 2) {
            deviationSum /= (double)(actualPeriod - 1);
        }
        return Math.sqrt(deviationSum);
    }

    public static double sd(double[] values, int start, int end) {
        double average = QuoteFunctions.avg(values, start, end);
        int period = end - start;
        double deviationSum = 0.0;
        for (int i = start; i < end; ++i) {
            deviationSum += (values[i] - average) * (values[i] - average);
        }
        if (period > 2) {
            deviationSum /= (double)(period - 1);
        }
        return Math.sqrt(deviationSum);
    }

    public static double avg(QuoteFunctionSource source, int period) throws EvaluationException {
        double avg = 0.0;
        int actualPeriod = 0;
        for (int i = 0; i < period; ++i) {
            double value = source.getValue(i);
            if (Double.isNaN(value)) continue;
            avg += value;
            ++actualPeriod;
        }
        if (actualPeriod > 1) {
            avg /= (double)actualPeriod;
        }
        return avg;
    }

    public static double avg(double[] values, int start, int end) {
        double avg = 0.0;
        int period = end - start;
        for (int i = start; i < end; ++i) {
            avg += values[i];
        }
        if (period > 1) {
            avg /= (double)period;
        }
        return avg;
    }

    public static double corr(QuoteFunctionSource x, QuoteFunctionSource y, int period) throws EvaluationException {
        double r = 0.0;
        double ex = QuoteFunctions.avg(x, period);
        double sx = QuoteFunctions.sd(x, period);
        double ey = QuoteFunctions.avg(y, period);
        double sy = QuoteFunctions.sd(y, period);
        int actualPeriod = 0;
        if (sx != 0.0 && sy != 0.0) {
            for (int i = 0; i < period; ++i) {
                double xi = x.getValue(i);
                double yi = y.getValue(i);
                if (Double.isNaN(xi) || Double.isNaN(yi)) continue;
                double zx = (xi - ex) / sx;
                double zy = (yi - ey) / sy;
                r += zx * zy;
                ++actualPeriod;
            }
            if (actualPeriod > 1) {
                r /= (double)(actualPeriod - 1);
            }
        }
        return r;
    }

    public static double rsi(QuoteFunctionSource source, int period) throws EvaluationException {
        double sumGain = 0.0;
        double sumLoss = 0.0;
        int numberGains = 0;
        int numberLosses = 0;
        double previous = Double.NaN;
        int i = 0;
        while (Double.isNaN(previous) && i < period) {
            previous = source.getValue(i++);
        }
        while (i < period) {
            double value;
            if (Double.isNaN(value = source.getValue(i++))) continue;
            if (value > previous) {
                sumGain += value - previous;
                ++numberGains;
            } else if (value < previous) {
                sumLoss += previous - value;
                ++numberLosses;
            }
            previous = value;
        }
        if (numberLosses == 0 && numberGains == 0) {
            return 50.0;
        }
        if (numberLosses == 0 || sumLoss / (double)numberLosses == 0.0) {
            return 100.0;
        }
        double avgLoss = sumLoss / (double)numberLosses;
        double avgGain = numberGains == 0 ? 0.0 : sumGain / (double)numberGains;
        double RS = avgGain / avgLoss;
        return 100.0 - 100.0 / (1.0 + RS);
    }

    public static double ema(QuoteFunctionSource source, int period, double smoothingConstant) throws EvaluationException {
        double EMA = 0.0;
        double previousEMA = 0.0;
        int actualPeriod = 0;
        for (int i = 0; i < period; ++i) {
            double value = source.getValue(i);
            if (Double.isNaN(value)) continue;
            EMA = actualPeriod >= 1 ? previousEMA + smoothingConstant * (value - previousEMA) : value;
            previousEMA = EMA;
            ++actualPeriod;
        }
        return EMA;
    }

    public static double macd(QuoteFunctionSource sourceSlow, QuoteFunctionSource sourceFast) throws EvaluationException {
        double MACD = 0.0;
        double smoothingConstant = 0.1;
        int periodSlow = 26;
        int periodFast = 12;
        MACD = QuoteFunctions.ema(sourceSlow, periodSlow, smoothingConstant) - QuoteFunctions.ema(sourceFast, periodFast, smoothingConstant);
        return MACD;
    }

    public static double momentum(QuoteFunctionSource source, int period) throws EvaluationException {
        double momentum = 0.0;
        double valueDay = source.getValue(0);
        if (!Double.isNaN(valueDay)) {
            for (int i = period - 1; i > 0; --i) {
                double value = source.getValue(i);
                if (Double.isNaN(value)) continue;
                momentum = value - valueDay;
                i = 0;
            }
        }
        return momentum;
    }

    public static int obv(QuoteFunctionSource sourceOpen, QuoteFunctionSource sourceClose, QuoteFunctionSource sourceVolume, int range, int initialValue) throws EvaluationException {
        int OBV = initialValue;
        for (int i = range - 1; i >= 0; --i) {
            double open = sourceOpen.getValue(i);
            double close = sourceClose.getValue(i);
            double volume = sourceVolume.getValue(i);
            if (Double.isNaN(open) || Double.isNaN(close) || Double.isNaN(volume)) continue;
            if (close > open) {
                OBV += new Double(volume).intValue();
                continue;
            }
            if (!(close < open)) continue;
            OBV -= new Double(volume).intValue();
        }
        return OBV;
    }

    public static double bollingerUpper(QuoteFunctionSource source, int period) throws EvaluationException {
        double sd = QuoteFunctions.sd(source, period);
        double avg = QuoteFunctions.avg(source, period);
        return avg + 2.0 * sd;
    }

    public static double bollingerLower(QuoteFunctionSource source, int period) throws EvaluationException {
        double sd = QuoteFunctions.sd(source, period);
        double avg = QuoteFunctions.avg(source, period);
        return avg - 2.0 * sd;
    }

    public static final double roundDouble(double d, int places) {
        return (double)Math.round(d * Math.pow(10.0, places)) / Math.pow(10.0, places);
    }

    static {
        $assertionsDisabled = !QuoteFunctions.class.desiredAssertionStatus();
    }
}

