/*
 * Decompiled with CFR 0.152.
 */
package org.mov.quote;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import org.mov.quote.QuoteSourceManager;
import org.mov.quote.Symbol;
import org.mov.util.Locale;
import org.mov.util.TradingDate;

public class QuoteRange
implements Cloneable {
    public static final int ALL_ORDINARIES = 1;
    public static final int ALL_SYMBOLS = 2;
    public static final int MARKET_INDICES = 3;
    public static final int GIVEN_SYMBOLS = 4;
    private static final int NO_OVERLAP = 1;
    private static final int PARTIAL_OVERLAP = 2;
    private static final int CONTAINED = 3;
    private static final int CONTAINS = 4;
    private TradingDate firstDate;
    private TradingDate lastDate;
    private List symbols = null;
    private int type = 0;
    static final /* synthetic */ boolean $assertionsDisabled;

    public QuoteRange(List symbols) {
        this.symbols = new ArrayList(symbols);
        this.type = 4;
        this.firstDate = null;
        this.lastDate = null;
        if (!$assertionsDisabled && symbols.size() <= 0) {
            throw new AssertionError();
        }
    }

    public QuoteRange(SortedSet symbols) {
        this.symbols = new ArrayList(symbols);
        this.type = 4;
        this.firstDate = null;
        this.lastDate = null;
        if (!$assertionsDisabled && symbols.size() <= 0) {
            throw new AssertionError();
        }
    }

    public QuoteRange(List symbols, TradingDate firstDate, TradingDate lastDate) {
        this.symbols = new ArrayList(symbols);
        this.type = 4;
        this.firstDate = firstDate;
        this.lastDate = lastDate;
        if (!$assertionsDisabled && symbols.size() <= 0) {
            throw new AssertionError();
        }
    }

    public QuoteRange(List symbols, TradingDate date) {
        this.symbols = new ArrayList(symbols);
        this.type = 4;
        this.firstDate = date;
        this.lastDate = date;
        if (!$assertionsDisabled && symbols.size() <= 0) {
            throw new AssertionError();
        }
    }

    public QuoteRange(Symbol symbol) {
        this.symbols = new ArrayList();
        this.symbols.add(symbol);
        this.type = 4;
        this.firstDate = null;
        this.lastDate = null;
    }

    public QuoteRange(Symbol symbol, TradingDate firstDate, TradingDate lastDate) {
        this.symbols = new ArrayList();
        this.symbols.add(symbol);
        this.type = 4;
        this.firstDate = firstDate;
        this.lastDate = lastDate;
    }

    public QuoteRange(int type, TradingDate date) {
        if (!$assertionsDisabled && type == 4) {
            throw new AssertionError();
        }
        this.symbols = null;
        this.type = type;
        this.firstDate = date;
        this.lastDate = date;
    }

    public QuoteRange(int type, TradingDate firstDate, TradingDate lastDate) {
        if (!$assertionsDisabled && type == 4) {
            throw new AssertionError();
        }
        this.symbols = null;
        this.type = type;
        this.firstDate = firstDate;
        this.lastDate = lastDate;
    }

    public QuoteRange(int type) {
        if (!$assertionsDisabled && type == 4) {
            throw new AssertionError();
        }
        this.symbols = null;
        this.type = type;
        this.firstDate = null;
        this.lastDate = null;
    }

    public Object clone() {
        QuoteRange cloned = this.type == 4 ? new QuoteRange(this.symbols, this.firstDate, this.lastDate) : new QuoteRange(this.type, this.firstDate, this.lastDate);
        return cloned;
    }

    public List getAllSymbols() {
        if (!($assertionsDisabled || this.type == 4 && this.symbols != null)) {
            throw new AssertionError();
        }
        return this.symbols;
    }

    public void setFirstDate(TradingDate firstDate) {
        this.firstDate = firstDate;
    }

    public void setLastDate(TradingDate lastDate) {
        this.lastDate = lastDate;
    }

    public TradingDate getFirstDate() {
        return this.firstDate;
    }

    public TradingDate getLastDate() {
        return this.lastDate;
    }

    public int getType() {
        return this.type;
    }

    public boolean containsSymbol(Symbol symbol) {
        if (this.type == 2) {
            return true;
        }
        if (this.type == 4) {
            return this.symbols.contains(symbol);
        }
        if (this.type == 1) {
            return !QuoteSourceManager.getSource().isMarketIndex(symbol) && symbol.length() <= 3;
        }
        if (!$assertionsDisabled && this.type != 3) {
            throw new AssertionError();
        }
        return QuoteSourceManager.getSource().isMarketIndex(symbol);
    }

    public boolean containsAllSymbols(List containedSymbols) {
        if (!($assertionsDisabled || containedSymbols != null && containedSymbols.size() > 0)) {
            throw new AssertionError();
        }
        if (this.type == 2) {
            return true;
        }
        if (this.type == 4) {
            return this.symbols.containsAll(containedSymbols);
        }
        if (this.type == 1) {
            Iterator iterator = containedSymbols.iterator();
            while (iterator.hasNext()) {
                Symbol symbol = (Symbol)iterator.next();
                if (!QuoteSourceManager.getSource().isMarketIndex(symbol) && symbol.length() <= 3) continue;
                return false;
            }
            return true;
        }
        if (!$assertionsDisabled && this.type != 3) {
            throw new AssertionError();
        }
        Iterator iterator = containedSymbols.iterator();
        while (iterator.hasNext()) {
            Symbol symbol = (Symbol)iterator.next();
            if (QuoteSourceManager.getSource().isMarketIndex(symbol)) continue;
            return false;
        }
        return true;
    }

    public String getDescription() {
        if (this.getType() == 4) {
            String string = "";
            Iterator iterator = this.getAllSymbols().iterator();
            while (iterator.hasNext()) {
                Symbol symbol = (Symbol)iterator.next();
                string = string.concat(symbol.toString());
                if (!iterator.hasNext()) continue;
                string = string.concat(", ");
            }
            return string;
        }
        return QuoteRange.getDescription(this.getType());
    }

    public static String getDescription(int type) {
        if (type == 2) {
            return Locale.getString("ALL_SYMBOLS");
        }
        if (type == 4) {
            return Locale.getString("GIVEN_SYMBOLS");
        }
        if (type == 1) {
            return Locale.getString("ALL_ORDINARIES");
        }
        if (!$assertionsDisabled && type != 3) {
            throw new AssertionError();
        }
        return Locale.getString("MARKET_INDICES");
    }

    public String toString() {
        String string = this.getDescription();
        string = this.getFirstDate() == null ? Locale.getString("FOR_ALL_DATES", string) : (this.getFirstDate().equals(this.getLastDate()) ? Locale.getString("ON_DATE", string, this.getFirstDate().toString()) : Locale.getString("BETWEEN_DATES", string, this.getFirstDate().toString(), this.getLastDate().toString()));
        return string;
    }

    public QuoteRange clip(QuoteRange quoteRange) {
        int overlapType = this.getOverlapType(quoteRange);
        if (overlapType == 4 || overlapType == 2) {
            if (this.getType() == 1 && quoteRange.getType() == 1 || this.getType() == 3 && quoteRange.getType() == 3 || this.getType() == 2 || this.getType() == 1 && quoteRange.getType() == 4 && this.containsAllSymbols(quoteRange.getAllSymbols()) || this.getType() == 4 && quoteRange.getType() == 4 && this.containsAllSymbols(quoteRange.getAllSymbols())) {
                if (overlapType == 2) {
                    QuoteRange clipped = (QuoteRange)quoteRange.clone();
                    if (this.getFirstDate().compareTo(quoteRange.getFirstDate()) <= 0 && this.getLastDate().compareTo(quoteRange.getLastDate()) <= 0) {
                        clipped.setFirstDate(this.getLastDate().next(1));
                    } else {
                        if (!($assertionsDisabled || this.getFirstDate().compareTo(quoteRange.getFirstDate()) >= 0 && this.getLastDate().compareTo(quoteRange.getLastDate()) >= 0)) {
                            throw new AssertionError();
                        }
                        clipped.setLastDate(this.getFirstDate().previous(1));
                    }
                    return clipped;
                }
                if (!$assertionsDisabled && overlapType != 4) {
                    throw new AssertionError();
                }
                return null;
            }
            return quoteRange;
        }
        return quoteRange;
    }

    private int getOverlapType(QuoteRange quoteRange) {
        if (this.getFirstDate() == null) {
            return 4;
        }
        if (quoteRange.getFirstDate() == null) {
            return 3;
        }
        if (this.getFirstDate().compareTo(quoteRange.getLastDate()) > 0 || this.getLastDate().compareTo(quoteRange.getFirstDate()) < 0) {
            return 1;
        }
        if (this.getFirstDate().compareTo(quoteRange.getFirstDate()) <= 0 && this.getLastDate().compareTo(quoteRange.getLastDate()) >= 0) {
            return 4;
        }
        if (this.getFirstDate().compareTo(quoteRange.getFirstDate()) > 0 && this.getLastDate().compareTo(quoteRange.getLastDate()) < 0) {
            return 3;
        }
        return 2;
    }

    static {
        $assertionsDisabled = !QuoteRange.class.desiredAssertionStatus();
    }
}

