/*
 * Decompiled with CFR 0.152.
 */
package org.mov.quote;

import org.mov.prefs.PreferencesManager;
import org.mov.quote.QuoteSource;
import org.mov.quote.QuoteSourceFactory;

public class QuoteSourceManager {
    private static QuoteSource sourceInstance;
    static final /* synthetic */ boolean $assertionsDisabled;

    private QuoteSourceManager() {
    }

    public static void setSource(QuoteSource source) {
        if (sourceInstance != null) {
            sourceInstance.shutdown();
        }
        sourceInstance = source;
    }

    public static void flush() {
        if (sourceInstance != null) {
            sourceInstance.shutdown();
            sourceInstance = null;
        }
    }

    public static void shutdown() {
        if (sourceInstance != null) {
            sourceInstance.shutdown();
        }
    }

    public static synchronized QuoteSource getSource() {
        if (sourceInstance == null) {
            int quoteSource = PreferencesManager.getQuoteSource();
            if (quoteSource == PreferencesManager.DATABASE) {
                sourceInstance = QuoteSourceFactory.createDatabaseQuoteSource();
            } else if (quoteSource == PreferencesManager.INTERNAL) {
                sourceInstance = QuoteSourceFactory.createInternalQuoteSource();
            } else {
                if (!$assertionsDisabled && quoteSource != PreferencesManager.SAMPLES) {
                    throw new AssertionError();
                }
                sourceInstance = QuoteSourceFactory.createSamplesQuoteSource();
            }
        }
        return sourceInstance;
    }

    static {
        $assertionsDisabled = !QuoteSourceManager.class.desiredAssertionStatus();
        sourceInstance = null;
    }
}

