/*
 * Decompiled with CFR 0.152.
 */
package org.mov.quote;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.mov.parser.EvaluationException;
import org.mov.quote.MissingQuoteException;
import org.mov.quote.QuoteBundle;
import org.mov.quote.QuoteBundleCache;
import org.mov.quote.QuoteBundleIterator;
import org.mov.quote.QuoteCache;
import org.mov.quote.QuoteNotLoadedException;
import org.mov.quote.QuoteRange;
import org.mov.quote.QuoteSourceManager;
import org.mov.quote.Symbol;
import org.mov.quote.WeekendDateException;
import org.mov.util.TradingDate;

public class ScriptQuoteBundle
implements QuoteBundle {
    private QuoteRange quoteRange;
    protected QuoteCache quoteCache;
    protected QuoteBundleCache quoteBundleCache;
    private int firstDateOffset = 1;
    private int lastDateOffset = 1;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ScriptQuoteBundle(QuoteRange quoteRange) {
        this.quoteRange = quoteRange;
        this.quoteCache = QuoteCache.getInstance();
        this.quoteBundleCache = QuoteBundleCache.getInstance();
        this.quoteBundleCache.load(this);
    }

    public ScriptQuoteBundle(QuoteBundle quoteBundle) {
        this(quoteBundle.getQuoteRange());
    }

    public double getQuote(Symbol symbol, int quoteType, int dateOffset) throws MissingQuoteException {
        double quote;
        block7: {
            try {
                quote = this.quoteCache.getQuote(symbol, quoteType, dateOffset);
            }
            catch (QuoteNotLoadedException e) {
                try {
                    quote = this.tryReload(symbol, quoteType, dateOffset);
                }
                catch (QuoteNotLoadedException e2) {
                    if (this.getQuoteRange().getFirstDate() != null && dateOffset < this.getFirstDateOffset()) {
                        try {
                            quote = this.tryExpand(symbol, quoteType, dateOffset);
                            break block7;
                        }
                        catch (QuoteNotLoadedException e3) {
                            throw MissingQuoteException.getInstance();
                        }
                    }
                    throw MissingQuoteException.getInstance();
                }
            }
        }
        return quote;
    }

    public double getQuote(Symbol symbol, int quoteType, int today, int offset) throws EvaluationException, MissingQuoteException {
        return this.getQuote(symbol, quoteType, today + offset);
    }

    public double getQuote(Symbol symbol, int quoteType, TradingDate date) throws MissingQuoteException {
        double quote;
        try {
            quote = this.getQuote(symbol, quoteType, this.quoteCache.dateToOffset(date));
        }
        catch (WeekendDateException e) {
            throw MissingQuoteException.getInstance();
        }
        return quote;
    }

    public boolean containsQuote(Symbol symbol, int dateOffset) {
        return this.getQuoteRange().containsSymbol(symbol) && dateOffset >= this.getFirstDateOffset() && dateOffset <= this.getLastDateOffset();
    }

    public boolean containsQuote(Symbol symbol, TradingDate date) {
        try {
            return this.containsQuote(symbol, this.quoteCache.dateToOffset(date));
        }
        catch (WeekendDateException e) {
            return false;
        }
    }

    public Iterator iterator() {
        return new QuoteBundleIterator(this);
    }

    public QuoteRange getQuoteRange() {
        return this.quoteRange;
    }

    public void setQuoteRange(QuoteRange quoteRange) {
        this.quoteRange = quoteRange;
        this.lastDateOffset = 1;
        this.firstDateOffset = 1;
    }

    public Symbol getFirstSymbol() {
        int dateOffset = this.getFirstDateOffset();
        while (dateOffset <= this.getLastDateOffset()) {
            List symbols;
            if ((symbols = this.getSymbols(dateOffset++)).size() <= 0) continue;
            return (Symbol)symbols.get(0);
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    private List getSymbols(int firstDateOffset, int lastDateOffset) {
        if (!this.quoteBundleCache.isLoaded(this)) {
            this.quoteBundleCache.load(this);
        }
        if (this.getQuoteRange().getType() == 4) {
            ArrayList<Symbol> presentSymbols = new ArrayList<Symbol>();
            List allSymbols = this.quoteCache.getSymbols(firstDateOffset, lastDateOffset);
            List expectedSymbols = this.getQuoteRange().getAllSymbols();
            Iterator iterator = expectedSymbols.iterator();
            while (iterator.hasNext()) {
                Symbol symbol = (Symbol)iterator.next();
                if (!allSymbols.contains(symbol)) continue;
                presentSymbols.add(symbol);
            }
            return presentSymbols;
        }
        if (this.getQuoteRange().getType() == 2) {
            return this.quoteCache.getSymbols(firstDateOffset, lastDateOffset);
        }
        if (this.getQuoteRange().getType() == 1) {
            ArrayList<Symbol> ourSymbols = new ArrayList<Symbol>();
            List symbols = this.quoteCache.getSymbols(firstDateOffset, lastDateOffset);
            Iterator iterator = symbols.iterator();
            while (iterator.hasNext()) {
                Symbol symbol = (Symbol)iterator.next();
                if (QuoteSourceManager.getSource().isMarketIndex(symbol)) continue;
                ourSymbols.add(symbol);
            }
            return ourSymbols;
        }
        if (!$assertionsDisabled && this.getQuoteRange().getType() != 3) {
            throw new AssertionError();
        }
        ArrayList<Symbol> ourSymbols = new ArrayList<Symbol>();
        List symbols = this.quoteCache.getSymbols(firstDateOffset, lastDateOffset);
        Iterator iterator = symbols.iterator();
        while (iterator.hasNext()) {
            Symbol symbol = (Symbol)iterator.next();
            if (!QuoteSourceManager.getSource().isMarketIndex(symbol)) continue;
            ourSymbols.add(symbol);
        }
        return ourSymbols;
    }

    public List getAllSymbols() {
        return this.getSymbols(this.getFirstDateOffset(), this.getLastDateOffset());
    }

    public List getSymbols(int dateOffset) {
        return this.getSymbols(dateOffset, dateOffset);
    }

    public List getSymbols(TradingDate date) {
        try {
            return this.getSymbols(this.quoteCache.dateToOffset(date));
        }
        catch (WeekendDateException e) {
            return new ArrayList();
        }
    }

    public TradingDate getFirstDate() {
        if (this.quoteRange.getFirstDate() != null) {
            return this.quoteRange.getFirstDate();
        }
        return QuoteSourceManager.getSource().getFirstDate();
    }

    public TradingDate getLastDate() {
        if (this.quoteRange.getLastDate() != null) {
            return this.quoteRange.getLastDate();
        }
        return QuoteSourceManager.getSource().getLastDate();
    }

    public int getFirstDateOffset() {
        block5: {
            if (this.firstDateOffset == 1) {
                try {
                    this.firstDateOffset = this.quoteCache.dateToOffset(this.getFirstDate());
                }
                catch (WeekendDateException e) {
                    TradingDate firstDate = this.getFirstDate();
                    firstDate = !firstDate.equals(this.getLastDate()) ? firstDate.next(1) : QuoteSourceManager.getSource().getFirstDate().next(1);
                    try {
                        this.firstDateOffset = this.quoteCache.dateToOffset(this.getFirstDate());
                    }
                    catch (WeekendDateException e2) {
                        if ($assertionsDisabled) break block5;
                        throw new AssertionError();
                    }
                }
            }
        }
        return this.firstDateOffset;
    }

    public int getLastDateOffset() {
        block5: {
            if (this.lastDateOffset == 1) {
                try {
                    this.lastDateOffset = this.quoteCache.dateToOffset(this.getLastDate());
                }
                catch (WeekendDateException e) {
                    TradingDate lastDate = this.getLastDate();
                    lastDate = !lastDate.equals(this.getFirstDate()) ? lastDate.previous(1) : QuoteSourceManager.getSource().getLastDate().next(1);
                    try {
                        this.lastDateOffset = this.quoteCache.dateToOffset(this.getLastDate());
                    }
                    catch (WeekendDateException e2) {
                        if ($assertionsDisabled) break block5;
                        throw new AssertionError();
                    }
                }
            }
        }
        return this.lastDateOffset;
    }

    public TradingDate offsetToDate(int dateOffset) {
        return this.quoteCache.offsetToDate(dateOffset);
    }

    public int dateToOffset(TradingDate date) throws WeekendDateException {
        return this.quoteCache.dateToOffset(date);
    }

    public String toString() {
        return this.quoteRange.toString();
    }

    private double tryReload(Symbol symbol, int quoteType, int dateOffset) throws QuoteNotLoadedException {
        if (!this.quoteBundleCache.isLoaded(this)) {
            this.quoteBundleCache.load(this);
            return this.quoteCache.getQuote(symbol, quoteType, dateOffset);
        }
        throw QuoteNotLoadedException.getInstance();
    }

    private double tryExpand(Symbol symbol, int quoteType, int dateOffset) throws QuoteNotLoadedException {
        QuoteRange expandedQuoteRange = (QuoteRange)this.getQuoteRange().clone();
        TradingDate date = this.quoteCache.offsetToDate(dateOffset);
        expandedQuoteRange.setFirstDate(date);
        this.quoteBundleCache.expand(this, expandedQuoteRange);
        return this.quoteCache.getQuote(symbol, quoteType, dateOffset);
    }

    static {
        $assertionsDisabled = !ScriptQuoteBundle.class.desiredAssertionStatus();
    }
}

