/*
 * Decompiled with CFR 0.152.
 */
package org.mov.quote;

import java.util.HashMap;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.mov.quote.QuoteSourceManager;
import org.mov.quote.SymbolFormatException;
import org.mov.util.Locale;

public class Symbol
implements Cloneable,
Comparable {
    private String symbol;
    public static final int MINIMUM_SYMBOL_LENGTH = 1;
    public static final int MAXIMUM_SYMBOL_LENGTH = 12;
    private static HashMap registry = new HashMap();

    private Symbol(String string) throws SymbolFormatException {
        if (string.length() > 12) {
            throw new SymbolFormatException(Locale.getString("SYMBOL_TOO_LONG", string));
        }
        if (string.length() < 1) {
            throw new SymbolFormatException(Locale.getString("SYMBOL_TOO_SHORT", string));
        }
        for (int i = 0; i < string.length(); ++i) {
            char letter = string.charAt(i);
            if (Character.isLetter(letter) || Character.isDigit(letter) || letter == '.' || letter == '^') continue;
            throw new SymbolFormatException(Locale.getString("INVALID_SYMBOL", string));
        }
        this.symbol = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Symbol find(String string) throws SymbolFormatException {
        String upperCaseString = string.toUpperCase();
        Symbol symbol = (Symbol)registry.get(upperCaseString);
        if (symbol == null) {
            HashMap hashMap = registry;
            synchronized (hashMap) {
                symbol = (Symbol)registry.get(upperCaseString);
                if (symbol == null) {
                    symbol = new Symbol(upperCaseString);
                    registry.put(upperCaseString, symbol);
                }
            }
        }
        return symbol;
    }

    public String get() {
        return this.symbol;
    }

    public int length() {
        return this.symbol.length();
    }

    public char charAt(int offset) {
        return this.symbol.charAt(offset);
    }

    public static SortedSet toSortedSet(String string, boolean checkExists) throws SymbolFormatException {
        Pattern pattern = Pattern.compile("[, ]+");
        String[] symbols = pattern.split(string);
        TreeSet<Symbol> sortedSet = new TreeSet<Symbol>();
        for (int i = 0; i < symbols.length; ++i) {
            if (symbols[i].length() <= 0) continue;
            Symbol symbol = Symbol.find(symbols[i]);
            if (checkExists && !QuoteSourceManager.getSource().symbolExists(symbol)) {
                throw new SymbolFormatException(Locale.getString("NO_QUOTES_SYMBOL", symbols[i]));
            }
            sortedSet.add(symbol);
        }
        return sortedSet;
    }

    public static Symbol toSymbol(String string) throws SymbolFormatException {
        SortedSet symbols = Symbol.toSortedSet(string, true);
        Object[] symbolsArray = symbols.toArray();
        if (symbolsArray.length > 1) {
            throw new SymbolFormatException(Locale.getString("EXPECTING_SINGLE_SYMBOL"));
        }
        if (symbolsArray.length == 0) {
            throw new SymbolFormatException(Locale.getString("MISSING_SYMBOL"));
        }
        return (Symbol)symbolsArray[0];
    }

    public Object clone() {
        return this;
    }

    public int compareTo(Object object) {
        return this.toString().compareTo(object.toString());
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public int hashCode() {
        return this.symbol.hashCode();
    }

    public String toString() {
        return this.symbol;
    }
}

