/*
 * Decompiled with CFR 0.152.
 */
package org.mov.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.mov.portfolio.Portfolio;
import org.mov.quote.MissingQuoteException;
import org.mov.quote.QuoteBundle;
import org.mov.quote.Symbol;
import org.mov.ui.AbstractTableModel;
import org.mov.ui.ChangeFormat;
import org.mov.ui.Column;
import org.mov.util.Locale;
import org.mov.util.Money;
import org.mov.util.TradingDate;

public class PortfolioModel
extends AbstractTableModel {
    private QuoteBundle quoteBundle;
    private Portfolio portfolio;
    private List values;
    public static final int DATE_COLUMN = 0;
    public static final int STOCKS_HELD_COLUMN = 1;
    public static final int CASH_VALUE_COLUMN = 2;
    public static final int SHARE_VALUE_COLUMN = 3;
    public static final int MARKET_VALUE_COLUMN = 4;
    public static final int RETURN_VALUE_COLUMN = 5;
    public static final int MARKET_VALUE_CHANGE_COLUMN = 6;
    public static final int PERCENT_CHANGE_COLUMN = 7;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PortfolioModel(Portfolio portfolio, QuoteBundle quoteBundle) {
        if (!$assertionsDisabled && portfolio.getSymbolsTraded().size() != 0 && quoteBundle == null) {
            throw new AssertionError();
        }
        this.portfolio = portfolio;
        this.quoteBundle = quoteBundle;
        this.values = this.calculateValues();
        ArrayList<Column> columns = new ArrayList<Column>();
        columns.add(new Column(0, Locale.getString("DATE"), Locale.getString("DATE_COLUMN_HEADER"), TradingDate.class, 1));
        columns.add(new Column(1, Locale.getString("STOCKS_HELD"), Locale.getString("STOCKS_HELD_COLUMN_HEADER"), String.class, 1));
        columns.add(new Column(2, Locale.getString("CASH_VALUE"), Locale.getString("CASH_VALUE_COLUMN_HEADER"), Money.class, 0));
        columns.add(new Column(3, Locale.getString("SHARE_VALUE"), Locale.getString("SHARE_VALUE_COLUMN_HEADER"), Money.class, 0));
        columns.add(new Column(4, Locale.getString("MARKET_VALUE"), Locale.getString("MARKET_VALUE_COLUMN_HEADER"), Money.class, 1));
        columns.add(new Column(5, Locale.getString("RETURN_VALUE"), Locale.getString("RETURN_VALUE_COLUMN_HEADER"), Money.class, 0));
        columns.add(new Column(6, Locale.getString("MARKET_VALUE_CHANGE"), Locale.getString("MARKET_VALUE_CHANGE_COLUMN_HEADER"), Money.class, 1));
        columns.add(new Column(7, Locale.getString("PERCENT_CHANGE"), Locale.getString("PERCENT_CHANGE_COLUMN_HEADER"), ChangeFormat.class, 1));
        this.setColumns(columns);
    }

    public int getRowCount() {
        return this.values.size();
    }

    public Object getValueAt(int row, int column) {
        if (row >= this.getRowCount()) {
            return "";
        }
        PortfolioValue today = (PortfolioValue)this.values.get(row);
        switch (column) {
            case 0: {
                return today.date;
            }
            case 1: {
                return today.stocksHeld;
            }
            case 2: {
                return today.cashValue;
            }
            case 3: {
                return today.shareValue;
            }
            case 4: {
                return today.marketValue;
            }
            case 5: {
                return today.returnValue;
            }
            case 6: {
                if (row > 0) {
                    PortfolioValue yesterday = (PortfolioValue)this.values.get(row - 1);
                    return today.marketValue.subtract(yesterday.marketValue);
                }
                return Money.ZERO;
            }
            case 7: {
                Money todayValue;
                Money yesterdayValue = todayValue = today.marketValue;
                if (row > 0) {
                    PortfolioValue yesterday = (PortfolioValue)this.values.get(row - 1);
                    yesterdayValue = yesterday.marketValue;
                }
                return new ChangeFormat(yesterdayValue, todayValue);
            }
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return "";
    }

    private List calculateValues() {
        ArrayList<PortfolioValue> values = new ArrayList<PortfolioValue>();
        List dateRange = this.generateDateRange();
        Iterator portfolioIterator = this.portfolio.iterator();
        Iterator dateIterator = dateRange.iterator();
        while (dateIterator.hasNext()) {
            TradingDate date = (TradingDate)dateIterator.next();
            Portfolio portfolio = (Portfolio)portfolioIterator.next();
            try {
                PortfolioValue value = new PortfolioValue();
                value.date = date;
                value.cashValue = portfolio.getCashValue();
                value.shareValue = portfolio.getShareValue(this.quoteBundle, date);
                value.marketValue = portfolio.getValue(this.quoteBundle, date);
                value.returnValue = portfolio.getReturnValue(this.quoteBundle, date);
                value.stocksHeld = this.getStocksHeld(portfolio);
                values.add(value);
            }
            catch (MissingQuoteException e) {}
        }
        return values;
    }

    private List generateDateRange() {
        List dateRange;
        if (this.portfolio.countTransactions() == 0) {
            dateRange = new ArrayList();
        } else {
            TradingDate firstDate = this.portfolio.getStartDate();
            TradingDate lastDate = this.portfolio.getLastDate();
            if (this.quoteBundle != null && this.quoteBundle.getLastDate() != null && this.quoteBundle.getLastDate().after(lastDate)) {
                lastDate = this.quoteBundle.getLastDate();
            }
            dateRange = TradingDate.dateRangeToList(firstDate, lastDate);
        }
        return dateRange;
    }

    private String getStocksHeld(Portfolio portfolio) {
        String string = new String();
        List stocksHeld = portfolio.getStocksHeld();
        Collections.sort(stocksHeld);
        Iterator iterator = stocksHeld.iterator();
        while (iterator.hasNext()) {
            Symbol symbol = (Symbol)iterator.next();
            if (string.length() > 0) {
                string = string.concat(", " + symbol.toString());
                continue;
            }
            string = symbol.toString();
        }
        return string;
    }

    static {
        $assertionsDisabled = !PortfolioModel.class.desiredAssertionStatus();
    }

    private class PortfolioValue {
        public TradingDate date;
        public Money marketValue;
        public Money cashValue;
        public Money shareValue;
        public Money returnValue;
        public String stocksHeld;

        private PortfolioValue() {
        }
    }
}

